#/***************************************************************************
 $RCSfile: newstandingorder.cpp,v $
                             -------------------
    cvs         : $Id: newstandingorder.cpp,v 1.6 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Sat Jun 29 2002
    copyright   : (C) 2002 by Fabian Kaiser
    email       : openhbci@derzach.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



/*
 */

#include "newstandingorder.h"


HBCI::Error newStandingOrder(HBCI::Pointer<AQMAPI> hbciif,
			     HBCI::SimpleConfig &opt){
    HBCI::Pointer<HBCI::OutboxJob> job;
    HBCI::Tree<HBCI::ConfigNode>::iterator var;
    int country;
    string instid;
    string custid;
    string accnr;
    string tfile;
    HBCI::Pointer<HBCI::Loader> loader;
    list<HBCI::Pointer<HBCI::Account> > accounts;
    list<HBCI::StandingOrder> orders;
    list<HBCI::StandingOrder>::iterator oit;
    HBCI::Pointer<HBCI::Account> account;
    HBCI::Error err, err1;
    HBCI::Pointer<HBCI::User> customer;
    HBCI::Pointer<HBCI::Customer> cust;

    account.setDescription("newStandingOrder::account");
    loader.setDescription("newStandingOrder::loader");
    loader=new HBCI::Loader(hbciif.ptr());
    custid=opt.getVariable("customer","",opt.root());
    job.setDescription("newStandingOrder:job (OutboxJob)");

    tfile=opt.getVariable("tfile","",opt.root());
	
    // load the transaction file
    err1=loader.ref().readStandingOrderFile(tfile, orders);
    if (!err1.isOk())
        return err1;

    // create jobs
    for (oit=orders.begin();
         oit!=orders.end();
         oit++) {
	  
        // get account
        country = (*oit).ourCountryCode();
        instid = (*oit).ourBankCode();
        accnr = (*oit).ourAccountId();

        if (0 == country)
            country = 280;
        account = hbciif.ref().findAccount(country, instid, accnr);
        if (!account.isValid()) {
            return HBCI::Error("newstdorder()",
                             ERROR_LEVEL_NORMAL,
                             0,
                             ERROR_ADVISE_DONTKNOW,
                             "account not found");
        }

        // get authorized customer for this account
        if (!custid.empty()) {
            // customer given
            cust=account.ref().bank().ref().findCustomer(custid);
            if (!cust.isValid())
                return HBCI::Error("newstandingorders()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "customer not found");
            if (!(account.ref().isAuthorized(cust)))
                return HBCI::Error("newstandingorders()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "customer is not authorized");
        }
        else {
            // not given, try the first in the list
            list<HBCI::Pointer<HBCI::Customer> > custlist;

            custlist=account.ref().authorizedCustomers();
            if (custlist.empty())
                return HBCI::Error("newstandingorders()",
                                 ERROR_LEVEL_NORMAL,
                                 0,
                                 ERROR_ADVISE_DONTKNOW,
                                 "no authorized customer for this account");
            cust=custlist.front();
        }


        // create job for this account
        job=new HBCI::OutboxJobNewStandingOrder(cust,account, (*oit));

        // enqueue job
        hbciif.ref().addJob(job);
    } // for

    try {
        // execute queue
        err=hbciif.ref().executeQueue(true);
    }
    catch (HBCI::Error lerr) {
        err=lerr;
    }

    return err;
}


