/***************************************************************************
 $RCSfile: sync.cpp,v $
                             -------------------
    cvs         : $Id: sync.cpp,v 1.7 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Wed Apr 17 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "sync.h"


HBCI::Error synchronize(HBCI::Pointer<AQMAPI> hbciif,
			HBCI::SimpleConfig &opt){
    HBCI::Pointer<HBCI::Customer> cust;
    int country;
    string instid;
    string userid;
    HBCI::Error err;
    int syncmode;
    string sm;
    HBCI::Pointer<HBCI::OutboxJob> job;
    HBCI::Pointer<HBCI::User> user;

    sm=opt.getVariable("syncmode","sysid",opt.root());

    syncmode=0;
    if (sm=="sysid")
        syncmode=2;
    //else if (sm=="sign")
    //    syncmode=1;
    else {
        return HBCI::Error("synchronize()",
                       ERROR_LEVEL_NORMAL,
                       0,
                       ERROR_ADVISE_DONTKNOW,
                       "Unknown syncmode.");
    }
    country=opt.getIntVariable("country",280,opt.root());
    instid=opt.getVariable("instid","",opt.root());
    userid=opt.getVariable("user","",opt.root());


    if (country==0 ||
        instid.empty() ||
        userid.empty())
        return HBCI::Error("synchronize()",
                       ERROR_LEVEL_NORMAL,
                       0,
                       ERROR_ADVISE_DONTKNOW,
                       "I need at least country,institute, and user.");

    user=hbciif.ref().findUser(country,
			       instid,
			       userid);
    if (!user.isValid())
	return HBCI::Error("synchronize()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "user not found.");
    if (user.ref().customers().empty())
	return HBCI::Error("synchronize()",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "no customers for this user.");
    cust=user.ref().customers().front();
    if (!cust.isValid())
	return HBCI::Error("synchronize()",
			   ERROR_LEVEL_NORMAL,
			   0,
			   ERROR_ADVISE_DONTKNOW,
			   "customer not found.");

    // get the keys
    job=new HBCI::OutboxJobGetSystemId(hbciif.ptr(),cust);
    // enqueue job
    hbciif.ref().addJob(job);

    try {
        err=hbciif.ref().executeQueue(true);
    }
    catch (HBCI::Error lerr) {
        err=lerr;
    } // catch

    return err;
}






