/* $Id: ArkTexture.h,v 1.17 2003/03/20 17:23:25 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_TEXTURE_H
#define ARK_TEXTURE_H

#include <Ark/Ark.h>
#include <Ark/ArkObject.h>
#include <Ark/ArkImage.h>

#include <vector>

namespace Ark
{
    // Forward declaration and typedefs
    class Texture;
    typedef Ptr<Texture> TexturePtr;
    typedef std::vector< TexturePtr > TextureList;
	 

   class Cache;
   class Image;

   //  ========================================================================
   /**
    * A texture in Ark is a renderer-memory representation of an image : it's
    * created using an image as a source, but the image data are not stored
    * directly in the texture, because they are sent to the renderer memory.
    *
    * What does it change for you ? For something that will be rendered w/o
    * texture preprocessing (ie a Model), you should use the Texture class
    * (more accurately the renderer texture class). On the other side, if you
    * want to access memory, to generate other textures by example, you should
    * use the image class.
    */
   //  ========================================================================

   class ARK_DLL_API Texture : public Object
   {
      public:
	 ImagePtr m_Image;

	 /// Image width, in pixels
	  uint m_Width;
	 
	 /// Image height, in pixels
	 uint m_Height;

	 /**
	  * Image format. Specifies bitmap depth, number of planes, etc..
	  * See Image::Format
	  */
	 Image::Format m_Format;
	 
	 /**
	  * Texture repeat mode: repeat  (wrap), or clamp.
	  */
	 Image::RepeatMode m_RepeatMode;
	 
      public:
	 /// Create a new texture using image 'img'
	 Texture (const String &name, Image *img);
	 
	 /// Create an empty texture
	 Texture (const String &name);
	 
	 /// Delete the given texture.
	 ~Texture ();

	 int GetWidth() const {return m_Width;}
	 int GetHeight() const {return m_Height;}
	 Image::Format GetFormat() const {return m_Format;}
	 Image::RepeatMode GetRepeatMode() const {return m_RepeatMode;}

	 /**
	  * Set the image associated with this texture (ie upload it
	  * to the renderer). Creating textures then setting their image
	  * is not always a good idea since no caching will be made on 
	  * textures created that way. Preffered method : cache->GetTexture().
	  */
	 virtual bool Configure();

     public:
	 /// Returns a string describing the object
	 String Dump (bool long_version);
   };

   
/* namespace Ark */
}

#endif
