# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::registry::find;
use base 'AXP::Command::registry';

sub infoline {
	"find archives and optionally branches by regexp"
}

sub optusage {
	"[options] archive_re [version_re]"
}

sub helptext {
	q{
		Currently, sourcecontrol.net provides a mirror for most of the
		public free software Arch archives. It provides a kind of the
		registry de-facto.

		This command searches the supermirror using regular expressions
		and lists all matched archives, and optionally their locations,
		and optionally all their versions.

		archive_re is a regular expression for archive,
		like 'tom' or '.*tom.*lab' or '^tomlord@' or ''.

		version_re is a regular expression for category/branch/version,
		like 'archway' or '^archway--.*--0' or '.*perl\b'.

		archive_re may include a slash, in this case, it is taken as a
		separator for archive_re and version_re, like 'gnuarch.*/tla--'.
	}
}

sub execute {
	my $self = shift;

	die "No archive and/or version regular expression\n" unless @ARGV;
	my $archive_re = shift @ARGV;
	my $version_re = shift @ARGV;
	($archive_re, $version_re) = split('/', $archive_re)
		if $archive_re =~ m!/!;

	my $archive_versions = $self->registry->search_supermirror(
		$archive_re, $version_re, 'hashref'
	);
	$self->print_output($archive_versions);
}

1;
