;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: plist.lisp,v 1.8 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 2001 - 2003 onShore Development, Inc.

(in-package :odcl)

(defun merge-plist (a b &aux c)
  (do ((a a (cddr a)))
      ((null a))
    (push (or (getf b (first a))
              (eval (second a))) c)
    (push (first a) c))
  c)

(defun memf (place indicator)
  "Return T if indicator appears in plist"
  (do ((place place (cddr place)))
      ((null place))
    (when (eql indicator (car place))
      (return-from memf t))))

(defun plist-remove-if (plist attr test)
  "Remove attribute from a plist if the value of that attribute matches
test"
  (when (funcall test (getf plist attr))
    (remf plist attr))
  plist)

(defun plist-reformat (plist old new fun)
  "Apply function fun to the value of old in the plist, remove old and
save the new value as nw"
  (let ((value (getf plist old)))
    (remf plist old)
    (setf (getf plist new)
          (funcall fun value))
    plist))

(defun plist-rename (plist old new)
  "Destructively rename a property in a plist"
  (when-bind (value (getf plist old))
    (remf plist old)
    (setf (getf plist new) value))
  plist)

(defun mapplist (function plist)
  (do* ((plist plist (cddr plist))
       (key (first plist) (first plist))
       (value (second plist) (second plist)))
      ((null plist))
    (apply function `(,key ,value))))
