;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: property-sheets.lisp,v 1.19 2003/09/11 22:11:50 craigl Exp $
;;;
;;; Copyright (c) 2000 - 2003 onShore Development, Inc.

(in-package :odcl)

;; ------------------------------------------------------------
;; Property Sheet Specifications

(defmethod get-property-sheet-spec (object set-name &aux proplist)
  (declare (ignore set-name))
  (dolist (property (properties-for-class (type-of object)))
    (destructuring-bind (name reader writer type caption)
        property
      (when reader
        (push (list name caption t type (not (null writer))) proplist))))
  (nreverse proplist))

(defun get-property-sheet-data (object set-name &optional (subset-name :standard) &aux proplist)
  "Given an object, a set name, and optionally a subset name, return
data for the purpose of displaying these properties.  This list is formatted:
  ((<property keyword> <caption> <:required or :optional> <display type symbol> [<edit allowed? boolean>]) ...)"
  (dolist (property-spec (get-property-sheet-spec object set-name))
    (if (eql property-spec :br)
        (push property-spec proplist)
        (destructuring-bind (name caption required display-type &optional (edit-allowed t))
            property-spec
          (let ((value (get-property object name)))
            (ecase subset-name
              (:all
               (push (list name caption value display-type edit-allowed) proplist))
              (:standard
               (when (or value (eql required :required))
                 (push (list name caption value display-type edit-allowed) proplist))))))))
  #+nil
  (unless proplist
    (error "get-property-sheet-data finds no data for ~s (~s properties)" object set-name))
  (nreverse proplist))

;; property templates, textual substitution and render to text.

(defun %property-template-resolver (vals ref)
  (let ((ref (read-from-string ref)))
    (etypecase ref
      (symbol
       (format nil "~A" (get-alist ref vals)))
      (list
       (etypecase (car ref)
         (keyword
          (multiple-value-bind (vals dt)
              (get-property (get-alist :root-instance vals) ref)
            (typecase vals
              (null
               (property-template-null-value dt))
              (list
               (string-join
                (mapcar #'(lambda (val)
                            (property-template-display dt val))
                        vals) ", "))
              (t
               (property-template-display dt vals)))))
         (symbol
	  (let ((*vals* vals))
	    (declare (special *vals*))
	    (eval ref))))))))




(defun fill-property-template (root-instance template
                               &key
                               aux-values
                               (sub-delim "$") (escape-char #\\))
  (fill-template (append aux-values
                         (list (cons :root-instance root-instance))) template
                 :sub-delim sub-delim
                 :escape-char escape-char
                 :template-resolver #'%property-template-resolver))

(defmethod property-template-null-value (type)
  (declare (ignore type))
  "")

(defmethod property-template-display (type value)
  (declare (ignore type))
  (princ-to-string value))
