/*
 * unit.h
 *
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __UNIT_H__
#define __UNIT_H__

#include "crafted_png.h"

typedef struct pud_unit_t
{
  gint16 x, y;
  gint8  type;
  gint8  player_number;
  gint16 value;
  GtkWidget *setting_dialog;
} pud_unit_t;

typedef struct UnitType 
{
   char     *identifier;
   char     *name;
   char     *filename;
   char     *filename2;
   gint      width, height;
   gint      tile_width, tile_height;
   Graphic **graphic;
} UnitType;

extern UnitType default_unit_types[];

extern gint nb_unit_types;

void fill_unit_lists(gint type, GtkWidget *gtklist);

#endif /* __UNIT_H__ */
