/* Distributed Checksum Clearinghouse
 *
 * count work
 *
 * Copyright (c) 2005 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.74-1.2 $Revision$
 */


#include "cmn_defs.h"
#include <signal.h>


TOTALS totals;

static void totals_msg_signal(int);
static void *totals_msg_thread(void *);



static void
totals_msg_signal(int ign UATTRIB)
{
	time_t now;

	signal(SIGUSR1, totals_msg_signal);
	now = time(0);
	totals_msg();
	totals.msg_next = now + 24*60*60;
}



static void *
totals_msg_thread(void *ign UATTRIB)
{
	time_t now, next;
	struct tm tm;
	int secs;

	totals.msg_prev = time(0);
	for (;;) {
		now = time(0);
		next = totals.msg_next;
		if (!next) {
			dcc_localtime(now, &tm);
			tm.tm_sec = 0;
			tm.tm_min = 0;
			tm.tm_hour = 0;
			++tm.tm_mday;
			next = mktime(&tm);
			if (next == -1) {
				dcc_error_msg("mktime() failed");
				next = now + 60*60;
			}
		}
		secs = next - now;
		do {
			secs = sleep(secs);
		} while (secs > 0);

		if (time(0) >= totals.msg_next)
			totals_msg();
	}
}



void
totals_init(void)
{
	pthread_t msg_tid;
	int i;

	signal(SIGUSR1, totals_msg_signal);

	i = pthread_create(&msg_tid, 0, totals_msg_thread, 0);
	if (i)
		dcc_logbad(EX_SOFTWARE, "pthread_create(totals msg): %s",
			   ERROR_STR1(i));
	i = pthread_detach(msg_tid);
	if (i)
		dcc_logbad(EX_SOFTWARE, "pthread_detach(totals msg): %s",
			   ERROR_STR1(i));
}
