/*
 *  Remote Network application system for DNAS -- GTK+ interface, and module system.
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: rnas-monitor-gtk.h,v 1.9 2002/09/28 11:55:11 dancer Exp $
 */

#ifndef RNAS_MONITOR_GTK_H_
#define RNAS_MONITOR_GTK_H_

#include <dlispparser.h>

/* 
 * prototype for the RNAS monitor application, for every plugins.
 *
 * The plugin interface.
 */

struct rnasmonitors;


/**
 * The struct for individual data / machine.
 *
 * Each machine has several of these, and each monitor driver handles 
 * several of these.
 */
typedef struct rnas_applicationdata 
{
  /** pointer to next item in the list */
  struct rnas_applicationdata * next;
  /** pointer to the data of the handler of this type of data */
  struct rnasmonitors * r ;		
  /** the window name */
  GtkWidget * w;
  /** random application data for the application */
  void * machine_applicationdata;
} rnas_applicationdata ;

/**
 * The struct for individual monitor driver.
 *
 * The driver will assign the function pointer to this.
 */
typedef struct rnasmonitors
{
  /** pointer to next item in the parameter list */
  struct rnasmonitors * next;
  /** function to update the display */
  int (*displayfunction)(struct rnas_applicationdata* r, dm_machinelist* dm);
  /** function to create a GTK new widget */
  GtkWidget* (*create_window_new)(const char* hostname, GtkWidget * hbox, struct rnasmonitors* r, rnas_applicationdata *m);
  /** lisp option data */
  dlisp_lispentry * l;
  /** any random data for the plugin side.  */
  void * applicationdata;
  /** data from lisp */
  const char * titlename;
  /** data from lisp */
  const char * tagname;      
  /** the version of the struct, change on every version */
  int serialversion;	
} rnasmonitors;

/** 
 * Initialize the monitor program.
 * Set values to the rnasmonitors struct.
 *
 * @return 1 if fail, 0 on successe
 */
int rnas_monitor_initialize (rnasmonitors * r /** pointer to the structure */);
/* following declarations are for application use only */
#ifndef RNAS_MONITOR_GTK_MAIN_CODE
/** 
 * Function to create a new window, given the hostname, and hbox to append to.
 * Plugin modules provide this symbol to rnasmonitors struct in 
 * rnas_monitor_initialize
 *
 * @return pointer to GTKWidget. It will be stored in rnas_applicationdata->w
 */
static GtkWidget* 
create_window_new(const char* hostname /** the host name of the data*/, 
		  GtkWidget * hbox /** The GTK+ hbox name*/,
		  rnasmonitors*r /** monitor specific data, universal through all window */,
		  rnas_applicationdata*m /** monitor specific and window specific data. */ ); 

/**
 * The routine to display value on the window with the 
 * data given through machinelist information.
 */
static int 
displayfunction(struct rnas_applicationdata* m /** thing to display */, 
		dm_machinelist* dm /** Data to show*/);

#endif /* RNAS_MONITOR_GTK_MAIN_CODE */


/** define the version of the interface */
#ifndef RNASMONITORVERSION
#define RNASMONITORVERSION 2
#else
#warning RNASMONITORVERSION is already defined.
#endif
/** The macro required to initialize a RNASMONITOR plugin,
    "r" variable is meant to be the rnasmonitors* r;
  */
#define INITIALIZE_RNASMONITOR(r)  \
  r->create_window_new = create_window_new; \
  r->displayfunction = displayfunction; \
  r->serialversion = RNASMONITORVERSION;

/** define a routine to check the version.
 * @return 1 if fail. 0 on success
 */
#define VERIFY_RNASVERSION(r) (r->serialversion != RNASMONITORVERSION)


/* funcs for use with plugins. */
const char * getnthlisp(dlisp_lispentry* l, int n);
int require_lisp_params(dlisp_lispentry* l, int n);

/* the createwindow funcs, internal to the application.  */
GtkWidget* CreateMainWindow(const char * title, rnasmonitors *r);
void CreateHeadingsOne(GtkWidget*hbox, const char * text);
void CreateApplicationDataTitle(GtkWidget* hbox, const char * s);



/* 
 * Some internal declarations.
 *
 */
/* some internal function for rnas-monitor-gtk */
rnasmonitors * load_plugins(char ** av);
/* just some debug */
#define DEBUGPRINT(A) /*printf("DEBUG: %s\n", A);*/



#endif
