/*
 *  Remote Network application system for DNAS
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: rnas-dump.c,v 1.10 2002/12/01 11:13:01 dancer Exp $
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "rnas-common.h"



static void
rnas_dump_printhelp(void)
{
  fprintf(stderr, 
	  "RNAS dump application, Copyright (c)2002 Junichi Uekawa.\n\n"
	  "\trnas-dump [DNAS options] -- [dump parameter]\n"
	  "Please specify dump parameter\n\n\n"
	  );
  dmachinemon_print_commandline_help();      
}

static void
iterate_database_for_searchstrings(dm_machinelist * a, char ** search_string)
{
  const char * buf;
  int i=0;
  
  while (search_string[i])
    {
      buf = dm_get_value_text(a, search_string[i]);
      if (buf)
	printf ("%s ", buf);
      i++;
    }
}


static void
iterate_database(dm_machinelist * a, char ** search_string)
{
  if (!a)
    {
      fprintf (stderr, "zero info found\n");
      return ;      
    }
  
  for ( ; a; a=a->next)  
    {
      printf ("%s: ", a->machinename);
      
      iterate_database_for_searchstrings(a, search_string);
      printf ("\n");
    }
}

int
main(int ac, char ** av)
{
  dm_commandoption cdat;
  dmachinemon_parse_options(ac, av, &cdat);
  if (!cdat.parenthostname)
    {
      rnas_dump_printhelp();
      exit(1);
    }
  access_master (&cdat, cdat.parenthostname, cdat.port_client);
  
  if (!av[optind])
    {
      rnas_dump_printhelp();
      exit(1);
    }

  iterate_database(maininfo.machinedb, &av[optind]);
  
  exit(0);
}


/*
What follows is a m4 script!
MANUAL([.TH "rnas-dump" 1 "2002 Aug 6" "DNAS" "RNAS"
.SH NAME
rnas-dump \- Dump DNAS information with TAG
.SH SYNOPSIS
.BI "rnas-dump [" "dnas-options" "] -- " "TAG"
.SH "DESCRIPTION"

Outputs list of information that is available on the DNAS system
with the tag 
.B TAG
in space delimited plain text format.
Multiple 
.B TAG
can be specified.

.SH "DNAS OPTIONS"

] m4_include([dmachinemon-commandlineparser.inc]) COMMAND [

.SH "EXAMPLE"

.B "rnas-dump -p cambria.server.com -c 3007 load1"

.SH "AUTHOR"
Junichi Uekawa <dancer@mikilab.doshisha.ac.jp> <dancer@debian.org> <dancer@netfort.gr.jp>

.SH "SEE ALSO"
.RI "rnas-dump-xml (" 1 "), "
.RI "rnas-monitor-xml (" 1 ")"])

*/
