/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * super proxy program, receives the port number to listen on, and the command line parameter.
 */
/* 
 * 2001 Oct 2 
 * $Id: superproxy.c,v 1.7 2003/01/22 05:31:24 dancer Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <dmachinemon/dmachinemon.h>

static char * commandline = NULL ;

static int 
handle_clients(void * data)
{				/* access from clients. */
  int t = ((struct dm_handle_incoming_params*)data)->t;
  FILE* fout = (t!=-1)?fdopen(t, "w"):NULL;
  FILE* fin = popen (commandline, "r");
  int i;

  printf ("Client accessed!\n");
  if (fin == NULL || fout == NULL)
    {
      fprintf(stderr, "Error in file opening!\n");
      exit (1);
    }
  
  while ((i = fgetc(fin))!=EOF)
    {
      fputc (i, fout);
    }
  
  fclose(fin);
  fclose(fout);
  dm_tcp_free_incoming_params(data);
  return 0;  
}

int main (int ac, char ** av)
{
  commandline = av[2];
  
  if (av[1] && av[2])
    dm_tcp_host_setup("superproxy", av[1],
		      (void * )handle_clients);
  else
    {
      fprintf(stderr, "superproxy: \n"
	      "\t superproxy port [command-line]\n\n"
	      "Runs program and proxizes to port\n"
	      );
    }
  
  return 0;
   
}
