<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
*/

# Determines prefered language based on browser settings
# (HTTP_ACCEPT_LANGUAGE) with default to English. It caches the result
# in a session variable for efficiency.
# $suffix: file name suffix (LANG$suffix.php)
# Returns: language file name to include
function get_lang_inc( $suffix = '' )
{
    global $HTTP_SESSION_VARS;
    global $HTTP_SERVER_VARS;

    $path = dirname( $HTTP_SERVER_VARS['PATH_TRANSLATED'] );
    if( !$HTTP_SESSION_VARS['lang'] ) {
	$lang = 'en';
	$quality = 0.0;

	foreach( preg_split( '/[\s,]+/', $HTTP_SERVER_VARS['HTTP_ACCEPT_LANGUAGE'] ) as $l ) {
	    if( $p = strpos( $l, ';' ) ) { # there is a quality
		$q = substr( $l, strpos( $l, '=', $p )+1 );
		$l = substr( $l, 0, $p );
	    } else
		$q = 1.0;
	    if( $q > $quality && is_readable( "$path/lang/$l$suffix.php" ) ) {
		$lang = $l;
		$quality = $q;
		if( $q == 1.0 )
		    break;
	    }
	}
	$HTTP_SESSION_VARS['lang'] = $lang;
    } 

    return $path . '/lang/' . $HTTP_SESSION_VARS['lang'] . $suffix. '.php';
}

session_start();

include get_lang_inc();
?>
