#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# Unpublished work.  All Rights Reserved.
#
# The software contained on this media is the property of the
# DSTC Pty Ltd.  Use of this software is strictly in accordance
# with the license agreement in the accompanying LICENSE.DOC file.
# If your distribution of this software does not contain a
# LICENSE.DOC file then you have no rights to use this software
# in any manner and should contact DSTC at the address below
# to determine an appropriate licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of
# any kind.  In no event shall DSTC Pty Ltd be liable for
# damage of any kind arising out of or in connection with
# the use or performance of this software.
#
# Project:  Hector
# File:     $Source: /cvsroot/fnorb/fnorb/orb/uuid.py,v $
#
#############################################################################
"""
unique ID string generator

used to provide unique ids.  will eventually be replaced by a UUID
module, but i'm too lazy to implement that at this moment.

"""
#############################################################################

from   time   import time
from   random import randint


#############################################################################

def id():
    """Generate a unique ID string."""

    t = long((time() % 1.0) * 1.0e8)
    return "%08X-%04X" % (t, randint(0, 0xffff))


def uuid():
    """Generate an IETF RFC-xxxx UUID (one day)."""

    #fixme: needs a portable way to find the ethernet address ...
    t = long((time() % 1.0) * 1.0e8)
    l = (randint(0, 0xffff) << 16) | randint(0, 0xffff)
    return "%08X-%04X-%04X-%04X-%08X" % \
	   (t, randint(0,0xffff), randint(0,0xffff), randint(0,0xffff), l)


#############################################################################

if __name__ == "__main__":
    print uuid()


#############################################################################
