#!/usr/bin/env python

#
# As only one ORB can exist in the entire life of a process with
# Fnorb, we cannot have individual test suites creating and destroying
# their own ORBs. Even if there is only one ORB at any given point in
# time, you can't destroy the ORB and recreate it!
#
# So, it is up to the test infrastructure to create an ORB, and pass
# it to all the tests. The ORBRunner encapsulates this ORB, and also
# the thread that the main ORB event loop is running in.
#

from threading import Thread
from Fnorb.orb import BOA, CORBA

class ORBRunner:

    def __init__(self):
        # Initialise the ORB.
        self.orb = CORBA.ORB_init([], CORBA.ORB_ID)

    def __del__(self):
        pass

    def getORB(self):
        return self.orb
