#include <assert.h>
#include <iostream>
#include <stdlib.h>

#include <string>
#include <fstream>

#include <Client.h>
#include <Utils.h>

using namespace std;
using namespace CORBA;

int
run(ORB_ptr orb, int argc, char* argv[])
{
    try {
	Object_var obj = get_ior_from_file(orb, "Server.ref");
	if (is_nil(obj.in())) {
	    cerr << argv[0]
		 << ": cannot read IOR from Server.ref"
		 << endl;
	    return EXIT_FAILURE;
	}

	TestFixeds_var p = TestFixeds::_narrow(obj.in());
	assert(!is_nil(p.in()));

	FixedType fixed("3.50");

	FixedType returned = p->testFixed(fixed);

	cout << "Returned value: " << (CORBA::LongDouble) returned << endl;

    } catch (const Exception& ex) {
	write_ex(cerr, ex);
	return 1;
    }

    return 0;
}

int
main(int argc, char* argv[])
{
    int status = EXIT_SUCCESS;
    ORB_var orb;

    try {
        //
        // Create ORB
        //
        orb = ORB_init(argc, argv);

	//
	// Run the test
	//
	status = run(orb.in(), argc, argv);
    } catch (const Exception& ex) {
	write_ex(cerr, ex);
        status = EXIT_SUCCESS;
    }

    return status;
}

