#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GFObjects.py
#
# DESCRIPTION:
"""
Module for the majority of the objects that make up a form
"""
#
# NOTES:
#

from GFObj import GFObj

from gnue.common.apps import GDebug

#
# GFValue
#
# An object that can store and retrieve a value
#
class GFValue(GFObj):
  # Add value attrib support
  def __init__(self, parent=None, value=None, type='GFValue'):
    GFObj.__init__(self, parent, type)
    self._value = value

  def setValue(self, value):
    self._value = value

  def getValue(self):
    GDebug.printMesg(6, "Value = %s"% self._value)
    return self._value











