# GNU Enterprise Forms - Curses UI Driver - Page Widget
#
# Copyright 2000-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: page.py 6851 2005-01-03 20:59:28Z jcater $

import curses

from gnue.forms.uidrivers._base.widgets._base import UIWidget

# =============================================================================
# Page class
# =============================================================================

class UIPage (UIWidget):

  # ---------------------------------------------------------------------------
  # Initialize page
  # ---------------------------------------------------------------------------

  def createWidget (self, event, spacer):

    if hasattr (event.object, 'caption'):
      caption = event.object.caption
    else:
      caption = event.object.name

    event.parent.addPage (self, caption)

    (self.__x1, self.__y1, self.__x2, self.__y2) = event.parent.getCanvas ()

    self.__window = curses.newpad (self.__y2 - self.__y1, self.__x2 - self.__x1)
    self.__window.keypad (True)
    self.__window.bkgd (' ', self._uiDriver.attr ['background'])
    self.__cursor = (0, 0)

  # ---------------------------------------------------------------------------
  # Write a text to a given position
  # ---------------------------------------------------------------------------

  def write (self, x, y, text, attribute):

    self.__window.addstr (y, x, o(text), attribute)

  # ---------------------------------------------------------------------------
  # Write a special character to a given position
  # ---------------------------------------------------------------------------

  def putchar (self, x, y, char, attribute):

    self.__window.addch (y, x, char, attribute)

  # ---------------------------------------------------------------------------
  # Move the cursor to a given position
  # ---------------------------------------------------------------------------

  def move (self, x, y):

    self.__cursor = (x, y)

  # ---------------------------------------------------------------------------
  # Update screen and wait for user input
  # ---------------------------------------------------------------------------

  def wait (self):

    self.__window.move (self.__cursor [1], self.__cursor [0])
    self.__window.refresh (0, 0, self.__y1, self.__x1, self.__y2, self.__x2)
    return self.__window.getch ()

# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass'  : UIPage,
  'provides'   : 'GFPage',
  'container'  : 1,
  }
