#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
from qt import *

from gnue.common import events

from gnue.forms.GFForm import *
from gnue.forms.uidrivers._base.widgets._base import *
from gnue.forms.uidrivers.qt.common import *


#############################################################################
#############################################################################
#
# UI Objects
#
# A set of standard UI objects that allow us to move more code into UIbase
# These map generic functionality to the specific UI widget set in use by
# this driver.
#
#############################################################################
#############################################################################

#
# UIHelper
#
# Provides a UI widget set of std functions to reduce the number of functions
# require in each UIclass listed below.
#
class UIHelper(UIWidget):
  #
  # Functions limited to the Qt driver
  #
  def _addToCrossRef(self, widget,gfobject, uiobject):
    i = id(widget)  # ????
    self._uiDriver._IdToTkObj[i]=widget
    self._uiDriver._IdToGFObj[i]=gfobject
    self._uiDriver._IdToUIObj[i]=uiobject
#    widget.__origBackgroundColor = Qt.White # widget.getBackgroundColor()

  def _deleteFromCrossRef(self, widget, object):
    i = id(widget)
    try:
      del self._uiDriver._IdToTkObj[i]
      del self._uiDriver._IdToGFObj[i]
      del self._uiDriver._IdToUIObj[i]
    except:
      pass

  #
  # Override the base UIWidget functions
  #
  def show(self):
    print "showing", self.widgets
    for widget in self.widgets:
      widget.show()
##      widget.raise()

  def hide(self):
    print "hiding", self.widgets
    for widget in self.widgets:
      widget.show(0)

  def showModal(self):
    self.setModal(1)

  def destroy(self):
##    self.Destroy()
    pass

  def indexedFocus(self, index):
    self.widgets[index].setFocus()

  def setValue(self, value, index=0, enabled=1):
    # These must be here or dropdown style controls
    # will get events they shouldn't and break.
    widget = self.widgets[index]

    # Check if foreign key changed
    object = self._uiDriver._IdToGFObj[id(widget)]
    try:
      if object.style == "dropdown" and \
          not object._field._allowedValues == widget._origAllowedValues:
        widget._origAllowedValues = object._field._allowedValues
        widget.clear()
        for value in object._field._allowedValuesDescr:
          widget.insertString(value)
    except AttributeError:
      pass

    if object.style == "checkbox":
      widget.setChecked(value)
    else:
      widget.setText(value)
    widget.setEnabled(enabled)

##    if enabled:
##      widget.setBackgroundColor(widget.__origBackgroundColor)
##    else:
##      widget.setBackgroundColor(self._uiDriver._disabledColour)
##    widget.Refresh()

  def setCursorPosition(self, position, index=0):
    try:
      self.widgets[index].setCursorPosition(position)
    except AttributeError:
      pass  # For label-style entries

  def setSelectedArea(self, selection1, selection2, index=0):
    try:
      self.widgets[index].setSelection(selection1, selection2-selection1)
    except (AttributeError, TypeError):
      pass  # For label-style & dropdown entries

  def createWidget(self, event, spacer):
    newWidget = self._createWidget(event, spacer)
    initFont(newWidget)
    self._addToCrossRef(newWidget,event.object,self)
    return newWidget

  def cleanup(self, object):
    for widget in self.widgets[:]:
      i = id(widget)
      del self._uiDriver._IdToTkObj[i]
      del self._uiDriver._IdToGFObj[i]
      del self._uiDriver._IdToUIObj[i]
      self.widgets.pop(0)
      self._deleteFromCrossRef(widget, object)
