#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2004 Free Software Foundation
#
# $Id: PrinterDefs.py 6706 2004-11-22 12:26:58Z btami $
#
# DESCRIPTION:
#
# NOTES:
#

from Writer import Writer


class text(Writer):
  newLineCmd = "\n"
  newPageCmd = "\n" + 8*("%s" % "o---------")


class escp(Writer):
  # reset, 10 CPI, draft(not NLQ)
  reset = "\x1B@\x1BP\x1Bx0"

  beginCondensed = "\x0F"
  endCondensed = "\x12"

  beginBold = "\x1BE"
  endBold = "\x1BF"

  beginItalic = "\x1B4"
  endItalic = "\x1B5"

  beginUnderline = "\x1B-1"
  endUnderline = "\x1B-0"

  newLineCmd = "\r\n"
  newPageCmd = "\x0C"


class pcl5(Writer):
  # reset, fixed font, 
  reset = "\x1BE\x1B(s0P"

  # 16.67 CPI / 10 CPI
  beginCondensed = "\x1B(s16.67H"
  endCondensed = "\x1B(s10H"

  beginBold = "\x1B(s3B"
  endBold = "\x1B(s0B"

  beginItalic = "\x1B(s1S"
  endItalic = "\x1B(s0S"

  beginUnderline = "\x1B&d1D"
  endUnderline = "\x1B&d@"

  newLineCmd = "\r\n"
  newPageCmd = "\x1B&l0H"
