#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2004 Free Software Foundation
#
# $Id: Writer.py 6706 2004-11-22 12:26:58Z btami $
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Writer']


import string


class Writer:
  reset = ""
  beginCondensed = ""
  endCondensed = ""
  beginBold = ""
  endBold = ""
  beginItalic = ""
  endItalic = ""
  beginUnderline = ""
  endUnderline = ""
  newLineCmd = "\n"
  newPageCmd = "\n"


  def initialize(self, report):
    self.reportHeight = report.height
    self.reportWidth  = report.width

    self.pageNumber = 1
    self.currLine = 0
    
    self.pageHeaderDone = False
    self.pageFooterDone = False

    self.output.write(self.reset)


  def finalize(self):
    self.output.write(self.reset)


  def render(self, object, x, y, width, band,
                  align='none', condensed=False, bold=False,
                  italic=False, underline=False):

    # go to correct position in current band if needed...
    if y > band.y:
      self.newLine(y-band.y)
      band.y = y
      band.x = 0

    if x > band.x:
      self.output.write((x-band.x)*' ')
      band.x = x


    # start style
    if condensed:
      self.output.write(self.beginCondensed)
    if bold:
      self.output.write(self.beginBold)
    if italic:
      self.output.write(self.beginItalic)
    if underline:
      self.output.write(self.beginUnderline)


    self.output.write(_alignFunc[align](object, width))


    # end style
    if condensed:
      self.output.write(self.endCondensed)
    if bold:
      self.output.write(self.endBold)
    if italic:
      self.output.write(self.endItalic)
    if underline:
      self.output.write(self.endUnderline)


    # go to correct position in current band if needed...
    if width > len(object):
      self.output.write((width-len(object))*' ')
      
    band.x = x + width


  def newPage(self):
    self.pageNumber += 1
    self.currLine = 0
    self.pageHeaderDone = False
    self.pageFooterDone = False
    
    self.output.write(self.newPageCmd)


  def newLine(self, n=1):
    if self.PageFooter and (not self.pageFooterDone):
      if self.currLine + 1 > self.reportHeight - self.PageFooter.height:
        self.PageFooter.process(self)

    if self.currLine + 1 > self.reportHeight:
      self.newPage()

    if self.PageHeader and (not self.pageHeaderDone):
      self.PageHeader.process(self)

    for i in range(n):
      self.output.write(self.newLineCmd)
      self.currLine += 1


_alignFunc = {'left'   : lambda obj, width: string.ljust(obj, width),
              'right'  : lambda obj, width: string.rjust(obj, width),
              'center' : lambda obj, width: string.center(obj, width),
              'none'   : lambda obj, width: obj
             }
