#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# GRConfig.py
#
# DESCRIPTION:
#
# NOTES:
#
from gnue.common.formatting import GTypecast

ConfigOptions = (
  { 'Name'       : 'ReportsDir',
    'Type'       : 'Setting',
    'Comment'    : 'The default location for grd files.',
    'Description': 'The default location for grd files.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'reports' },

  { 'Name'       : 'FiltersDir',
    'Type'       : 'Setting',
    'Comment'    : 'The default location for filter files.',
    'Description': 'The default location for filter files.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'filters' },

  { 'Name'       : 'filters',
    'Type'       : 'Setting',
    'Comment'    : 'The default location for grd files.',
    'Description': 'The default location for grd files.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'report-filters.conf' },

  { 'Name'       : 'DefaultDestinationType',
    'Type'       : 'Setting',
    'Comment'    : 'The default destination type if none specified on command line.',
    'Description': 'The default destination type if none specified on command line.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'printer' },

  { 'Name'       : 'DefaultDestination',
    'Type'       : 'Setting',
    'Comment'    : 'The default destination if none specified on command line.',
    'Description': 'The default destination if none specified on command line.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'lp' },

  { 'Name'       : 'DefaultFilter',
    'Type'       : 'Setting',
    'Comment'    : 'The default filter if none specified on command line.',
    'Description': 'The default filter if none specified on command line.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'text' },

  { 'Name'       : 'FileAdapter',
    'Type'       : 'Setting',
    'Comment'    : 'The default adapter for -D file.',
    'Description': 'The default adapter for -D file.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'text' },

  { 'Name'       : 'EmailAdapter',
    'Type'       : 'Setting',
    'Comment'    : 'The default adapter for -D email.',
    'Description': 'The default adapter for -D email.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'sendmail' },

  { 'Name'       : 'PrinterAdapter',
    'Type'       : 'Setting',
    'Comment'    : 'The default adapter for -D printer.',
    'Description': 'The default adapter for -D printer.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'bsd' },

  { 'Name'       : 'FaxAdapter',
    'Type'       : 'Setting',
    'Comment'    : 'The default adapter for -D fax.',
    'Description': 'The default adapter for -D fax.',
    'Typecast'   :  GTypecast.text,
    'Default'    : 'hylafax' },

  { 'Name'       : 'SendmailFrom',
    'Type'       : 'Setting',
    'Comment'    : 'The email address to put in the from line of generated email.',
    'Description': 'The email address to put in the from line of generated email',
    'Typecast'   : GTypecast.text,
    'Default'    : 'GNUe Reports <noreply@localhost>'},

  { 'Name'       : 'SendmailBin',
    'Type'       : 'Setting',
    'Comment'    : 'The sendmail binary name.',
    'Description': 'The sendmail binary name.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'sendmail'},

  { 'Name'       : 'SendmailSubject',
    'Type'       : 'Setting',
    'Comment'    : 'The text to put in the Subject line of generated email.',
    'Description': 'The text to put in the Subject line of generated email.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'Your Requested Report'},

  { 'Name'       : 'HylafaxCommand',
    'Type'       : 'Setting',
    'Comment'    : 'The commandline to be run when sending report output to a fax.',
    'Description': 'The commandline to be run when sending report output to a fax.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'sendfax -d %s'},

  { 'Name'       : 'LprCommand',
    'Type'       : 'Setting',
    'Comment'    : 'The commandline to be run when sending report output to a fax.',
    'Description': 'Create new records in blocks automagically when you hit the bottom.',
    'Typecast'   : GTypecast.text,
    'Default'    : '/usr/bin/lpr -h -P%s'},
)
