#include "statement.h"

namespace GQL
{

namespace MySQL
{

using namespace std;

MyStatement::~MyStatement()
{
  if (result_set_)
    result_set_->unreference();
}

bool MyStatement::execute(const string& sql)
{
  clear_warnings();
  
  if (result_set_)
  {
    result_set_->unreference();
    result_set_ = 0;
  }
  
  MyConnection *conn = &dynamic_cast<MyConnection&>(*get_connection());
  MYSQL_RES *res = conn->exec_sql(sql);
  
  if (res)
  {
    result_set_ = manage(new MyResultSet(conn, res));
    result_set_->reference();
    update_count_ = -1;
  }
  else
    update_count_ = mysql_affected_rows(conn->mysql_connection());
  
  return true;
}

ResultSet *MyStatement::execute_query(const string& sql)
{
  execute(sql);
  
  return result_set_;
}

int MyStatement::execute_update(const string& sql)
{
  execute(sql);
  
  return update_count_;
}

}
}
