#include "result-set.h"
#include "result-set-metadata.h"

#include <sstream>

namespace GQL
{

namespace PG
{

using namespace std;

PGResultSet::PGResultSet(Connection *conn, PGresult *result)
    : ResultSet(conn) 
{
  result_ = result;
  rowno_ = -1;
  metadata_ = 0;
}

PGResultSet::~PGResultSet()
{
  if (result_)
    PQclear(result_);
  if (metadata_)
    metadata_->unreference();
}

bool PGResultSet::next() throw(SQLException)
{
  if (result_ && PQntuples(result_) > rowno_ + 1)
  {
    rowno_++;
    return true;
  }
  return false;
}

SQLObject *PGResultSet::get(int i, SQLObject *obj) const throw(SQLException)
{
  if (!result_)
    throw SQLException("ResultSet does not contain any data");

  if (i < 0 || i >= PQnfields(result_))
    throw SQLException("Attempt to access invalid field");

  if (PQgetisnull(result_, rowno_, i))
    obj->set_null();

  obj->from_string(string(PQgetvalue(result_, rowno_, i), 
                          PQgetlength(result_, rowno_, i)));

  return obj;
}

const ResultSetMetaData *PGResultSet::get_meta_data() const
{
  if (!metadata_)
  {
    PGResultSet *me = const_cast<PGResultSet *>(this);
    
    me->metadata_ = manage(
            new PGResultSetMetaData(me->get_connection(), result_));
    me->metadata_->reference();
  }
  
  return metadata_;
}

}

}
