
#include <iostream>

#include <sigc++/method_slot.h>
#include <sigc++/retype_return.h>
#include <sigcx/ref_slot.h>

#include <sigcx/tunnel.h>

#include <yehia/plugin.h>
#include <yehia/script.h>

#include <gql++/driver-manager.h>
#include <gql++/connection.h>
#include <gql++/statement.h>
#include <gql++/prepared-statement.h>
#include <gql++/callable-statement.h>
#include <gql++/database-metadata.h>
#include <gql++/result-set-metadata.h>

namespace
{

using namespace GQL;

// Little helpers for non-straightforward bindings

Yehia::PluginManager *dm_plugin_mgr(DriverManager& dm)
{
  return &dm.plugin_manager();
}

class MySQLType : public GQL::SQLType
{
  public:
    MySQLType() : GQL::SQLType() { }
    MySQLType(const GQL::SQLType& type) : GQL::SQLType(type) { }
    MySQLType(int typecode, int length, int decimals) : 
        GQL::SQLType((GQL::SQLType::TypeCode)typecode, length, decimals) { }
    virtual ~MySQLType() { }
};

MySQLType *sqlobj_to_type(const GQL::SQLObject& obj)
{
  return new MySQLType(obj.to_type());
}

void sqlobj_from_type(GQL::SQLObject& obj, const GQL::SQLType& type)
{
  obj.from_type(type);
}

//
// Yehia Script interface for namespace gql
//
void yehia_ns_gql_register(Yehia::Script::Language& lang)
{
  using namespace Yehia::Script;
  using SigC::retype_return;
  using SigC::slot;
  
  ObjectFactory& factory = lang.factory();
  Signature bases;
  
  NamespaceBuilder nsgql(factory, lang.root_namespace(), "gql");
  
  ClassBuilder<SQLType> clSQLType(factory, nsgql, "SQLType");
  clSQLType.constructor(WrapConstructor0<MySQLType>());
  clSQLType.constructor(WrapConstructor3<MySQLType, long, long, long>());
  clSQLType.getter("typecode", slot((long(SQLType::*)())&SQLType::typecode));
  clSQLType.getter("length", slot(&SQLType::length));
  clSQLType.getter("decimals", slot(&SQLType::decimals));
  ClassBuilder<SQLException> clSQLException(factory, nsgql, "SQLException");
  clSQLException.getter("message", slot(&SQLException::get_message));
  clSQLException.getter("error_code", slot(&SQLException::get_error_code));
  clSQLException.getter("sql_state", slot((std::string(SQLException::*)())&SQLException::get_sql_state));
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(SQLException));
  ClassBuilder<SQLWarning> clSQLWarning(factory, nsgql, "SQLWarning", bases);
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(SigC::Object));
  ClassBuilder<SQLObject> clSQLObject(factory, nsgql, "SQLObject", bases);
  clSQLObject.getter("is_null", slot(&SQLObject::is_null));
  clSQLObject.method("set_null", slot((void (SQLObject::*)(void))&SQLObject::set_null));
  clSQLObject.method("output", slot(&SQLObject::output));
  clSQLObject.method("input", slot(&SQLObject::input));
  clSQLObject.getter("string", slot(&SQLObject::to_string));
  clSQLObject.setter("string", slot(&SQLObject::from_string));
  clSQLObject.getter("boolean", slot(&SQLObject::to_boolean));
  clSQLObject.setter("boolean", slot(&SQLObject::from_boolean));
  clSQLObject.getter("integer", slot(&SQLObject::to_int));
  clSQLObject.setter("integer", slot(&SQLObject::from_int));
  clSQLObject.getter("real", slot(&SQLObject::to_real));
  clSQLObject.setter("real", slot(&SQLObject::from_real));
  clSQLObject.getter("blob", slot(&SQLObject::to_blob));
  clSQLObject.setter("blob", slot(&SQLObject::from_blob));
  clSQLObject.getter("type", slot(&::sqlobj_to_type));
  clSQLObject.setter("type", slot(&::sqlobj_from_type));
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(SigC::Object));
  ClassBuilder<Warnable> clWarnable(factory, nsgql, "Warnable", bases);
  clWarnable.constructor(Constructor0<Warnable>());
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(SigC::Object));
  ClassBuilder<DriverManager> clDriverManager(factory, nsgql, "DriverManager", bases);
  clDriverManager.constructor(Constructor0<DriverManager>());
  clDriverManager.constructor(Constructor1<DriverManager, Yehia::PluginManager&>());
  clDriverManager.constructor(Constructor2<DriverManager, Yehia::PluginManager&, const std::string&>());
  clDriverManager.method("get_connection", slot(&DriverManager::get_connection));
  clDriverManager.getter("registered_drivers", slot(&DriverManager::get_registered_drivers));
  clDriverManager.method("get_driver", slot(&DriverManager::get_driver));
  clDriverManager.getter("autoload", slot(&DriverManager::is_auto_load));
  clDriverManager.setter("autoload", slot(&DriverManager::set_auto_load));
  clDriverManager.getter("plugin_manager", slot(&::dm_plugin_mgr));
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(Warnable));
  ClassBuilder<DatabaseMetaData> clDatabaseMetaData(factory, nsgql, "DatabaseMetaData", bases);
  clDatabaseMetaData.method("get_tables", slot(&DatabaseMetaData::get_tables));
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(Warnable));
  ClassBuilder<Connection> clConnection(factory, nsgql, "Connection", bases);
  clConnection.method("create_statement", slot(&Connection::create_statement));
  clConnection.method("prepare_statement", slot(&Connection::prepare_statement));
  clConnection.method("prepare_call", slot(&Connection::prepare_call));
  clConnection.method("commit", slot(&Connection::commit));
  clConnection.method("rollback", slot(&Connection::rollback));
  clConnection.getter("auto_commit", slot(&Connection::get_auto_commit));
  clConnection.setter("auto_commit", slot(&Connection::set_auto_commit));
  clConnection.getter("catalog", slot(&Connection::get_catalog));
  clConnection.method("native_sql", slot(&Connection::native_sql));
  clConnection.getter("meta_data", slot(&Connection::get_meta_data));
  clConnection.getter("read_only", slot(&Connection::is_read_only));
  clConnection.setter("read_only", slot(&Connection::set_read_only));
  clConnection.method("create_object", slot(&Connection::create_object));
  clConnection.method("create_blob", slot(&Connection::create_blob));
  clConnection.method("destroy_blob", slot(&Connection::destroy_blob));
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(Warnable));
  ClassBuilder<Statement> clStatement(factory, nsgql, "Statement", bases);
  clStatement.method("execute", slot(&Statement::execute));
  clStatement.method("execute_query", slot(&Statement::execute_query));
  clStatement.method("execute_update", slot(&Statement::execute_update));
  clStatement.getter("connection", slot((Connection *(Statement::*)())&Statement::get_connection));
  clStatement.getter("update_count", slot(&Statement::get_update_count));
  clStatement.getter("result_set", slot(&Statement::get_result_set));
  clStatement.method("get_more_results", slot(&Statement::get_more_results));
  clStatement.getter("fetch_size", slot(&Statement::get_fetch_size));
  clStatement.setter("fetch_size", slot(&Statement::set_fetch_size));
  clStatement.getter("max_field_size", slot(&Statement::get_max_field_size));
  clStatement.setter("max_field_size", slot(&Statement::set_max_field_size));
  clStatement.getter("max_rows", slot(&Statement::get_max_rows));
  clStatement.setter("max_rows", slot(&Statement::set_max_rows));
  bases.erase(bases.begin(), bases.end());
  bases.push_back(&typeid(Warnable));
  ClassBuilder<ResultSet> clResultSet(factory, nsgql, "ResultSet", bases);
  clResultSet.method("next", slot(&ResultSet::next));
  clResultSet.method("get", slot(&ResultSet::get));
  clResultSet.getter("meta_data", slot(&ResultSet::get_meta_data));
  clResultSet.getter("connection", slot((Connection *(ResultSet::*)())&ResultSet::get_connection));
}

//
// Plugin 'gql'
//
class gqlPlugin : public Yehia::Plugin
{
  public:
    gqlPlugin(Yehia::PluginManager& mgr) : Plugin(mgr) {
      using namespace Yehia::Script;
      std::list<Language *> langs = LanguageManager::instance().languages();
      
      for (std::list<Language *>::iterator it = langs.begin();
           it != langs.end(); ++it)
      {
        SigCX::tunnel<void, Yehia::Script::Language&>(slot(&yehia_ns_gql_register), **it, (**it).tunnel());
      }
      LanguageManager::instance().language_registered.connect(SigC::slot(*this, &gqlPlugin::got_new_language));
    }
    virtual std::string description() const { return "GQL scripting support"; }
    void got_new_language(const std::string& name) {
      using namespace Yehia::Script;
      Language *lang = LanguageManager::instance().language(name);
      if (lang)
      {
        SigCX::tunnel<void, Yehia::Script::Language&>(slot(&yehia_ns_gql_register), *lang, (*lang).tunnel());
      }
    }
};

extern "C" Yehia::Plugin *yehia_gql_plugin_init(Yehia::PluginManager *mgr)
{
  try
  {
    mgr->load_plugin("ucxx");
    Yehia::Plugin *plugin = SigC::manage(new gqlPlugin(*mgr));
    plugin->reference();
    return plugin;
  }
  catch (...)
  {
    mgr->set_error("gqlPlugin initialisation failed");
    return 0;
  }
}


}

