module Control.Monad
  ( MonadPlus     -- class context: Monad
      ( mzero     -- :: (MonadPlus m) => m a
      , mplus     -- :: (MonadPlus m) => m a -> m a -> m a
      )
  , join          -- :: (Monad m) => m (m a) -> m a
  , guard         -- :: (MonadPlus m) => Bool -> m ()
  , when          -- :: (Monad m) => Bool -> m () -> m ()
  , unless        -- :: (Monad m) => Bool -> m () -> m ()
  , ap            -- :: (Monad m) => m (a -> b) -> m a -> m b
  , msum          -- :: (MonadPlus m) => [m a] -> m a
  , filterM       -- :: (Monad m) => (a -> m Bool) -> [a] -> m [a]
  , mapAndUnzipM  -- :: (Monad m) => (a -> m (b,c)) -> [a] -> m ([b], [c])
  , zipWithM      -- :: (Monad m) => (a -> b -> m c) -> [a] -> [b] -> m [c]
  , zipWithM_     -- :: (Monad m) => (a -> b -> m c) -> [a] -> [b] -> m ()
  , foldM         -- :: (Monad m) => (a -> b -> m a) -> a -> [b] -> m a 
  , foldM_        -- :: (Monad m) => (a -> b -> m a) -> a -> [b] -> m ()
    
  , liftM         -- :: (Monad m) => (a -> b) -> (m a -> m b)
  , liftM2        -- :: (Monad m) => (a -> b -> c) -> (m a -> m b -> m c)
  , liftM3        -- :: ...
  , liftM4        -- :: ...
  , liftM5        -- :: ...

  , Monad((>>=), (>>), return, fail)
  , Functor(fmap)

  , mapM          -- :: (Monad m) => (a -> m b) -> [a] -> m [b]
  , mapM_         -- :: (Monad m) => (a -> m b) -> [a] -> m ()
  , sequence      -- :: (Monad m) => [m a] -> m [a]
  , sequence_     -- :: (Monad m) => [m a] -> m ()
  , replicateM    -- :: (Monad m) => Int -> m a -> m [a]
  , replicateM_   -- :: (Monad m) => Int -> m a -> m ()
  , (=<<)         -- :: (Monad m) => (a -> m b) -> m a -> m b

  ) where

import Prelude
import Data.Maybe
import Monad

foldM_            :: (Monad m) => (a -> b -> m a) -> a -> [b] -> m ()
foldM_ f a xs     = foldM f a xs >> return ()

replicateM        :: (Monad m) => Int -> m a -> m [a]
replicateM n x    = sequence (replicate n x)

replicateM_       :: (Monad m) => Int -> m a -> m ()
replicateM_ n x   = sequence_ (replicate n x)

