/*
 *      Console:   Graphical text output routines
 */

#ifndef __IRCONSOLE
#define __IRCONSOLE

#include <allegro.h>

#ifdef __cplusplus
extern "C" {
#endif

extern void irecon_init(int x, int y, int w, int h);
extern void irecon_term();
extern void irecon_update();
extern void irecon_cls();
extern int irecon_font(int fnum);
extern int irecon_loadfont(int no);
extern void irecon_registerfont(char *ffile, int no);
extern void irecon_loadfonts();
extern void irecon_mouse(int mouse);
extern void irecon_clearline();
extern void irecon_newline();
extern void irecon_colour(int r, int g, int b);
extern void irecon_colourfont();
extern void irecon_savecol();
extern void irecon_loadcol();
extern void irecon_print(char *msg);
extern void irecon_printf(char *msg,...);
extern void irecon_printxy(int x, int y, char *msg);
extern int  irecon_getinput(char *buffer, int maxlen);
extern void Show();
extern void ShowPartial(int x, int y, int w, int h);
extern void ShowSimple();
extern void Bug(char *msg,...);
extern void KillGFX();
extern int console_x,console_y,console_w,console_h,ilog_break;

extern FONT *curfont;

#ifdef __cplusplus
}
#endif

#endif
