// Copyright (c) 2003,2004 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.

#ifndef OBLIQUE_H
#define OBLIQUE_H

#include <noatun/playlist.h>
#include <noatun/plugin.h>
#include "query.h"
#include "kdatacollection.h"

class View;
class Base;
class Selector;
class TreeItem;

class Oblique : public Playlist, public Plugin
{
Q_OBJECT
	View *mView;
	Base *mBase;
	Slice *mSlice;
	Query mQuery;
	QString mFileOfQuery;
	Selector *mSelector;
	KDataCollection mSchemaCollection;

	// the id of the next file to load
	FileId mDeferredLoaderAt;
	// can be one of three things:
	// 0: we're not compacting
	// < mDeferredLoaderAt: the id of an empty slot
	// ==mDeferredLoaderAt: there are no empty slots
	FileId mLoaderCompactorAt;

public:
	Oblique();
	~Oblique();

	Query *query() { return &mQuery; }
	Base *base() { return mBase; }

	KDataCollection &schemaCollection() { return mSchemaCollection; }

	/**
	 * load the query by its name in the KDataCollection, and save the name
	 * for @ref fileOfQuery()
	 *
	 * also have the current slice have its default query set to it
	 **/
	bool setQuery(const QString &name, bool compact=false);
	QString fileOfQuery() const { return mFileOfQuery; }

	virtual void reset();
	virtual void clear();
	virtual void addFile(const KURL&, bool play=false);
	virtual PlaylistItem next();
	virtual PlaylistItem previous();
	virtual PlaylistItem current();
	virtual void setCurrent(const PlaylistItem &);
	virtual PlaylistItem getFirst() const;
	virtual PlaylistItem getAfter(const PlaylistItem &item) const;
	virtual bool listVisible() const;
	virtual void showList();
	virtual void hideList();

	virtual Playlist *playlist() { return this; }

	Slice *slice() { return mSlice; }

public slots:
	void selected(TreeItem *cur);
	void reload();

	void use(Slice *slice);

signals:
	void sliceSelected(Slice *slice);

private slots:
	void loadItemsDeferred();
	void loopTypeChange(int i);
};


#endif
