/***************************************************************************
                          dpluginmanager.h  -  description
                             -------------------
    begin                : ? 10? 27 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DPLUGINMANAGER_H
#define DPLUGINMANAGER_H
#include <config.h>
#include <string>
#include <map>
#include <vector>
#include <config.h>
#include "plugin_definitions.h"
/**Looks for, loads, and keeps track of plugins.
  *@author Sheldon Lee Wen
  */

class LKbd;
class LConfig;
class LKey;
class displayCtrl;

using namespace std;
using namespace lineak_plugins;

class DisplayPluginManager {
public:
	DisplayPluginManager();
	~DisplayPluginManager();
  	/** Unloads all loaded plugins. */
	void unloadPlugin(const string& plugin);
  	void unloadAllPlugins();
        /** Process a keycode by looking for the plugin that will handle it. */
        //void processKeycode(int keycode);
        /** Find the plugin supporting the macro for imyKey, and execute it. Then return true.
                If one could not be found, return false. */
        //bool exec(LKey* imyKey);
        /** Return a vector with the list of all supported macros */
        //vector<string> returnDirectivesList() { return dirlist; }

        /** Attempt to dlopen the plugins. This called scanForPlugins to get a valid
                list of plugins */
        vector<string> loadPlugins(vector<string> myplugins);
        bool loadPlugin(const string& plugin);
        /** Execute the initialize interface of all plugins that are loaded */
	bool initializePlugins(LKbd & imyKbd, LConfig & imyConfig);
        bool initializePlugin(const string& plugin, LKbd & imyKbd, LConfig & imyConfig);
        /** Execute the initialize_xosd interface of all plugins that are loaded */
        bool initializePluginsDisplay(displayCtrl & imyDisplay);
        bool initializePluginDisplay(const string& plugin, displayCtrl & imyDisplay);

	bool defineDirectivesLists();
        bool defineDirectivesList(const string& plugin);
	vector<string>& getDirectivesList() { return dirlist; }

	 /** Scan the plugins directory for plugins. */
  	vector<string> scanForPlugins(const string& directory = PLUGINDIR);

private:
	string plugindir;
        // List of plugin that have been loaded
	vector<string> plugins;
	// List of the directives that the plugins support
        vector<string> dirlist;
	/**   plugin, plugin struct */
	map<string, display_plugin_info> plugin_map;
};

#endif
