#include <fcntl.h>
#include <unistd.h>

#include <vector>
#include <string>

#include <lufs/proto.h>
#include <lufs/fs.h>

using namespace std;

#include "tools.h"

bool endswith( const char* s, const char* end )
{
	int ls = strlen(s);
	int le = strlen(end);
	if(le>ls) return false;
		
	return !strcmp(s+ls-le,end);
}

string removeend( const char* s, const char* end) 
{
	int ls = strlen(s);
	int le = strlen(end);
	if(le>ls) 
		return string();
		
	if(strcmp(s+ls-le,end))
		return string();
	
	return string(s, ls-le);
}

string mktemp(const char* base)
{
	char buf[2048];
	sprintf(buf,"/var/tmp/lufs-%s-%d", base, rand());
	return buf;
}
