module Needle
  module Extras
    module Multicast

      # A proxy that wraps an array of other objects. Whenever a message
      # is received by this proxy, it delegates the call to the objects in the
      # array.
      class Target

        # Creates a new Target object that acts as a proxy for the given list
        # of delegates.
        def initialize( *delegates )
          @delegates = delegates
        end

        # Forwards the method to each object in the array. It does no checking
        # to ensure that the receiver can understand the message before sending
        # it. This will return an array of the results of calling each of the
        # other messages.
        def method_missing( sym, *args, &block )
          @delegates.inject( [] ) do |a,d|
            a << d.__send__( sym, *args, &block )
          end
        end

      end

      # Register the multicast factory service in the given container. The
      # multicast service is a parameterized service which accepts a single
      # parameter--an array of the targets to apply to the multicaster. It
      # will then return an instance of a multicast service.
      def register_services( container )
        container.define.multicast :model => :prototype do |c,p,*targets|
          Multicast::Target.new( *targets )
        end
      end
      module_function :register_services

    end
  end
end

