/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

    basicstruct.h  -  declaration of the most basic structures, used throughout
                      the code
                             -------------------
    begin                : Wed Jun 12 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __basicstruct_h__
#define __basicstruct_h__

#pragma pack(1)

struct GUID // 16 byte
{
	u_char a[16];
	static void Create(GUID*);
	static const GUID G_NULL;
	bool operator==(const GUID& other) const {return 0==memcmp(a,other.a,sizeof(GUID));}
};

#define GUID_NULL GUID::G_NULL
#define CreateGuid GUID::Create

union IP // 4 byte
{
	struct { u_char s_b1,s_b2,s_b3,s_b4; } S_un_b;
	struct { u_short s_w1,s_w2; }          S_un_w;
	struct {BYTE a, b, c, d;}              S_ip;
	u_long S_addr;
};

struct IPNET // for things like 192.168.1.0/24
{
	union // IP part
	{
		struct { u_char s_b1,s_b2,s_b3,s_b4; } S_un_b;
		struct { u_short s_w1,s_w2; }          S_un_w;
		struct {BYTE a, b, c, d;}              S_ip;
		u_long S_addr;
	};
	u_long net_bits;
};

#pragma pack()

inline IP MakeIP(BYTE a, BYTE b, BYTE c, BYTE d){IP ip; ip.S_ip.a=a; ip.S_ip.b=b; ip.S_ip.c=c; ip.S_ip.d=d; return ip;}
inline IPNET MakeIPNET(BYTE a, BYTE b, BYTE c, BYTE d, u_long net){IPNET ipn; ipn.S_ip.a=a; ipn.S_ip.b=b; ipn.S_ip.c=c; ipn.S_ip.d=d; ipn.net_bits=net; return ipn;}
inline u_long GetSubnetMask(u_long net_bits){return net_bits ? (~((1ul<<(32-net_bits))-1)) : 0;}
inline u_long GetSubnetMask(const IPNET& net){return GetSubnetMask(net.net_bits);}
bool IsIpInSubnet(const IP& ip, const IPNET& subnet);
bool IsSubnetInSubnet(const IPNET& subnet1, const IPNET& subnet2);

struct HOST // IP : Port pair
{
	IP      ip;
	u_short port;
	// constructors
	HOST(const IP& _ip, u_short _port) : ip(_ip), port(_port) {}
};

inline bool operator==(const IP& ip1, const IP& ip2){return ip1.S_addr==ip2.S_addr;}
bool operator<(const IP& ip1, const IP& ip2);
bool operator>(const IP& ip1, const IP& ip2);
bool operator==(const IPNET& ipn1, const IPNET& ipn2);
bool operator<(const IPNET& ipn1, const IPNET& ipn2);
bool operator>(const IPNET& ipn1, const IPNET& ipn2);
inline bool operator==(const HOST& h1, const HOST& h2){return h1.ip.S_addr==h2.ip.S_addr && h1.port==h2.port;}

#endif /* __basicstruct_h__ */
