/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnushare.h  -  Definition of representation of a shared files folder

 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Wed May 30 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__GNUSHARE_H_INCLUDED__)
#define __GNUSHARE_H_INCLUDED__

#include "mthread.h"

class MGnuDirector;

class MGnuShare  
{
friend class MShareThread;
public:
	MGnuShare(MGnuDirector*);
	virtual ~MGnuShare();

	void InitShare();
	void CloseShare();
	void ResetDirectories(DWORD &, LPHANDLE);

	void Rescan();

	CString GetPath(DWORD);
	bool    GetFileByIndex(DWORD, CString&, CString&, bool);
	DWORD   GetIndexBySha1(const CString& sSha1);
	void    GetShareCopy(vector<SharedFile>&);

	//vector<CString> DirList;	// Shared directories
	//vector<DWORD>   DirSize;	// Total size of contents of each directory
	//vector<DWORD>   DirCount;	// Total count of files in each directory

	DWORD GetFileCount() { return m_dwTotalFiles; }
	DWORD GetFileSize() { return m_dwTotalSize; }
	DWORD GetUltrapeerSizeMarker() { return m_dwUltrapeerSizeMarker; }

	void UpdateSizeAndCount(DWORD dwSize, DWORD dwCount);

protected:
	MGnuDirector* m_pDirector;

	DWORD m_dwEstFileCount;
	DWORD m_dwTotalFiles;
	DWORD m_dwTotalSize;
	DWORD m_dwUltrapeerSizeMarker;

private:
	MShareThread* m_pSearchSharedThread;
	
	MGnuShare();                       // no implementation
	MGnuShare(const MGnuShare& rSrc);  // no implementation
};

// search request -- a custom event
class MShareReq : public MEvent{
public:
	MShareReq() : MEvent(ET_MESSAGE, ES_NONE, MSG_SHARE_REQUEST) {
		m_query.Text[0] = '\0';
	}
	virtual CString Format(){
		return CString("QUERY: '") + m_query.Text + "'";
	}
	virtual int GetMemUsage() {return sizeof(MShareReq);}
	//
	QueryComp m_query;
};

#endif // __GNUSHARE_H_INCLUDED__

