/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 mui.h  -  Abstract interface class for the user interface.
 
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef MUI_H
#define MUI_H

class MController;
class MMutex;

//////////////////////////////////////////////////
// abstract interface class for the user interface
// used by MController

class MUI {
public: 
	MUI();
	virtual ~MUI();
	//
	virtual bool Attach(MController* pC) = 0;
	virtual bool Init()                  = 0;
	virtual void Detach()                = 0;
	virtual void Do()                    = 0;
	virtual void Stop()                  = 0;
	virtual MMutex* GetMutex()           = 0;
	// something very special
	virtual bool OnHttpRequest(const IP& ipRemoteHost, LPCSTR szPath, LPCSTR szHandshake, const char* pBuffRest, int nFD){return false;}
	                                                              // allows UI-s to create propritary HTTP folders
	                                                              // and receive callbacks from the Controller
private:
	MUI(const MUI&);
};

#endif

