(* $Id: make-connection.ml,v 1.1 2004/08/05 13:40:59 rwmj Exp $ *)

open Printf

module DB = Dbi_postgres

let () =
  (* Supply the name of the database on the command line. *)
  let dbname = if Array.length Sys.argv > 1 then Sys.argv.(1) else "rich" in

  printf "Connecting to database '%s' ...\n" dbname; flush stdout;

  (* Connect to the database. *)
  let dbh = new DB.connection dbname in

  printf "Connected.  Now disconnecting.\n"

  (* No need to explicitly close the connection.  It is closed when the
   * program exits.  If you want to explicitly close, use dbh#close ().
   *)
