//
// C++ Implementation: runcommandinwindow
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifdef __USE_KDE_LIBS

#include <iostream>
#include <iomanip>

#include <kprocess.h>

#include <qregexp.h>
#include <qpushbutton.h>


#include "runcommandinwindow.h"

using namespace std;


namespace NApplication
{

RunCommandInWindow::RunCommandInWindow(QObject* parent, const char* name)
{
// 	_lastLinePar = 0;
	_pOutput = 0;
	_pProcess = new KProcess(parent, name);
	connect( _pProcess, SIGNAL(receivedStdout(KProcess *, char *, int )), 
		SLOT(onReadyReadStdout(KProcess *, char *, int )) );
	connect( _pProcess, SIGNAL(receivedStderr(KProcess *, char *, int )), 
		SLOT(onReadyReadStderr(KProcess *, char *, int )) );
	// forward signal outer world 
	connect(_pProcess, SIGNAL(processExited(KProcess*)), SLOT(onProcessExited()));
	_pProcess->setUsePty((KProcess::Communication)(KProcess::All), true);
}

RunCommandInWindow::~RunCommandInWindow()
{
	delete _pProcess;
	delete _pOutput;	// should not be neccessary
}
	
void RunCommandInWindow::addArgument(const QString& s)
{ 
	_pProcess->operator<<(s); 
}

bool RunCommandInWindow::start()
{
	_pOutput = new RunCommandWidget(0, "CommandWindow");
	_pOutput->resize(500,400);
	_pOutput->show();
	connect(_pOutput->_pCloseButton, SIGNAL(clicked()), SLOT(onCommandWindowClosed()));
	connect(_pOutput->_pAbortButton, SIGNAL(clicked()), SLOT(onAbort()));

	return _pProcess->start( KProcess::NotifyOnExit, 
		(KProcess::Communication)(KProcess::Stdin|KProcess::Stdout)
	);
}
 
bool RunCommandInWindow::processExitedSuccessful() const
{
	return _pProcess->normalExit() && (_pProcess->exitStatus() == 0);
}


// 13 is CR, 10 is LF
void RunCommandInWindow::onReadyReadStdout(KProcess *proc, char *buffer, int buflen)
{
	QString newString(buffer);
// 	qDebug("--- begin chunk ---");
// 	for (int i=0; i<strlen(buffer); ++i)
// 	{
// 		cout << setw(4) << (int) buffer[i] << " " << setw(3) << ( ( (((int) buffer[i])!=13) && (((int) buffer[i])!=10)) ? buffer[i] : ' ' ) << " ";
// 		if (i%10 == 0)
// 			cout << endl;
// 	}
// 	cout.flush();
// 	qDebug("\n--- end chunk ---");
	QStringList lines = QStringList::split(QRegExp("\r?\n\r?"), newString, true);
	bool firstLine = true;
	for (QStringList::const_iterator it = lines.begin(); it != lines.end(); ++it)
	{
		QString line = *it;
// 		qDebug(line);
		// only append if this is not the first entry in the splitting
		if (!firstLine)
		{
			// WARNING: don't remove the space here, because QTextBrowser seems not to
			// append a line if an empty String is handed!
			_pOutput->append(" ");
			_lastLine = "";
		}
		else
			firstLine = false;
		if (line.isEmpty())
			continue;
		// find the last position of a carriage return (anything before this is
		// meaningless as there are no \n mark in)
		int crPos = line.findRev('\015');
		if (crPos == -1)
		{
			line.prepend(_lastLine);
		}
		else
		{
			// take everything after the cr
			line = line.mid(crPos+1);
		}
		_lastLine = line;
		_pOutput->replaceLastLine(line);
	}
}

void RunCommandInWindow::onReadyReadStderr(KProcess *proc, char *buffer, int buflen)
{
	QString newString(buffer);
	QStringList lines = QStringList::split(QRegExp("\r?\n\r?"), newString, true);
	bool firstLine = true;
	for (QStringList::const_iterator it = lines.begin(); it != lines.end(); ++it)
	{
		QString line = *it;
		// only append if this is not the first entry in the splitting
		if (!firstLine)
		{
			// WARNING: don't remove the space here, because QTextBrowser seems not to
			// append a line if an empty String is handed!
			_pOutput->append(" ");
			_lastLine = "";
		}
		else
			firstLine = false;
		if (line.isEmpty())
			continue;
		// find the last position of a carriage return (anything before this is
		// meaningless as there are no \n mark in)
		int crPos = line.findRev('\015');
		if (crPos == -1)
		{
			line.prepend(_lastLine);
		}
		else
		{
			// take everything after the cr
			line = line.mid(crPos+1);
		}
		_lastLine = line;
		_pOutput->replaceLastLine(line);
	}
}

void RunCommandInWindow::onProcessExited()
{
	_pOutput->_pCloseButton->setEnabled(true);
	_pOutput->_pAbortButton->setEnabled(false);
	emit processExited();
}

void RunCommandInWindow::onCommandWindowClosed()
{
	// deferred deleting as the sender of the close signal
	_pOutput->deleteLater();
	_pOutput=0;
	emit quit();
}


void RunCommandInWindow::onAbort()
{
	if (_pProcess)
	{
		if (!_pProcess->kill())	// if killing was not succesfull
		{
			cerr << "Unable to kill process."<<endl;
		}
	}
}

}	// namespace NApplication


#endif	// __USE_KDE_LIBS
