/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     datauti.c                                                      *
 *            Helper functions for GtkDatabox usage                          *
 * Author:    Andreas Tille                                                  *
 * Date:      08.03.1999                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#ifdef HAVE_DATABOX /* just do nothing if libgtkdtabox does not exist */
#include <gtkdatabox.h>

#include "paul.h"

void CurveWidgetDestroy(GtkWidget *window, void *data)
{
  GtkWidget        *curve;

  g_return_if_fail ( window );
  g_return_if_fail ( GTK_IS_WINDOW(window) );
  if ( !(curve = gtk_object_get_user_data(GTK_OBJECT(window))) ) return;

  if ( GTK_IS_DATABOX(curve) ) {
    gtk_widget_destroy(curve);
    curve = NULL;
  }
  gtk_widget_destroy(window);
  window = NULL;
}

GtkWidget *CreateDataboxFrame(GtkWidget *curve, char *title)
/* Create window to contain GtkDatabox widget
 * --- Parameter: ---
 * GtkWidget *curve                : GtkDatabox widget
 * char      *title                : title of the window
 * --- Return: ---
 * GtkWindow *CreateDataboxFrame() : window which contains the GtkDatabox widget
 */
{
  GtkWidget *window, *main_vbox, *separator, *bbox, *close_button;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(CurveWidgetDestroy), NULL);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);

  gtk_window_set_title(GTK_WINDOW(window), title);
  gtk_widget_set_usize(window, 300, 300);
  gtk_container_set_border_width (GTK_CONTAINER(window), 0);

  main_vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), main_vbox);
      
  gtk_object_set_user_data(GTK_OBJECT(window), curve);

  gtk_box_pack_start(GTK_BOX(main_vbox), curve, TRUE, TRUE, 0);
  separator = gtk_hseparator_new ();
  gtk_box_pack_start(GTK_BOX(main_vbox), separator, FALSE, TRUE, 0);

  bbox = gtk_vbox_new(FALSE, 10);
  gtk_container_set_border_width(GTK_CONTAINER(bbox), 10);
  gtk_box_pack_end(GTK_BOX(main_vbox), bbox, FALSE, TRUE, 0);
  close_button = CreateCancelButton(window, bbox);
  gtk_widget_grab_default(close_button);

  gtk_widget_show_all(window);

  return window;
}

#endif
