/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#ifdef unicos
#include <sys/types.h>
#endif
#include <sys/wait.h>
#if defined SunOS_SOLARIS || defined unicos
#include <fcntl.h>
#endif
#include "main.h"
#ifdef SOL_IP
#include <netinet/ip.h>
#endif

extern char *time_string(void);
extern void free_memory(void);

/*
 * accs--Get a socket to work with.
 */
void accs(short isserver, int portn, char *hostname)
{
   int optval=(*statstr)->bsize;
   int domain=0;
   int sock_type=(*statstr)->use_udp ? SOCK_DGRAM: SOCK_STREAM;
   int setopt=1;
#ifdef HAVE_INET6
   int ret=0;
   char servname[64];
   struct addrinfo adin, *adres;
   struct sockaddr_in6 *sin = &(*statstr)->sin;
#else
   struct sockaddr_in *sin = &(*statstr)->sin;
#endif
   int sinlen=sizeof((*statstr)->sin);
   (*statstr)->sinlen=sinlen;
   memset((char *)sin, 0, sinlen);

#ifdef HAVE_INET6
   sin->sin6_family = AF_INET6;
   sin->sin6_port = htons(portn);
   sin->sin6_addr = in6addr_any;
#else
   sin->sin_family = AF_INET;
   sin->sin_port = htons(portn);
   sin->sin_addr.s_addr = INADDR_ANY;
#endif
   if (isserver) { /* Server */
      /*
       * First we get our hostname.
       * This is only needed for program
       * output.
       */
      gethostname(hostname, SONAME);
      (*statstr)->_HOSTNAME_ = hostname;
   }

   /*
    * Now we look up our host to get
    * its network number.
    */
   if (!isserver)
   {
      /*
       * Create the address we will be connected to.
       */
#ifdef HAVE_INET6
      if ((*statstr)->KDE_FRONTEND) fprintf(slfp, "* Looking up host %s ...\n", (*statstr)->_HOSTNAME_);
      memset((char *)&adin, 0, sizeof(adin));
      sprintf(servname, "%d", portn);
      adin.ai_socktype = sock_type;
      adin.ai_addr = (struct sockaddr *)sin;
      if ((ret = getaddrinfo((*statstr)->_HOSTNAME_, servname, &adin, &adres)) < 0) {
         if (slfp) fprintf(slfp, "** getaddrinfo: %s: %s\n", (*statstr)->_HOSTNAME_, gai_strerror(ret));
         free_memory();
         exit(PFTP_RES_HOST_ERR);
      }
      if ((*statstr)->use_udp) {
         (*statstr)->adin = adres;
         (*statstr)->sinlen = adres->ai_addrlen;
      }
#else
      struct hostent *hp;

      if ((*statstr)->KDE_FRONTEND) fprintf(slfp, "* Looking up host %s ...\n", (*statstr)->_HOSTNAME_);
      if ((hp = (struct hostent *)gethostbyname((*statstr)->_HOSTNAME_))) {
         memcpy(&sin->sin_addr, hp->h_addr_list[0], hp->h_length);
      }
#if !defined Linux
      else if (!(sin->sin_addr.s_addr = inet_addr((*statstr)->_HOSTNAME_)))
#else
      else if (!inet_aton((*statstr)->_HOSTNAME_, &sin->sin_addr))
#endif
      {
         if (slfp) fprintf(slfp, "** %s: unknown host.\n", (*statstr)->_HOSTNAME_);
         free_memory();
         exit(PFTP_UHOST_ERR);
      }
      if (hp) (*statstr)->_HOSTNAME_ = (char *)hp->h_name;
#endif
   }

   /*
    * Get a socket to work with.  This socket will
    * be a stream socket. `domain' is AF_INET
    * on IPv4 and AF_INET6 on IPv6.
    */
#ifdef HAVE_INET6
   if (isserver) domain = AF_INET6;
   else domain = adres->ai_family;
#else
   domain = sin->sin_family;
#endif
   if ((s = socket(domain, sock_type, 0)) < 0) {
      if (slfp) fprintf(slfp, "** socket: %s\n", _PFTP_ERROR_ARRAY_);
      exit(PFTP_SOCKET_ERR);
   }
   
   if (isserver) { /* Server */
      /*
       * Adjust the socket to our needs.
       */
      if (!(*statstr)->use_udp) {
         if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (void *)&setopt, sizeof(setopt)) < 0) {
               if (slfp) fprintf(slfp, "** setsockopt: SO_REUSEADDR: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_SETSOCKOPT_ERR);
         }
         if (setsockopt(s, SOL_SOCKET, SO_RCVBUF, (void *)&optval, sizeof(optval)) < 0) {
               if (slfp) fprintf(slfp, "** setsockopt: SO_RCVBUF: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_SETSOCKOPT_ERR);
         }
      }
      /*
       * Try to bind the address to the socket.
       */
      if (bind(s, (struct sockaddr *)sin, sinlen) < 0) {
         if (slfp) fprintf(slfp, "** bind: %s\n", _PFTP_ERROR_ARRAY_);
         free_memory();
         exit(PFTP_BIND_ERR);
      }

#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
      if ((*statstr)->use_udp  && \
         (*statstr)->multicast && \
         (*statstr)->_MULTICASTGROUP_) {
#ifdef HAVE_INET6
         struct ipv6_mreq mreq;
         if (!inet_pton(domain, (*statstr)->_MULTICASTGROUP_, mreq.ipv6mr_multiaddr.s6_addr)) {
               if (slfp) fprintf(slfp, "** %s: no such group.\n", (*statstr)->_MULTICASTGROUP_);
               exit(PFTP_MULTICAST_ERR);
         }
         mreq.ipv6mr_interface = atoi((*statstr)->_INTERFACE_);
         if (setsockopt(s, IPPROTO_IPV6, IPV6_ADD_MEMBERSHIP, (void *)&mreq, sizeof(mreq)) < 0) {
               if (slfp) fprintf(slfp, "** setsockopt: IPV6_ADD_MEMBERSHIP: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_SETSOCKOPT_ERR);
         }
         memcpy(sin->sin6_addr.s6_addr, mreq.ipv6mr_multiaddr.s6_addr, sizeof(mreq.ipv6mr_multiaddr.s6_addr));
#else
         struct ip_mreq mreq;
#if !defined Linux
         if (!(mreq.imr_multiaddr.s_addr = inet_addr((*statstr)->_MULTICASTGROUP_)))
#else
         if (!inet_aton((*statstr)->_MULTICASTGROUP_, &mreq.imr_multiaddr))
#endif
         {
            if (slfp) fprintf(slfp, "** %s: no such group.\n", (*statstr)->_MULTICASTGROUP_);
            exit(PFTP_MULTICAST_ERR);
         }
         if ((*statstr)->_INTERFACE_) {
#if !defined Linux
            if (!(mreq.imr_interface.s_addr = inet_addr((*statstr)->_INTERFACE_)))
#else
            if (!inet_aton((*statstr)->_INTERFACE_, &mreq.imr_interface))
#endif
            {
               if (slfp) fprintf(slfp, "** %s: no such interface.\n", (*statstr)->_INTERFACE_);
               exit(PFTP_INTERFACE_ERR);
            }
         }
         else mreq.imr_interface.s_addr = INADDR_ANY;
         if (setsockopt(s, IPPROTO_IP, IP_ADD_MEMBERSHIP, (void *)&mreq, sizeof(mreq)) < 0) {
               if (slfp) fprintf(slfp, "** setsockopt: IP_ADD_MEMBERSHIP: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_SETSOCKOPT_ERR);
         }
         sin->sin_addr.s_addr = mreq.imr_multiaddr.s_addr;
#endif
      }
#endif
      if (slfp) {
         if (!((*statstr)->_PFTP_DAEMON_ & BIT_ONE)) {
            fprintf(slfp, "\n*** %s is waiting for %s on port %d ***\n\n", \
            (*statstr)->_HOSTNAME_, (*statstr)->_STANDARD_INPUT_ ? "a stream" : "file(s)", portn);
            if ((*statstr)->ttys) fputc('\r', slfp);
         }
         else fprintf(slfp, "%s pftp daemon started with pid %d listening on port %d\n", time_string(), getpid(), portn);
         if ((*statstr)->testbsize) {
            fprintf(slfp, "* %s based network performance test\n", \
            (*statstr)->use_udp ? "UDP": "TCP");
         }
         if ((*statstr)->verbose) {
#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
            if ((*statstr)->multicast && (*statstr)->_MULTICASTGROUP_) {
               fprintf(slfp, "* Receiving multicasted datagrams.\n");
               fprintf(slfp, "* Joined multicast group %s.\n", (*statstr)->_MULTICASTGROUP_);
               if (slfp && (*statstr)->verbose && (*statstr)->_INTERFACE_) {
                  fprintf(slfp, "* Interface set to %s.\n", (*statstr)->_INTERFACE_);
               }
            }
#endif
            fprintf(slfp, "* %s set to %d bytes.\n", \
            (*statstr)->use_udp ? "Payload length": "Net buffer size", optval);
            if (!(*statstr)->use_udp) fprintf(slfp, "* String size set to %u bytes.\n", (unsigned int)((*statstr)->_STDIN_BUFSIZ_ ? (*statstr)->_STDIN_BUFSIZ_ : 1));
         }
         fflush(slfp);
      }
   }
   else { /* Client */
      /*
       * Adjust the socket to our needs.
       */
#ifdef HP_UX
      optval = BUFSIZE;
#endif
      if (!(*statstr)->use_udp) {
         if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (void *)&optval, \
            sizeof(optval)) < 0) {
            if (slfp) fprintf(slfp, "** setsockopt: SO_SNDBUF: %s\n", _PFTP_ERROR_ARRAY_);
            exit(PFTP_SETSOCKOPT_ERR);
         }
      }
      else {
         if (setsockopt(s, SOL_SOCKET, SO_BROADCAST, (void *)&setopt, sizeof(setopt)) < 0) {
               if (slfp) fprintf(slfp, "** setsockopt: SO_BROADCAST: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_SETSOCKOPT_ERR);
         }
#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
         if ((*statstr)->multicast) {
#ifdef HAVE_INET6
            if (setsockopt(s, IPPROTO_IPV6, IPV6_MULTICAST_LOOP, \
               (void *)&(*statstr)->mloop, sizeof((*statstr)->mloop)) < 0) {
                  if (slfp) fprintf(slfp, "** setsockopt: IPV6_MULTICAST_LOOP: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(PFTP_SETSOCKOPT_ERR);
            }
            if (setsockopt(s, IPPROTO_IPV6, IPV6_MULTICAST_HOPS, \
               (void *)&(*statstr)->mttl, sizeof((*statstr)->mttl)) < 0) {
                  if (slfp) fprintf(slfp, "** setsockopt: IPV6_MULTICAST_HOPS: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(PFTP_SETSOCKOPT_ERR);
            }
            if ((*statstr)->_INTERFACE_) {
               unsigned int interface=atoi((*statstr)->_INTERFACE_);
               if (setsockopt(s, IPPROTO_IPV6, IPV6_MULTICAST_IF, \
                  (void *)&interface, sizeof(interface)) < 0) {
                     if (slfp) fprintf(slfp, "** setsockopt: IPV6_MULTICAST_IF: %s\n", _PFTP_ERROR_ARRAY_);
                     exit(PFTP_SETSOCKOPT_ERR);
               }
            }
#else
            if (setsockopt(s, IPPROTO_IP, IP_MULTICAST_LOOP, \
               (void *)&(*statstr)->mloop, sizeof((*statstr)->mloop)) < 0) {
                  if (slfp) fprintf(slfp, "** setsockopt: IP_MULTICAST_LOOP: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(PFTP_SETSOCKOPT_ERR);
            }
            if (setsockopt(s, IPPROTO_IP, IP_MULTICAST_TTL, \
               (void *)&(*statstr)->mttl, sizeof((*statstr)->mttl)) < 0) {
                  if (slfp) fprintf(slfp, "** setsockopt: IP_MULTICAST_TTL: %s\n", _PFTP_ERROR_ARRAY_);
                  exit(PFTP_SETSOCKOPT_ERR);
            }
            if ((*statstr)->_INTERFACE_) {
               struct in_addr interface;
#if !defined Linux
               if (!(interface.s_addr = inet_addr((*statstr)->_INTERFACE_)))
#else
               if (!inet_aton((*statstr)->_INTERFACE_, &interface))
#endif
               {
                  if (slfp) fprintf(slfp, "** %s: no such interface.\n", (*statstr)->_INTERFACE_);
                  exit(PFTP_INTERFACE_ERR);
               }
               if (setsockopt(s, IPPROTO_IP, IP_MULTICAST_IF, \
                  (void *)&interface, sizeof(interface)) < 0) {
                     if (slfp) fprintf(slfp, "** setsockopt: IP_MULTICAST_IF: %s\n", _PFTP_ERROR_ARRAY_);
                     exit(PFTP_SETSOCKOPT_ERR);
               }
            }
#endif
         }
#endif
      }

#if defined SO_PRIORITY
      /*
       * Set priority for out packets.
       */
      if ((*statstr)->priority) {
         if (setsockopt(s, SOL_SOCKET, SO_PRIORITY, (void *)&(*statstr)->priority, \
            sizeof((*statstr)->priority)) < 0) {
            if (slfp) fprintf(slfp, "** setsockopt: SO_PRIORITY: %s\n", _PFTP_ERROR_ARRAY_);
            exit(PFTP_SETSOCKOPT_ERR);
         }
      }
      else {
#endif
#if defined SOL_IP && defined IPTOS_MINCOST && defined IPTOS_THROUGHPUT
         /*
          * Set Type-Of-Service (TOS) for our packets.
          */
         if (!(*statstr)->use_udp) {
            /* "filler data" */
            if ((*statstr)->_BANDWIDTH_) setopt = IPTOS_MINCOST;
            /* "pumping through the line" */
            else setopt = IPTOS_THROUGHPUT;
            if (setsockopt(s, SOL_IP, IP_TOS, (void *)&setopt, \
               sizeof(setopt)) < 0) {
               if (slfp) fprintf(slfp, "** setsockopt: IP_TOS: %s\n", _PFTP_ERROR_ARRAY_);
               exit(PFTP_SETSOCKOPT_ERR);
            }
         }
#endif
#if defined SO_PRIORITY
      }
#endif

      /*
       * Try to connect to the address.
       */
      if (slfp) {
         if (!(*statstr)->KDE_FRONTEND) {
            fprintf(slfp, "\n*** pftp is %s %s on port %d ***\n\n\r",
            (*statstr)->use_udp ? "sending datagrams to": "contacting", \
            (*statstr)->_HOSTNAME_, portn);
            if ((*statstr)->testbsize) {
               fprintf(slfp, "* %s based network performance test\n", \
               (*statstr)->use_udp ? "UDP": "TCP");
               if ((*statstr)->_RECURS_ && (*statstr)->verbose) {
                  fprintf(slfp, "* Using a random string.\n");
               }
            }
            if ((*statstr)->verbose) {
#if defined IPV6_ADD_MEMBERSHIP || (defined IP_ADD_MEMBERSHIP && !defined HAVE_INET6)
               if ((*statstr)->multicast) {
                  fprintf(slfp, "* Sending multicasted datagrams.\n");
                  fprintf(slfp, "* Loop back is %s.\n", (*statstr)->mloop ? "enabled" : "disabled");
                  fprintf(slfp, "* Time to live is %d.\n", (*statstr)->mttl);
                  if ((*statstr)->_INTERFACE_) {
                     fprintf(slfp, "* Interface set to %s.\n", (*statstr)->_INTERFACE_);
                  }
               }
#endif
#if defined SO_PRIORITY
               if ((*statstr)->priority) {
                  fprintf(slfp, "* Datagram priority set to %d.\n", (*statstr)->priority);
               }
#endif
               fprintf(slfp, "* %s set to %d bytes.\n", \
               (*statstr)->use_udp ? "Payload length": "Net buffer size", optval);
               if (!(*statstr)->use_udp) fprintf(slfp, "* String size set to %u bytes.\n", (unsigned int)((*statstr)->_STDIN_BUFSIZ_ ? (*statstr)->_STDIN_BUFSIZ_ : 1));
               if ((*statstr)->_BANDWIDTH_) {
                  fprintf(slfp, "* Bandwidth set to %ld bytes per second.\n", (*statstr)->_BANDWIDTH_);
               }
               else if (!(*statstr)->autobitrate) {
                  fprintf(slfp, "* Bandwidth is unlimited.\n");
               }
            }
         }
      }
      if (!(*statstr)->use_udp) {
#ifdef HAVE_INET6
         if (connect(s, (struct sockaddr *)adres->ai_addr, adres->ai_addrlen) < 0)
#else
         if (connect(s, (struct sockaddr *)sin, sinlen) < 0)
#endif
         {
#ifdef HAVE_STRERROR
            if (slfp) fprintf(slfp, "** connect: %s: %s\n", (*statstr)->_HOSTNAME_, _PFTP_ERROR_ARRAY_);
#else
            if (isatty(2)) perror("** connect");
#endif
            free_memory();
            exit(PFTP_CONNECTION_ERR);
         }
      }
 
#ifdef F_SETOWN
      /*
       * Catch SIGURG.
       */
      fcntl(s, F_SETOWN, getpid());
#endif
   }
}
