/***************************************************************************
                 job_countdata.cpp  -  description
                             -------------------
    begin                : Wed Jan 8 2002
    copyright            : (C) 2003 by Markus Kalkbrenner
    email                : mkalkbrenner@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_countdata.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"
#include "gui.h"

#include <iostream>

Job_CountData::Job_CountData()
{}

void Job_CountData::run()
{
  int error;

  database->lock();

  int countArtists = database->getCountColumnDistinctFromTable("artist", "tracks");
  int countTracks  = database->getCountFromTable("tracks");
  error = database->getError();

  database->unlock();

  if(!error) {
      QString status;
      status.sprintf(_(" Artists: %d "), countArtists);
      gui->setStatusInfo(status, 3);
      status.sprintf(_(" Tracks: %d "), countTracks);
      gui->setStatusInfo(status, 4);
  }

  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  exit();
}

Job_CountData::~Job_CountData() {}
