/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "OXServiceApplet.h"

#include <iostream>

#include "../icons/serviceInactive16x16.xpm"
#include "../icons/serviceActive16x16.xpm"
#include "../icons/serviceInactive32x32.xpm"
#include "../icons/serviceActive32x32.xpm"
#include "../icons/serviceInactive40x40.xpm"
#include "../icons/serviceActive40x40.xpm"
#include "../icons/rfb_service_large.xpm"


#include "../icons/digit.0.xpm"
#include "../icons/digit.1.xpm"
#include "../icons/digit.2.xpm"
#include "../icons/digit.3.xpm"
#include "../icons/digit.4.xpm"
#include "../icons/digit.5.xpm"
#include "../icons/digit.6.xpm"
#include "../icons/digit.7.xpm"
#include "../icons/digit.8.xpm"
#include "../icons/digit.9.xpm"
#include "../icons/digit.colon.xpm"
#include "../icons/digit.minus.xpm"

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "OXAbout.h"
#include "version.h"
#include "OXProperties.h"

extern Properties properties;

namespace rfb {
  void AddNewClient();
  void KillAllClients();
}


OXServiceApplet::OXServiceApplet( OXClient *_client, int port )
  : OXMainFrame( _client->GetRoot(), 40, 40 )
  , connected( 0 )
{
  SetWindowName( "x0rfbserver" );
  SetIconName( "x0rfbserver" );
  SetClassHints( "x0rfbserver", "x0rfbserver" );
  AddInput( ButtonPressMask | ButtonReleaseMask );

  popupMenu = new OXPopupMenu( _client->GetRoot() );
  popupMenu->AddEntry( new OHotString( "&Properties" ), 100 );
  popupMenu->AddSeparator();
  popupMenu->AddEntry( new OHotString( "Add &New Client" ), 101 );
  popupMenu->AddEntry( new OHotString( "&Kill All Clients" ), 102 );
  popupMenu->AddSeparator();
  popupMenu->AddEntry( new OHotString( "&About x0rfbserver" ), 103 );
  popupMenu->AddSeparator();
  popupMenu->AddEntry( new OHotString( "&Close daemon" ), 104 );
  
//  popupMenu->DisableEntry( 104 );
  popupMenu->SetDefaultEntry( 100 );
  
  popupMenu->Associate( this );

  OXCompositeFrame *frameApplet = new OXCompositeFrame( this, 40, 40, VERTICAL_FRAME );
  iconViewer = new OXIcon( frameApplet, _client->GetPicture( "serviceInactive40x40_xpm", serviceInactive40x40_xpm ), 40, 40 );
  frameDisplay = new OXCompositeFrame( frameApplet, 16, 16, HORIZONTAL_FRAME );

  OXIcon *colon = new OXIcon( frameDisplay, _client->GetPicture( "digit_colon", digit_colon_xpm ), 6, 9 );
  ADD_FRAME( frameDisplay, colon, ( LHINTS_BOTTOM | LHINTS_LEFT ) );

  int display = port;
  if ( port < 0 ) {
      OXIcon *minus = new OXIcon( frameDisplay, _client->GetPicture( "digit_minus", digit_minus_xpm ), 6, 9 );
      ADD_FRAME( frameDisplay, minus, ( LHINTS_BOTTOM | LHINTS_LEFT ) );
      port = 0 - port;
  }
  
  if ( port == 0 ) {
      OXIcon *digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_0", digit_0_xpm ), 6, 9 );
      ADD_FRAME( frameDisplay, digit, ( LHINTS_BOTTOM | LHINTS_RIGHT ) );
  } else {
      while ( port ) {
          OXIcon *digit = NULL;
          switch ( port % 10 ) {
              case 0: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_0", digit_0_xpm ), 6, 9 ); break;
              case 1: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_1", digit_1_xpm ), 6, 9 ); break;
              case 2: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_2", digit_2_xpm ), 6, 9 ); break;
              case 3: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_3", digit_3_xpm ), 6, 9 ); break;
              case 4: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_4", digit_4_xpm ), 6, 9 ); break;
              case 5: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_5", digit_5_xpm ), 6, 9 ); break;
              case 6: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_6", digit_6_xpm ), 6, 9 ); break;
              case 7: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_7", digit_7_xpm ), 6, 9 ); break;
              case 8: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_8", digit_8_xpm ), 6, 9 ); break;
              case 9: digit = new OXIcon( frameDisplay, _client->GetPicture( "digit_9", digit_9_xpm ), 6, 9 ); break;
	      default: break;
	  }
	  ADD_FRAME( frameDisplay, digit, ( LHINTS_BOTTOM | LHINTS_RIGHT ) );
	  port /= 10;
      }
  }

  ADD_FRAME( frameApplet, iconViewer,   ( LHINTS_CENTER_X | LHINTS_TOP ) );
  ADD_FRAME( frameApplet, frameDisplay, ( LHINTS_RIGHT | LHINTS_TOP, 0, 2, -11, 2 ) );
  ADD_FRAME( this,        frameApplet,  ( LHINTS_CENTER_X | LHINTS_CENTER_Y ) );
  
  Layout();
  
  char tip[256];
  sprintf( tip, "x0rfbserver listening\non display :%i", display );
  iconViewer->SetTip( tip );

  SetMWMHints(MWM_DECOR_ALL | MWM_DECOR_MAXIMIZE | MWM_DECOR_MENU,
              MWM_FUNC_ALL | MWM_FUNC_MAXIMIZE | MWM_FUNC_RESIZE,
              MWM_INPUT_MODELESS);

  MapSubwindows();
  MapWindow();
}


OXServiceApplet::~OXServiceApplet()
{
  DELETE_LAYOUT_HINTS;
  delete popupMenu;

  exit(0);
}



void OXServiceApplet::Layout()
{
  SetIcon( connected );
  OXMainFrame::Layout();
}


void OXServiceApplet::SetIcon( int _connected )
{
  connected = _connected;
  frameDisplay->UnmapWindow();
  if ( connected ) {
    if ( ( _w < 32 ) || ( _h < 32 ) )
      iconViewer->SetPicture( _client->GetPicture( "serviceActive16x16_xpm",
                                                    serviceActive16x16_xpm ) );
    else
      if ( ( _w < 40 ) || ( _h < 40 ) )
        iconViewer->SetPicture( _client->GetPicture( "serviceActive32x32_xpm",
                                                      serviceActive32x32_xpm ) );
      else {
        iconViewer->SetPicture( _client->GetPicture( "serviceActive40x40_xpm",
                                                      serviceActive40x40_xpm ) );
        frameDisplay->MapWindow();
      }
  } else {
    if ( ( _w < 32 ) || ( _h < 32 ) )
      iconViewer->SetPicture( _client->GetPicture( "serviceInactive16x16_xpm",
                                                    serviceInactive16x16_xpm ) );
    else
      if ( ( _w < 40 ) || ( _h < 40 ) )
        iconViewer->SetPicture( _client->GetPicture( "serviceInactive32x32_xpm",
                                                      serviceInactive32x32_xpm ) );
      else {
        iconViewer->SetPicture( _client->GetPicture( "serviceInactive40x40_xpm",
                                                      serviceInactive40x40_xpm ) );
        frameDisplay->MapWindow();
      }
  }
}


int OXServiceApplet::HandleButton(XButtonEvent * event)
{
  if ( event->type == ButtonRelease ) {
    if ( event->button == 3 ) {
      popupMenu->PlaceMenu( event->x_root - popupMenu->GetWidth(), event->y_root, false, true );
    }
  }
  return True;
}


int OXServiceApplet::ProcessMessage( OMessage *msg )
{
  OWidgetMessage *wmsg = (OWidgetMessage *) msg;

  switch (msg->action) {
    case MSG_CLICK:
      switch(msg->type) {
        case MSG_MENU:
          switch(wmsg->id) {

            case 100: {
              new OXProperties( _client->GetRoot(),
                                this,
                                &properties );
              return true;
            }

            case 101: {
              rfb::AddNewClient();
              return true;
	    }

            case 102: {
              rfb::KillAllClients();
              return true;
            }

            case 103: {
	      OXAbout *about = new OXAbout( _client->GetRoot(),
	                                    this,
					    "About: heXoNet x0rfbserver V" VERSION_x0rfbserver,
					    "x0rfbserver version " VERSION_x0rfbserver,
					    "x0rfbserver - Helpdesk from heXoNet",
					    _client->GetPicture( "rfb_service_large", rfb_service_large_xpm )
					  );
	      about->MapWindow();
              _client->WaitFor( about );
              return true;
            }

            case 104: {
              delete this;
              return true;
            }
	  }
      }
  }

  return false;
}

