/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


#ifndef _hexonet_rfb_ConnectionInfo_h_
#define _hexonet_rfb_ConnectionInfo_h_

namespace rfb {

class ConnectionInfo
{
 public:
  char host[256];
  int display;
  int preferredEncoding;
  char allowCopyRect;
  char requestSharedSession;
  char deiconifyOnBell;
  char disableClipboardTransfer;
  char emulate3Buttons;
  char swapMouseButtons;
  int framerate;
  char restrictPixels;
  bool useServerPixelFormat;
  char viewOnly;
  char fullscreenMode;
  char scale;
  int scaleFactor;
  int scaleDivisor;
  int scaleSmooth;
  bool recordFBS;
  char filenameFBS[1024];
  bool recordRFM;
  char filenameRFM[1024];
  int useZlib;
  
  ConnectionInfo()
    : display( 0 )
    , preferredEncoding( 5 )
    , allowCopyRect( 1 )
    , requestSharedSession( 0 )
    , deiconifyOnBell( 0 )
    , disableClipboardTransfer( 0 )
    , emulate3Buttons( 1 )
    , swapMouseButtons( 0 )
    , framerate( 0 )
    , restrictPixels( 0 )
    , useServerPixelFormat( 0 )
    , viewOnly( 0 )
    , fullscreenMode( 0 )
    , scale( 0 )
    , scaleFactor( 1 )
    , scaleDivisor( 1 )
    , scaleSmooth( 0 )
    , recordFBS( false )
    , recordRFM( false )
    , useZlib( 0 )
  {}
};

void readConnectionInfo( const char* filename, ConnectionInfo &connectionInfo );
void writeConnectionInfo( const char* filename, ConnectionInfo &connectionInfo );

} // namespace rfb

#endif //_hexonet_rfb_ConnectionInfo_h_
