import os, os.path, sys, re
from distutils.core import setup, Extension
from distutils.sysconfig import *
from distutils.errors import *

if sys.platform=="win32":
    # Windows doesn't define this although it is straightforward...
    def getstatusoutput(cmd):
        """Return (status, output) of executing cmd in a shell."""
        import os
        if os.name in ['nt', 'dos', 'os2'] :
            # use Dos style command shell for NT, DOS and OS/2
            pipe = os.popen(cmd + ' 2>&1', 'r')
        else :
            # use Unix style for all others
            pipe = os.popen('{ ' + cmd + '; } 2>&1', 'r')
        text = pipe.read()
        sts = pipe.close()
        if sts is None: sts = 0
        if text[-1:] == '\n': text = text[:-1]
        return sts, text
else:
    from commands import getstatusoutput
    

def get_R_HOME():
    if sys.platform == 'win32':
        import win32api, win32con
        rhome = os.getenv("R_HOME")
        if not rhome:
           try: 
               hkey = win32api.RegOpenKeyEx( win32con.HKEY_LOCAL_MACHINE,
                                             "Software\\R-core\\R",
                                             0, win32con.KEY_QUERY_VALUE )
               # get the base directory
               rhome = win32api.RegQueryValueEx( hkey, "InstallPath" )[0]
               win32api.RegCloseKey( hkey )
           except:
               raise DistutilsExecError("couldn't execute the R interpreter.\n"
                                 "Check whether R is in the execution path.")  
        return rhome
    else:
        stat, rhome = getstatusoutput('R RHOME')

        if stat or len(rhome)<=0:
            raise DistutilsExecError("couldn't execute the R interpreter.\n"
                                 "Check whether R is in the execution path.")
        return rhome.strip()

def get_R_SRC():
    version = get_R_VERSION()
    R_SRC = os.path.abspath("R-" + version)

    print "Building for R version %s ..." % version

    if not os.path.exists(R_SRC):
        raise DistutilsExecError( \
            "\n\n" \
            "The path\n\n" \
            "    %s\n\n" % R_SRC + \
            "which should contain header files for R version %s \n" % version + \
            "does not exist!\n" \
            "\n" \
            "Please see the rpy README file for instructions.\n")
    
    return R_SRC

def get_R_VERSION():
    stat, output = getstatusoutput('R --version')
    if stat or len(output)<=0:
        raise DistutilsExecError("couldn't execute the R interpreter.\n"
                                 "Check whether R is in the execution path.")
    version = re.search("R +([0-9]\.[0-9]\.[0-9])", output)
    if not version:
        raise DistutilsExecError("couldn't obtain version number from output\n"
                                 "of `R --version'.\n")
    return version.group(1)


# to avoid strict prototypes errors from R includes
get_config_vars()['OPT'] = '-DNDEBUG -g -O3 -Wall'

# get the Python version
if sys.version[:3] >= '2.2':
    DEFINE = []
    UNDEF = ['PRE_2_2']
else:
    DEFINE = [('PRE_2_2', None)]
    UNDEF = []

# configure the R paths
RHOME = get_R_HOME()
if sys.platform=="win32":
    DEFINE.append(('R_HOME', '\\"%s\\"' % RHOME.replace("\\","/") ))
else:
    DEFINE.append(('R_HOME', '"%s"' % RHOME))

r_libs = [
          os.path.join(RHOME, 'bin'), 
          os.path.join(RHOME, 'lib'),  # R 2.0.0 moved libR.so 
         ]  

source_files = ["src/rpymodule.c", "src/R_eval.c",
                "src/io.c"]

if sys.platform=='win32':
    RSRC = get_R_SRC()
    include_dirs = [ os.path.join(RHOME.strip(), 'include'),
                     os.path.join(RSRC.strip(), 'src', 'include'), 
		     'src' ]
    libraries=["Rdll","Advapi32"] 
    library_dirs = r_libs
    #runtime_libs = r_libs
    extra_compile_args= ["-wd4068"]  # Disable unknown pragma warning in pyconfig.h
    source_files = source_files + ["src\\setenv.c"]
elif sys.platform=='darwin':
    RSRC = get_R_SRC()
    include_dirs = [ os.path.join(RHOME.strip(), 'include'), 
		     os.path.join(RSRC.strip(), 'src', 'include'),
		     'src' ]
    libraries=['R']
    library_dirs=[os.path.join(RHOME.strip(), 'Frameworks')]
    extra_compile_args=[]
    runtime_libs = []
elif sys.platform=='osf1V5':
    RSRC = get_R_SRC()
    include_dirs = [ os.path.join(RHOME.strip(), 'include'), 
		     os.path.join(RSRC.strip(), 'src', 'include'),
		     'src' ]
    libraries=['R']
    library_dirs = r_libs
    runtime_libs = []
    extra_compile_args=["-shared"]
    source_files = source_files + ["src/setenv.c"]
else: # unix-like systems, this is known to work for Linux and Solaris
    RSRC = get_R_SRC()
    include_dirs = [ os.path.join(RHOME.strip(), 'include'), 
		     os.path.join(RSRC.strip(), 'src/include'),
		     'src' ]
    libraries=['R']
    library_dirs = r_libs
    runtime_libs = r_libs
    extra_compile_args=["-shared"]
    source_files = source_files + ["src/setenv.c"]
    
# check whether Numeric is present
try:
    import Numeric
    DEFINE.append(('WITH_NUMERIC', None))
except ImportError:
    UNDEF.append('WITH_NUMERIC')

# get the RPy version
from rpy_version import rpy_version

LONG_DESC = """RPy provides a robust Python interface to the R
programming language.  It can manage all kinds of R objects and can
execute arbitrary R functions. All the errors from the R language are
converted to Python exceptions."""



if sys.platform=='win32':
    setup(name="rpy",
          version=rpy_version,
          description="Python interface to the R language",
          author="Walter Moreira",
          author_email="walterm@cmat.edu.uy",
          url="http://rpy.sourceforge.net",
          license="GPL",
          long_description=LONG_DESC,
          py_modules=['rpy', 'rpy_io', 'rpy_version'],
          ext_modules=[Extension("_rpy",
                                 source_files,
                                 include_dirs=include_dirs,
                                 libraries=libraries,
                                 library_dirs=library_dirs,
                                 define_macros=DEFINE,
                                 undef_macros=UNDEF,
                                 extra_compile_args=extra_compile_args
                                 ),
                       
                       ]
          )
else:
    setup(name="rpy",
          version=rpy_version,
          description="Python interface to the R language",
          author="Walter Moreira",
          author_email="walterm@cmat.edu.uy",
          url="http://rpy.sourceforge.net",
          license="GPL",
          long_description=LONG_DESC,
          py_modules=['rpy', 'rpy_io', 'rpy_version'],
          ext_modules=[Extension("_rpy",
                                 source_files,
                                 include_dirs=include_dirs,
                                 libraries=libraries,
                                 library_dirs=library_dirs,
                                 define_macros=DEFINE,
                                 undef_macros=UNDEF,
                                 extra_compile_args=extra_compile_args,
                                 runtime_library_dirs = runtime_libs,
                                 ),
                       
                       ]
      )
