from __future__ import nested_scopes

import unittest
import sys
sys.path.insert(1, "..")
from rpy import *

class RobjTestCase(unittest.TestCase):

    def setUp(self):
        self.robj = type(r.array)
        set_default_mode(NO_DEFAULT)
        class_table.clear()
        proc_table.clear()
        
    def testType(self):
        self.failUnless(type(r.array) == type(r.seq))

    def testCall(self):
        self.failUnless(callable(r.seq))

    def testKeywordParameters(self):
        r.list.autoconvert(BASIC_CONVERSION)
        d = r.list(foo='foo', bar_foo='bar.foo',
                   print_='print', as_data_frame='as.data.frame')
        for k in d.keys():
            self.failUnless(k == d[k])
            
    def testNameConversions(self):
        self.failUnless(r.array is r['array'] and
                        r.print_ is r['print'] and
                        r.as_data_frame is r['as.data.frame'] and
                        r.attr__ is r['attr<-'])

    def testNotFound(self):
        self.failUnlessRaises(RException, lambda: r.foo)
        
    def testNameLengthOne(self):
        self.failUnless(r.T)

    def testAutoconvert(self):
        r.seq.autoconvert(1)
        self.failUnless(r.seq(10) == range(1,11))
        r.seq.autoconvert(0)
        self.failUnless(type(r.seq(10)) == type(r.seq))
        r.seq.autoconvert(1)

    def testBadAutoconvert(self):
        self.failUnlessRaises(ValueError, lambda : r.seq.autoconvert(4))
        
    def testGetAutoconvert(self):
        a = r.seq.autoconvert()
        self.failUnless(type(a) is type(1) and -1<=a<=2)
        
    def testRgc(self):
        r.seq.autoconvert(NO_CONVERSION)
        a = r.seq(100000)
        r.gc()
        assert(a[10])
        r.seq.autoconvert(BASIC_CONVERSION)

    def testLCall(self):
        "Test if lcall preserves named argument ordering."
        set_default_mode(NO_CONVERSION)
        a = r.c.lcall( (('',0),('a',1),('b',2),('c',3)) )
        set_default_mode(BASIC_CONVERSION)
        self.failUnless(r.names(a) == ['','a','b','c'])

if __name__ == '__main__':
    unittest.main()
