/* ScummVM - Scumm Interpreter
 * Copyright (C) 2003-2004 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/sky/compact.h,v 1.12 2004/01/06 12:45:32 fingolfin Exp $
 *
 */

#ifndef SKYCOMPACT_H
#define SKYCOMPACT_H

#include "sky/sky.h"
#include "sky/struc.h"
#include "sky/skydefs.h"

namespace Sky {

namespace SkyCompact {
	MegaSet *getMegaSet(Compact *cpt, uint16 megaSet);
	uint16 **getTurnTable(Compact *cpt, uint16 megaSet, uint16 dir);
	uint16 *getSub(Compact *cpt, uint16 mode);
	uint16 *getGrafixPtr(Compact *cpt);
	void *getCompactElem(Compact *cpt, uint32 off);
	void patchFor288(void);

	extern uint16 s11_fl_tab288[33];
	extern uint16 s19_fl_tab288[17];
	extern uint16 s20_fl_tab288[37]; 
	extern uint16 s21_fl_tab288[31]; 
	extern uint16 s22_fl_tab288[31];
	extern uint16 s23_fl_tab288[27]; 
	extern uint16 s24_fl_tab288[23]; 
	extern uint16 s25_fl_tab288[19]; 
	extern uint16 s26_fl_tab288[29];
	extern uint16 s27_fl_tab288[29];
	extern uint16 s28_fl_tab288[27];
	extern uint16 s28_sml_tab288[13];
	extern uint16 s29_fl_tab288[27];
	extern uint16 s29_sml_tab288[13];
	extern uint16 body_tab288[7];
	extern uint16 chair_tab288[23];

	extern uint16 slide2_seq[];
	extern uint16 m_ss_st_up[];
	extern uint16 crouch_seq[];
	extern uint16 fost_open_cup[];
	extern Compact fan3;
	extern uint16 ss_smokes_1[];
	extern Compact fan7;
	extern uint16 slide_seq[];
	extern uint16 f_ss_st_right[];
	extern uint16 f_ss_left[];
	extern uint16 m_ss_down[];
	extern uint16 s2_pal[];
	extern uint16 foster_hanging[];
	extern Compact fan4;
	extern uint16 rs_ss_to_1[];
	extern uint16 rs_foster_to_one[];
	extern uint16 m_ss_r_to_d[];
	extern uint16 f_ss_l_to_u[];
	extern Compact load_point;
	extern uint16 rs_foster_5_0[];
	extern uint16 fost_pull_knob[];
	extern uint16 m_ss_r_to_u[];
	extern uint16 rs_foster_to_1[];
	extern uint16 monitor_seq[];
	extern uint16 joey_door_seq[];
	extern uint16 small_opens[];
	extern uint16 fost_knob_locked[];
	extern uint16 s4_pal[];
	extern uint16 alarm_seq[];
	extern uint16 reverse_seq[];
	extern Compact press;
	extern uint16 furnace_seq[];
	extern uint16 load_point_seq[];
	extern uint16 m_ss_right[];
	extern uint16 use_bar2[];
	extern uint16 fost_cant_open[];
	extern uint16 f_ss_l_to_r[];
	extern uint16 f_ss_u_to_d[];
	extern uint16 push_small[];
	extern uint16 m_ss_l_to_d[];
	extern uint16 s0_pal[];
	extern uint16 foster_shot[];
	extern uint16 lazer_stop_seq[];
	extern uint16 rs_start_alarm[];
	extern Compact fan1;
	extern uint16 f_ss_d_to_u[];
	extern uint16 ss_smokes_3[];
	extern uint16 lights1_seq[];
	extern uint16 eye_open[];
	extern uint16 press_seq[];
	extern uint16 cup_close_seq[];
	extern uint16 low_lift_down_seq1[];
	extern uint16 barrel_in_seq[];
	extern uint16 rs_big_foster[];
	extern uint16 screen0_low_logic[];
	extern uint16 rs_foster_2_0[];
	extern uint16 foster_g_d[];
	extern uint16 fost_but_seq[];
	extern uint16 jobs_look_scrn[];
	extern uint16 jobs_chuck_look[];
	extern uint16 eye_blink[];
	extern uint16 fan1_seq[];
	extern uint16 m_ss_st_right[];
	extern uint16 screen0_low_mouse[];
	extern uint16 fan7_seq[];
	extern uint16 f_ss_r_to_d[];
	extern uint16 r1_opens[];
	extern uint16 f_ss_u_to_l[];
	extern uint16 rs_mini_ss[];
	extern uint16 s3_pal[];
	extern uint16 ss_smokes_2[];
	extern uint16 m_ss_up[];
	extern uint16 m_ss_left[];
	extern uint16 m_ss_st_down[];
	extern uint16 m_ss_st_left[];
	extern uint16 m_ss_st_talk[];
	extern uint16 m_ss_u_to_d[];
	extern uint16 m_ss_u_to_l[];
	extern uint16 m_ss_u_to_r[];
	extern uint16 m_ss_d_to_u[];
	extern uint16 m_ss_d_to_l[];
	extern uint16 m_ss_d_to_r[];
	extern uint16 m_ss_l_to_u[];
	extern uint16 m_ss_l_to_r[];
	extern uint16 m_ss_r_to_l[];
	extern ExtCompact mini_so_ext;
	extern Compact mini_so;
	extern uint16 unload_seq1[];
	extern uint16 open_r1[];
	extern uint16 get_bar_out[];
	extern uint16 fost_close_cup[];
	extern uint16 barrel_down_seq2[];
	extern uint16 ss_kick[];
	extern uint16 f_ss_up[];
	extern uint16 f_ss_down[];
	extern uint16 f_ss_right[];
	extern uint16 f_ss_st_up[];
	extern uint16 f_ss_st_down[];
	extern uint16 f_ss_st_left[];
	extern uint16 f_ss_u_to_r[];
	extern uint16 f_ss_d_to_l[];
	extern uint16 f_ss_d_to_r[];
	extern uint16 f_ss_l_to_d[];
	extern uint16 f_ss_r_to_u[];
	extern uint16 f_ss_r_to_l[];
	extern ExtCompact full_so_ext;
	extern Compact full_so;
	extern uint16 panel_seq[];
	extern uint16 chip_list_0[];
	extern uint16 use_the_bar[];
	extern uint16 small_closes[];
	extern uint16 jobs_buttons[];
	extern uint16 up_stairs[];
	extern uint16 chuck_seq[];
	extern uint16 rs_foster_to_0[];
	extern Compact fire_notice;
	extern uint16 screen0_high_mouse[];
	extern uint16 foster_g_up[];
	extern uint16 rs_foster_s3[];
	extern uint16 rs_mini_foster[];
	extern uint16 bolt1_seq[];
	extern uint16 rs_foster_4_2[];
	extern uint16 screen0_high_logic[];
	extern uint16 fan6_seq[];
	extern uint16 fexit_opens[];
	extern uint16 fost_push_knob[];
	extern uint16 lazer_run_seq[];
	extern uint16 try_to_open_r0[];
	extern uint16 fast_list_cut2[];
	extern uint16 knob_down[];
	extern uint16 chip_list_sc0[];
	extern uint16 sc0_cut_logic[];
	extern Compact lazer_gun;
	extern uint16 up_stairs2[];
	extern uint16 barrel_down_seq[];
	extern uint16 daft_seq[];
	extern uint16 down_stairs2[];
	extern uint16 joey_jump_seq[];
	extern uint16 fost_lean_seq[];
	extern uint16 joey_wake_seq[];
	extern uint16 low_lift_down_seq2[];
	extern uint16 lazer_start_seq[];
	extern uint16 get_the_bar[];
	extern uint16 fan4_seq[];
	extern uint16 tv_seq[];
	extern uint16 bolt2_seq[];
	extern Compact fan6;
	extern uint16 jobs_pull_knob[];
	extern uint16 convey_seq[];
	extern uint16 fan5_seq[];
	extern uint16 guard_lean_out[];
	extern uint16 put_bar_away[];
	extern uint16 fan3_seq[];
	extern uint16 s1_pal[];
	extern uint16 eye_shoot[];
	extern uint16 furnace_door_open[];
	extern uint16 ss_smokes_4[];
	extern Compact fan5;
	extern uint16 jobs_close[];
	extern uint16 cup_open_seq[];
	extern uint16 guard_lean_back[];
	extern uint16 ss_kick_2[];
	extern uint16 shot1_seq[];
	extern uint16 fexit_closes[];
	extern uint16 low_lift_down_seq3[];
	extern uint16 rs_restart_barrel[];
	extern uint16 open_r0[];
	extern uint16 rs_foster_2_4[];
	extern uint16 ss_shoot_seq[];
	extern uint16 shut_r1[];
	extern uint16 down_stairs[];
	extern uint16 barrel_seq[];
	extern uint16 jobs_scratch[];
	extern uint16 unload_seq2[];
	extern uint16 rs_foster_0_2[];
	extern uint16 r1_closes[];
	extern uint16 rs_convey[];
	extern uint16 jobs_push_knob[];
	extern uint16 knob_up[];
	extern uint16 crouch_talk[];
	extern uint16 shot2_seq[];
	extern uint16 joey_fly2[];
	extern uint16 jobs_key_seq[];
	extern uint16 rs_mega_2_0[];
	extern uint16 uncrouch_seq[];
	extern uint16 fost_must_close[];
	extern uint16 joey_fly1[];
	extern uint16 lazer_gun_seq[];
	extern uint16 rs_mega_0_2[];
	extern Compact fan2;
	extern uint16 fan2_seq[];
	extern void *data_1[];
	extern Compact cancel_button;
	extern Compact button_4;
	extern Compact full_screen;
	extern Compact button_5;
	extern uint16 s101_logic[];
	extern Compact button_7;
	extern uint16 s101_mouse[];
	extern Compact button_1;
	extern uint16 s101_pal[];
	extern Compact button_0;
	extern Compact button_9;
	extern Compact button_8;
	extern Compact retina_scan;
	extern Compact button_6;
	extern Compact button_3;
	extern Compact button_2;
	extern uint16 s101_chip_list[];
	extern uint16 restore_seq[];
	extern Compact restore_butt;
	extern uint16 s102_logic[];
	extern uint16 exit_seq[];
	extern uint16 restart_seq[];
	extern uint16 s102_mouse[];
	extern Compact exit_butt;
	extern uint16 s102_pal[];
	extern uint16 s102_chip_list[];
	extern Compact restart_butt;
	extern uint16 liyt_4_seq[];
	extern uint16 litebank_seq[];
	extern uint16 rs_foster_from_linc[];
	extern uint16 stand_10_seq[];
	extern uint16 pod_up[];
	extern uint16 rs_foster_11_10[];
	extern uint16 lift_10_close[];
	extern uint16 s10_floor_table[];
	extern uint16 monitor_10_seq[];
	extern uint16 sit_10_seq[];
	extern Compact lift_slot_10;
	extern uint16 scanline_seq[];
	extern Compact s10_floor;
	extern uint16 rs_foster_10_11[];
	extern Compact terminal_10;
	extern uint16 linc_card_seq[];
	extern uint16 liyt_1_seq[];
	extern uint16 fsit_talk_seq[];
	extern Compact scanner_10;
	extern Compact pod_light;
	extern Compact pod;
	extern Compact fake_floor_10;
	extern uint16 lift_10_open[];
	extern uint16 linc_10_table[];
	extern Compact linc_10;
	extern uint16 s10_logic[];
	extern uint16 liyt_2_seq[];
	extern uint16 s10_chip_list[];
	extern uint16 pod_down[];
	extern Compact monitor_10;
	extern uint16 liyt_3_seq[];
	extern Compact lift_10;
	extern Compact litebank;
	extern uint16 pod_light_seq[];
	extern uint16 card2_seq[];
	extern Compact liyt_3;
	extern Compact liyt_2;
	extern uint16 s10_pal[];
	extern uint16 s10_mouse[];
	extern Compact liyt_4;
	extern Compact left_exit_10;
	extern Compact liyt_1;
	extern Compact slat_3;
	extern uint16 fallin_seq[];
	extern uint16 s11_mouse[];
	extern uint16 s11_pal[];
	extern Compact locker_11;
	extern uint16 locker_11_open[];
	extern uint16 bits2_seq[];
	extern Compact soccer_2;
	extern uint16 usecard_11_seq[];
	extern Compact bits;
	extern Compact cable_fall;
	extern Compact soccer_4;
	extern uint16 s11_floor_table[];
	extern Compact soccer_1;
	extern uint16 rs_foster_1_11[];
	extern uint16 s11_logic[];
	extern uint16 close_11_locker[];
	extern uint16 s11_chip_list[];
	extern Compact slat_1;
	extern uint16 locker_11_close[];
	extern Compact bits2;
	extern Compact slot_11;
	extern uint16 bits_seq[];
	extern Compact slat_4;
	extern uint16 fallin2_seq[];
	extern uint16 smashed_window_seq[];
	extern Compact spy_11;
	extern Compact soccer_3;
	extern uint16 cable_fall1_seq[];
	extern Compact cable_fall2;
	extern Compact right_exit_11;
	extern Compact smashed_window;
	extern Compact soccer_5;
	extern uint16 open_11_locker[];
	extern Compact slat_2;
	extern uint16 fallin3_seq[];
	extern Compact s11_floor;
	extern uint16 get_cable_11[];
	extern uint16 cant_open_locker[];
	extern Compact slat_5;
	extern uint16 cable_fall2_seq[];
	extern uint16 botbelt_seq[];
	extern uint16 s12_floor_table[];
	extern uint16 swap1_seq[];
	extern uint16 rs_joey_start_12[];
	extern uint16 rs_lamb_start_fact[];
	extern uint16 welder_seq[];
	extern uint16 rs_foster_7_12[];
	extern uint16 factory_spanner_seq[];
	extern uint16 pipes_seq[];
	extern uint16 swap3_seq[];
	extern Compact fact1_right_exit;
	extern Compact pipes;
	extern Compact botbelt;
	extern uint16 joey_list_12[];
	extern Compact welder;
	extern Compact factory_exit;
	extern uint16 s12_pal[];
	extern uint16 cant_lift_seq[];
	extern Compact topbelt;
	extern uint16 s12_fast_list[];
	extern uint16 s12_new_chip[];
	extern Compact console_12;
	extern uint16 anita_walk_seq[];
	extern uint16 anita_work_seq[];
	extern uint16 anita_turn_seq[];
	extern uint16 anita_turn_back[];
	extern uint16 rs_foster_12_7[];
	extern uint16 s12_mouse[];
	extern uint16 s12_chip_list[];
	extern Compact stump;
	extern uint16 swap2_seq[];
	extern Compact anita_spy;
	extern Compact s12_floor;
	extern uint16 s12_logic[];
	extern uint16 topbelt_seq[];
	extern uint16 foreman_l_to_r[];
	extern uint16 rs_foster[];
	extern uint16 gears_seq[];
	extern Compact fact2_exit_left;
	extern Compact fact_console;
	extern Compact pipe1;
	extern uint16 lite1_table[];
	extern Compact sensor;
	extern uint16 foreman_l_to_d[];
	extern uint16 foreman_st_up[];
	extern uint16 foreman_work_seq[];
	extern uint16 nu_s13_chip[];
	extern uint16 rs_storeman[];
	extern uint16 foreman_left[];
	extern uint16 closecoat[];
	extern uint16 pipe1_seq[];
	extern uint16 foreman_r_to_l[];
	extern Compact fact2_exit_right;
	extern uint16 foreman_l_to_u[];
	extern Compact lite1;
	extern uint16 s13_floor_table[];
	extern uint16 fsearch_seq[];
	extern Compact fact2_store_exit;
	extern Compact pipe4;
	extern uint16 foreman_u_to_d[];
	extern uint16 foreman_right[];
	extern uint16 belts2_seq[];
	extern uint16 forfrisk_seq[];
	extern uint16 rs_foreman[];
	extern uint16 pipe2_seq[];
	extern uint16 rs_foster_13_12[];
	extern Compact s13_floor;
	extern Compact cogs;
	extern uint16 foreman_r_to_u[];
	extern Compact belts2;
	extern uint16 foreman_d_to_l[];
	extern uint16 s13_chip_list[];
	extern uint16 foreman_st_talk[];
	extern uint16 fact_console_dead[];
	extern uint16 foreman_st_down[];
	extern Compact lite2;
	extern Compact gears;
	extern uint16 fost_cog_seq[];
	extern uint16 cogs_seq[];
	extern Compact pipe3;
	extern uint16 lite2_seq[];
	extern Compact belts1;
	extern uint16 s13_logic[];
	extern uint16 s13_mouse[];
	extern Compact sensors;
	extern uint16 fact_console_seq[];
	extern uint16 foreman_down[];
	extern uint16 foreman_up[];
	extern uint16 foreman_st_left[];
	extern uint16 foreman_st_right[];
	extern uint16 foreman_u_to_l[];
	extern uint16 foreman_u_to_r[];
	extern uint16 foreman_d_to_u[];
	extern uint16 foreman_d_to_r[];
	extern uint16 foreman_r_to_d[];
	extern ExtCompact foreman_ext;
	extern Compact foreman;
	extern uint16 lite1_seq[];
	extern uint16 pipe3_seq[];
	extern uint16 opencoat_seq[];
	extern uint16 sensor_seq[];
	extern Compact fact2_spy_and_window;
	extern uint16 belts1_seq[];
	extern Compact pipe2;
	extern uint16 s13_pal[];
	extern uint16 new_13_chip[];
	extern uint16 rs_foster_12_13[];
	extern uint16 s13_fast_list[];
	extern uint16 pipe4_seq[];
	extern uint16 armsup_seq[];
	extern uint16 rs_foster_14_13[];
	extern uint16 rs_foster_13_14[];
	extern uint16 radman_l_to_r[];
	extern uint16 radman_up[];
	extern uint16 radman_down[];
	extern uint16 radman_left[];
	extern uint16 radman_right[];
	extern uint16 radman_st_up[];
	extern uint16 radman_st_down[];
	extern uint16 radman_st_left[];
	extern uint16 radman_st_right[];
	extern uint16 radman_st_talk[];
	extern uint16 radman_u_to_d[];
	extern uint16 radman_u_to_l[];
	extern uint16 radman_u_to_r[];
	extern uint16 radman_d_to_u[];
	extern uint16 radman_d_to_l[];
	extern uint16 radman_d_to_r[];
	extern uint16 radman_l_to_u[];
	extern uint16 radman_l_to_d[];
	extern uint16 radman_r_to_u[];
	extern uint16 radman_r_to_d[];
	extern uint16 radman_r_to_l[];
	extern ExtCompact radman_ext;
	extern Compact radman;
	extern Compact locker2;
	extern uint16 start_joey_14[];
	extern Compact fact3_exit_left;
	extern uint16 rs_anita_to_14[];
	extern uint16 s14_logic[];
	extern uint16 close_locker_seq[];
	extern uint16 locker_close_seq[];
	extern uint16 s14_floor_table[];
	extern Compact s14_floor;
	extern uint16 rad_open_locker[];
	extern uint16 change_back6[];
	extern uint16 change1_seq[];
	extern uint16 change_back3[];
	extern uint16 rs_foster_16_14[];
	extern Compact console_14;
	extern uint16 s14_pal[];
	extern uint16 change3_seq[];
	extern uint16 change_back4[];
	extern uint16 open_locker_seq[];
	extern uint16 change4_seq[];
	extern uint16 foster_give_seq[];
	extern Compact locker3;
	extern Compact rad_screen;
	extern uint16 change5_seq[];
	extern Compact locker1;
	extern Compact coat;
	extern uint16 change_back5[];
	extern Compact machine;
	extern uint16 anita_give_seq[];
	extern uint16 s14_fast_list[];
	extern Compact fact3_exit_right;
	extern uint16 joey_list_14[];
	extern uint16 rad_close_locker[];
	extern uint16 locker_open_seq[];
	extern uint16 s14_mouse[];
	extern uint16 s14_chip_list[];
	extern uint16 change_back2[];
	extern uint16 change2_seq[];
	extern uint16 change_back1[];
	extern uint16 change6_seq[];
	extern uint16 rs_foster_13_15[];
	extern Compact flap;
	extern uint16 weld_seq[];
	extern uint16 rs_foster_15_13[];
	extern Compact whole_floor;
	extern uint16 s15_logic[];
	extern uint16 flap_seq[];
	extern uint16 s15_floor_table[];
	extern Compact s15_flooor;
	extern uint16 flip_seq[];
	extern Compact skey;
	extern uint16 s15_pal[];
	extern Compact wd40;
	extern Compact junction_box;
	extern uint16 rs_joey_15_13[];
	extern Compact store_exit;
	extern uint16 s15_fast_list[];
	extern Compact nu_floor;
	extern Compact floor_putty;
	extern uint16 s15_mouse[];
	extern uint16 joey_list_15[];
	extern uint16 get_putty_seq[];
	extern uint16 shelf_get_seq[];
	extern uint16 s15_fake_mouse[];
	extern uint16 s15_chip_list[];
	extern Compact reactor_lower;
	extern uint16 foster2_die_seq[];
	extern Compact reactor_console;
	extern uint16 s16_fast_list[];
	extern Compact entrance_exit;
	extern uint16 console_16_seq[];
	extern uint16 s16_floor_table[];
	extern Compact s16_floor;
	extern uint16 s16_pal[];
	extern uint16 s16_chip_list[];
	extern uint16 rad_con_look[];
	extern uint16 s16_logic[];
	extern uint16 foster_die_seq[];
	extern Compact reactor_door;
	extern uint16 s16_mouse[];
	extern uint16 rs_foster_14_16[];
	extern uint16 fost_con_look[];
	extern uint16 pulseb_seq[];
	extern uint16 s17_floor_table[];
	extern Compact s17_floor;
	extern uint16 get_card_seq[];
	extern Compact core_exit;
	extern uint16 rs_foster_17_16[];
	extern uint16 s17_chip_list[];
	extern uint16 s17_pal[];
	extern uint16 s17_mouse[];
	extern Compact pulseb;
	extern uint16 s17_fast_list[];
	extern uint16 pulse_seq[];
	extern Compact anita_card;
	extern uint16 rs_foster_16_17[];
	extern uint16 s17_logic[];
	extern Compact pulse;
	extern uint16 steam_alert_seq[];
	extern uint16 sleep_seq[];
	extern Compact power_door;
	extern uint16 steam1_seq[];
	extern uint16 unpush_but_seq[];
	extern Compact right_lever;
	extern uint16 steam2_seq[];
	extern uint16 blowoff_seq[];
	extern uint16 s18_mouse[];
	extern uint16 power_start_seq[];
	extern Compact power_switch;
	extern uint16 power_stop_seq[];
	extern uint16 s18_floor_table[];
	extern Compact s18_floor;
	extern uint16 joey_list_s18[];
	extern uint16 nu_chip_18[];
	extern Compact power_chair;
	extern uint16 steam3_seq[];
	extern Compact left_skull;
	extern uint16 rs_gordon_end[];
	extern Compact right_skull;
	extern uint16 power_spin_seq[];
	extern uint16 s18_fast_list[];
	extern uint16 steam4_seq[];
	extern Compact steam;
	extern Compact socket;
	extern Compact power_motor;
	extern uint16 joey_unpush_seq[];
	extern uint16 high_push_seq[];
	extern Compact left_lever;
	extern uint16 s18_pal[];
	extern uint16 rs_foster_to_18[];
	extern uint16 power_bang_seq[];
	extern uint16 s18_logic[];
	extern uint16 high_unpush_seq[];
	extern uint16 s18_chip_list[];
	extern Compact power_bang;
	extern uint16 push_but_seq[];
	extern uint16 door_blast_seq[];
	extern uint16 rs_gordon_start[];
	extern uint16 monhit_seq[];
	extern uint16 spanner_seq[];
	extern uint16 joey_push_seq[];
	extern Compact right_exit_s18;
	extern uint16 rs_foster_19_28[];
	extern uint16 s19_mouse[];
	extern uint16 s19_floor_table[];
	extern Compact s19_floor;
	extern uint16 rs_28_sml_19[];
	extern uint16 s19_logic[];
	extern Compact right_exit_19;
	extern ExtCompact useless_char_ext;
	extern Compact useless_char;
	extern Compact left_exit_19;
	extern uint16 joey_list_s19[];
	extern uint16 rs_foster_28_19[];
	extern Compact top_right_19;
	extern uint16 s19_pal[];
	extern uint16 s19_chip_list[];
	extern uint16 s19_fast_list[];
	extern uint16 car_down_seq[];
	extern uint16 car_up_seq[];
	extern uint16 smoke1_seq[];
	extern uint16 screen1_logic[];
	extern uint16 fast_list_cut[];
	extern uint16 lfan2_seq[];
	extern Compact smoke2;
	extern Compact lfan2;
	extern uint16 lfan1_seq[];
	extern uint16 smoke2_seq[];
	extern Compact car_down;
	extern uint16 fire2_seq[];
	extern Compact smoke1;
	extern uint16 fast_list_sc1[];
	extern Compact fire_notice2;
	extern Compact car_up;
	extern Compact fire1;
	extern Compact ss_sign;
	extern Compact lfan1;
	extern uint16 chip_list_1[];
	extern uint16 sc1_mouse[];
	extern Compact fire2;
	extern uint16 fire1_seq[];
	extern uint16 gal_look_up[];
	extern uint16 rs_joey_start_20[];
	extern uint16 s20_pal[];
	extern Compact lamb_door_20;
	extern Compact reich_window;
	extern uint16 usecard_seq[];
	extern uint16 s20_chip_list[];
	extern Compact down_exit_20;
	extern uint16 s20_fast_list[];
	extern uint16 rs_all_28_20[];
	extern uint16 s20_floor_table[];
	extern Compact s20_floor;
	extern uint16 lamb_20_open[];
	extern Compact lamb_window;
	extern uint16 gal_look_down[];
	extern Compact lamb_slot;
	extern uint16 lamb_20_close[];
	extern Compact shrub_3;
	extern uint16 reich_20_close[];
	extern Compact reich_slot;
	extern Compact shrub_2;
	extern uint16 joey_list_20[];
	extern uint16 reich_20_open[];
	extern Compact shrub_1;
	extern uint16 s20_logic[];
	extern uint16 lamb_card_seq2[];
	extern Compact reich_door_20;
	extern uint16 rs_foster_20_28[];
	extern ExtCompact gallager_bel_ext;
	extern Compact gallager_bel;
	extern uint16 s20_mouse[];
	extern uint16 lamb_sit_up[];
	extern uint16 s21_logic[];
	extern uint16 cat1_seq[];
	extern uint16 rs_foster_21_20[];
	extern uint16 inner_lamb_close[];
	extern uint16 push_dispensor[];
	extern uint16 s21_floor_table[];
	extern Compact s21_floor;
	extern uint16 s21_chip_list[];
	extern uint16 lamb_sit_seq[];
	extern Compact cat_food;
	extern Compact video;
	extern Compact video_screen;
	extern uint16 rs_foster_20_21[];
	extern uint16 cat4_seq[];
	extern uint16 video_out[];
	extern uint16 inner_lamb_open[];
	extern uint16 s21_mouse[];
	extern uint16 video_in[];
	extern Compact lambs_books;
	extern uint16 cat_walk_seq[];
	extern Compact big_pict1;
	extern Compact lambs_chair;
	extern uint16 put_video_in[];
	extern uint16 watch_film[];
	extern Compact cat;
	extern Compact big_pict3;
	extern uint16 cat3_seq[];
	extern uint16 s21_fast_list[];
	extern uint16 bend_down[];
	extern uint16 take_video_out[];
	extern Compact big_pict2;
	extern uint16 cat_food_seq[];
	extern Compact left_exit_21;
	extern Compact inner_lamb_door;
	extern Compact fake_floor_21;
	extern uint16 cat_eat_seq[];
	extern uint16 more_cassette_seq[];
	extern Compact cassette;
	extern uint16 s21_pal[];
	extern Compact dispensor;
	extern uint16 cat2_seq[];
	extern uint16 take_cassette_seq[];
	extern uint16 fost_replace_pill[];
	extern uint16 rs_foster_20_22[];
	extern Compact reich_picture;
	extern Compact inner_reich_door;
	extern uint16 rs_foster_22_20[];
	extern uint16 fost_remove_pill[];
	extern uint16 inner_reich_open[];
	extern uint16 rs_magazine[];
	extern uint16 remove_pillow[];
	extern uint16 s22_floor_table[];
	extern Compact pillow;
	extern uint16 inner_reich_close[];
	extern Compact lamb_bed;
	extern uint16 replace_pillow[];
	extern uint16 get_magazine_seq[];
	extern uint16 tank3_seq[];
	extern uint16 tank2_seq[];
	extern Compact s22_floor;
	extern Compact right_exit_22;
	extern Compact reich_chair;
	extern uint16 s22_mouse[];
	extern Compact fish_tank;
	extern Compact fake_floor_22;
	extern uint16 s22_fast_list[];
	extern uint16 s22_logic[];
	extern uint16 s22_chip_list[];
	extern Compact magazine;
	extern uint16 fish_seq[];
	extern Compact cert;
	extern uint16 s22_pal[];
	extern Compact cabinet;
	extern Compact lamb_tv;
	extern Compact fish_food;
	extern Compact fish_poster;
	extern Compact link_23;
	extern uint16 s23_chip_list[];
	extern Compact sculpture;
	extern Compact wreck_23;
	extern Compact anchor_exit_23;
	extern Compact bin_23;
	extern uint16 s23_pal[];
	extern uint16 s23_logic[];
	extern uint16 s23_mouse[];
	extern Compact small_exit_23;
	extern Compact travel_exit_23;
	extern uint16 s23_fast_list[];
	extern Compact left_exit_23;
	extern uint16 s23_floor_table[];
	extern Compact s23_floor;
	extern uint16 rs_foster_29_23[];
	extern uint16 give_mag_seq[];
	extern uint16 trev_read_mag[];
	extern uint16 s24_floor_table[];
	extern Compact s24_floor;
	extern uint16 mag_away[];
	extern Compact left_exit_24;
	extern Compact mural;
	extern uint16 trevor_relax[];
	extern uint16 rs_foster_23_24[];
	extern uint16 s24_mouse[];
	extern uint16 trevor_unrelax[];
	extern Compact pidgeons;
	extern uint16 trev_get_mag[];
	extern uint16 s24_chip_list[];
	extern uint16 rs_foster_24_23[];
	extern uint16 mag_back_seq[];
	extern uint16 push_globe[];
	extern uint16 s24_pal[];
	extern uint16 joey_list_s24[];
	extern uint16 mag_out[];
	extern uint16 trev_turn_page[];
	extern ExtCompact trevor_ext;
	extern Compact trevor;
	extern Compact ticket;
	extern Compact new_york_poster;
	extern Compact london_poster;
	extern uint16 get_ticket[];
	extern uint16 s24_logic[];
	extern uint16 globe_spin[];
	extern uint16 ticket_seq[];
	extern Compact globe;
	extern uint16 trevor_scratch[];
	extern uint16 s24_fast_list[];
	extern Compact sales_chart;
	extern uint16 hook_seq[];
	extern uint16 s25_pal[];
	extern Compact statue_25;
	extern Compact anchor_exit_25;
	extern uint16 spark_25_seq[];
	extern uint16 rs_foster_23_25[];
	extern ExtCompact anchor_ext;
	extern Compact anchor;
	extern uint16 s25_chip_list[];
	extern uint16 lazer_25_seq[];
	extern uint16 s25_fast_list[];
	extern uint16 anchor_leave_seq[];
	extern uint16 joey_list_s25[];
	extern uint16 rs_foster_25_23[];
	extern uint16 s25_mouse[];
	extern uint16 s25_logic[];
	extern uint16 anchor_seq[];
	extern uint16 anchor_return_seq[];
	extern Compact hook;
	extern Compact spark_25;
	extern Compact lazer_25;
	extern uint16 s25_floor_table[];
	extern uint16 get_anchor_seq[];
	extern Compact s25_floor;
	extern Compact bio_door;
	extern Compact plant_26;
	extern uint16 s26_floor_table[];
	extern uint16 s26_mouse[];
	extern uint16 s26_pal[];
	extern uint16 helga_awake[];
	extern Compact right_exit_26;
	extern uint16 wobble2[];
	extern uint16 helga_byeee[];
	extern Compact left_exit_26;
	extern uint16 rs_joey_start_26[];
	extern uint16 bio_door_open[];
	extern uint16 wobble1[];
	extern ExtCompact holo_ext;
	extern Compact holo;
	extern Compact poster2;
	extern uint16 s26_fast_list[];
	extern uint16 joey_list_s26[];
	extern uint16 return_leaflet[];
	extern uint16 rs_foster_19_26[];
	extern uint16 get_leaflet[];
	extern Compact poster3;
	extern Compact leaflet;
	extern uint16 s26_chip_list[];
	extern uint16 rs_foster_26_19[];
	extern Compact poster4;
	extern uint16 s26_logic[];
	extern Compact poster1;
	extern Compact s26_floor;
	extern uint16 s27_logic[];
	extern uint16 scan_27_seq[];
	extern uint16 body_table[];
	extern uint16 glass_scan[];
	extern uint16 put_glass_seq[];
	extern uint16 burke_u_to_d[];
	extern uint16 burke_l_to_u[];
	extern Compact helmet_cole;
	extern uint16 rs_foster_27_26[];
	extern uint16 burke_d_to_u[];
	extern uint16 burke_st_talk[];
	extern uint16 out_chair_seq[];
	extern uint16 burke_st_right[];
	extern uint16 burke_u_to_l[];
	extern uint16 hand_op_seq[];
	extern uint16 helmet_up[];
	extern uint16 hand_in_seq[];
	extern uint16 burke_r_to_u[];
	extern uint16 burke_left[];
	extern uint16 burke_st_up[];
	extern uint16 burke_st_left[];
	extern uint16 chair_table[];
	extern Compact gas;
	extern uint16 lung_seq[];
	extern uint16 burke_l_to_r[];
	extern uint16 glass_slot_open[];
	extern ExtCompact body_ext;
	extern Compact body;
	extern uint16 glove_off_seq[];
	extern uint16 rs_small_burke[];
	extern uint16 burke_d_to_l[];
	extern uint16 rs_foster_26_27[];
	extern uint16 burke_up[];
	extern uint16 operate_seq[];
	extern uint16 s27_floor_table[];
	extern uint16 helmet_down[];
	extern uint16 squirm_seq[];
	extern uint16 burke_r_to_d[];
	extern uint16 glove_on_seq[];
	extern Compact chart2;
	extern uint16 burke_r_to_l[];
	extern Compact chart1;
	extern uint16 rs_big_burke[];
	extern uint16 burke_down[];
	extern uint16 medi_comp_seq[];
	extern uint16 helmet_op_seq[];
	extern uint16 gas_seq[];
	extern uint16 burke_l_to_d[];
	extern uint16 glass_slot_close[];
	extern uint16 s27_mouse[];
	extern uint16 burke_right[];
	extern uint16 burke_st_down[];
	extern uint16 burke_u_to_r[];
	extern uint16 burke_d_to_r[];
	extern ExtCompact burke_ext;
	extern Compact burke;
	extern uint16 shake_seq[];
	extern uint16 hands_out_seq[];
	extern uint16 s27_pal[];
	extern uint16 s27_fast_list[];
	extern Compact medi_comp;
	extern Compact glass_slot;
	extern uint16 in_chair_seq[];
	extern uint16 s27_chip_list[];
	extern uint16 kidney_seq[];
	extern Compact scanner_27;
	extern Compact s27_floor;
	extern uint16 fprint_seq[];
	extern Compact right_exit_27;
	extern Compact chair_27;
	extern uint16 s28_chip_list[];
	extern uint16 s28_floor_table[];
	extern uint16 s28_sml_table[];
	extern Compact s28_sml_floor;
	extern uint16 slot_28_anim[];
	extern Compact left_exit_28;
	extern uint16 rs_foster_28_29[];
	extern Compact s28_floor;
	extern uint16 s28_logic[];
	extern Compact small_r_28;
	extern uint16 s28_pal[];
	extern Compact up_exit_28;
	extern Compact dustbin_28;
	extern uint16 rs_31_28[];
	extern Compact slot_28;
	extern uint16 s28_mouse[];
	extern uint16 lift_28_close[];
	extern uint16 lift_28_open[];
	extern Compact right_exit_28;
	extern uint16 rs_lamb_28[];
	extern uint16 rs_foster_29_28[];
	extern uint16 s28_sml_mouse[];
	extern Compact lift_28;
	extern Compact small_l_28;
	extern uint16 rs_joey_7_29[];
	extern uint16 s29_floor_table[];
	extern Compact s29_floor;
	extern uint16 card_slot_29_anim[];
	extern uint16 s29_lift_open[];
	extern uint16 rs_19_sml_28[];
	extern uint16 sml_joey_list_28[];
	extern Compact s29_card_slot;
	extern uint16 s29_sml_mouse[];
	extern uint16 s29_logic[];
	extern uint16 s29_pal[];
	extern Compact small_l_29;
	extern uint16 rs_foster_7_29[];
	extern uint16 rs_28_sml_29[];
	extern uint16 s29_chip_list[];
	extern uint16 s29_lift_close[];
	extern uint16 rs_29_sml_23[];
	extern uint16 rs_lamb_start_bel[];
	extern uint16 s29_mouse[];
	extern Compact lift_29;
	extern Compact lift29_light;
	extern uint16 joey_list_s29[];
	extern Compact right_exit_29;
	extern uint16 rs_foster_23_29[];
	extern Compact left_exit_29;
	extern uint16 lamb_card_29[];
	extern Compact cable_29;
	extern uint16 get_cable_29_seq[];
	extern Compact small_r_29;
	extern uint16 s29_sml_table[];
	extern Compact s29_sml_floor;
	extern uint16 rs_23_sml_29[];
	extern uint16 rs_29_sml_28[];
	extern uint16 sml_joey_list_29[];
	extern void *data_3[];
	extern uint16 sml_loaderb_l_to_u[];
	extern uint16 joey_list_s2[];
	extern uint16 sml_loader_u_to_l[];
	extern uint16 loader_right[];
	extern uint16 loaderb_st_left[];
	extern uint16 loader_r_to_d[];
	extern uint16 loader_st_down[];
	extern uint16 sml_loaderb_l_to_r[];
	extern uint16 loaderb_st_down[];
	extern uint16 sml_loaderb_r_to_u[];
	extern uint16 sml_loaderb_st_up[];
	extern uint16 loaderb_d_to_l[];
	extern uint16 sml_loaderb_st_right[];
	extern uint16 sml_loader_r_to_l[];
	extern uint16 sml_loader_r_to_u[];
	extern uint16 sml_loader_st_down[];
	extern uint16 loader_l_to_r[];
	extern uint16 sml_loaderb_d_to_l[];
	extern uint16 loaderb_r_to_u[];
	extern uint16 loader_left[];
	extern uint16 loaderb_right[];
	extern uint16 loaderb_r_to_d[];
	extern uint16 loader_d_to_u[];
	extern uint16 sml_loaderb_st_down[];
	extern uint16 sml_loaderb_up[];
	extern uint16 sml_loader_d_to_r[];
	extern uint16 loader_st_up[];
	extern Compact right_exit_rm2;
	extern uint16 sml_loaderb_right[];
	extern uint16 loader_u_to_l[];
	extern uint16 sml_loader_st_right[];
	extern Compact panel;
	extern Compact alarm_flash;
	extern uint16 loader_st_right[];
	extern uint16 sml_loader_l_to_u[];
	extern uint16 loaderb_u_to_r[];
	extern uint16 sml_loader_u_to_r[];
	extern uint16 loaderb_d_to_r[];
	extern uint16 loaderb_u_to_l[];
	extern uint16 sml_loaderb_d_to_u[];
	extern uint16 loaderb_left[];
	extern uint16 sml_loaderb_r_to_d[];
	extern uint16 loader_l_to_u[];
	extern uint16 sml_loader_up[];
	extern uint16 rs_test_jobs[];
	extern uint16 loaderb_l_to_d[];
	extern uint16 sc2_mouse[];
	extern uint16 loaderb_up[];
	extern uint16 loader_u_to_d[];
	extern uint16 sml_loader_u_to_d[];
	extern Compact hole;
	extern uint16 loaderb_st_up[];
	extern uint16 sml_loader_down[];
	extern uint16 sml_loaderb_u_to_l[];
	extern uint16 loader_l_to_d[];
	extern uint16 sml_loaderb_u_to_d[];
	extern uint16 loader_u_to_r[];
	extern uint16 loaderb_l_to_r[];
	extern uint16 sml_loader_d_to_l[];
	extern uint16 loaderb_r_to_l[];
	extern uint16 top_lift_table[];
	extern Compact robot_shell;
	extern Compact junk1;
	extern uint16 loader_down[];
	extern uint16 loader_d_to_r[];
	extern uint16 top_lift_up[];
	extern uint16 sml_loader_st_up[];
	extern uint16 transporter_table[];
	extern uint16 sml_loader_r_to_d[];
	extern uint16 loaderb_st_right[];
	extern uint16 chip_list_s2[];
	extern uint16 sml_loaderb_r_to_l[];
	extern Compact dead_loader;
	extern uint16 top_lift_2_up[];
	extern uint16 loaderb_l_to_u[];
	extern uint16 loaderb_down[];
	extern uint16 loader_r_to_u[];
	extern uint16 top_lift_2_down[];
	extern Compact left_exit_rm2;
	extern uint16 loader_up[];
	extern uint16 loader_st_left[];
	extern uint16 loader_d_to_l[];
	extern uint16 loader_r_to_l[];
	extern uint16 loaderb_u_to_d[];
	extern uint16 loaderb_d_to_u[];
	extern uint16 sml_loader_left[];
	extern uint16 sml_loader_right[];
	extern uint16 sml_loader_st_left[];
	extern uint16 sml_loader_d_to_u[];
	extern uint16 sml_loader_l_to_d[];
	extern uint16 sml_loader_l_to_r[];
	extern uint16 sml_loaderb_down[];
	extern uint16 sml_loaderb_left[];
	extern uint16 sml_loaderb_st_left[];
	extern uint16 sml_loaderb_u_to_r[];
	extern uint16 sml_loaderb_d_to_r[];
	extern uint16 sml_loaderb_l_to_d[];
	extern ExtCompact loader_ext;
	extern Compact loader;
	extern Compact junk2;
	extern uint16 fast_list_sc2[];
	extern Compact light_one;
	extern uint16 sc2_logic[];
	extern Compact top_lift_2;
	extern Compact top_lift;
	extern uint16 top_lift_down[];
	extern Compact top_barrel;
	extern uint16 sc32_vinc_talk[];
	extern uint16 sc30_palette[];
	extern uint16 sc36_col_talk2[];
	extern uint16 sc42_judge_point[];
	extern uint16 sc30_floor_table[];
	extern Compact sc30_floor;
	extern uint16 reset_33_30[];
	extern uint16 sc30_hen_step_b[];
	extern uint16 sc42_pros_talk[];
	extern uint16 sc36_col_talk1[];
	extern uint16 sc30_fast_list[];
	extern uint16 sc30_chip_list[];
	extern uint16 sc30_logic_list[];
	extern uint16 sc30_mouse_list[];
	extern Compact sc30_exit_31;
	extern Compact sc30_exit_33;
	extern uint16 reset_31_30[];
	extern Compact sc30_court_door;
	extern Compact sc30_notice;
	extern Compact sc30_statue_1;
	extern Compact sc30_statue_2;
	extern Compact sc30_exit_36;
	extern ExtCompact sc30_henri_ext;
	extern Compact sc30_henri;
	extern uint16 sc30_henri_talk[];
	extern uint16 sc30_henri_tie[];
	extern uint16 sc30_hen_step_f[];
	extern uint16 sc30_hen_blink[];
	extern uint16 sc30_push_door[];
	extern uint16 reset_36_30[];
	extern uint16 sc30_joey_list[];
	extern uint16 dani_conv[];
	extern uint16 sc38_dani_sattlk[];
	extern uint16 sc31_guard_talk[];
	extern uint16 sc38_phone_talk[];
	extern uint16 sc32_garden_talk[];
	extern uint16 sc31_guard_talk2[];
	extern uint16 barman_talk[];
	extern uint16 sc36_gal_talk[];
	extern uint16 sc36_juke_talk[];
	extern uint16 sc36_babs_talk[];
	extern uint16 reset_42_30[];
	extern uint16 reset_court_open[];
	extern uint16 sc30_court_close[];
	extern uint16 sc42_judge_talk[];
	extern uint16 sc42_jobs_talk[];
	extern uint16 sc42_blunt_talk[];
	extern uint16 sc42_fos_talk_l[];
	extern uint16 sc42_fos_talk_r[];
	extern uint16 sc42_dani_talk[];
	extern uint16 sc42_clerk_talk[];
	extern uint16 sc42_jobs_point[];
	extern uint16 sc42_jdg_to_jobs[];
	extern void *data_4[];
	extern uint16 reset_start_31[];
	extern uint16 sc31_pull_rope[];
	extern uint16 sc31_guard_move[];
	extern Compact sc31_exit_39;
	extern uint16 sc31_plank_flick[];
	extern uint16 sc31_fast_list[];
	extern uint16 sc31_dog_swim[];
	extern uint16 sc31_bisc_drop[];
	extern uint16 reset_39_31[];
	extern uint16 sc31_climb_plank[];
	extern uint16 sc31_bricks_up[];
	extern Compact sc31_plank;
	extern uint16 sc31_lift_close[];
	extern uint16 sc31_get_bricks[];
	extern uint16 sc31_rope_pulled[];
	extern Compact sc31_rope;
	extern uint16 sc31_palette[];
	extern Compact sc31_exit_30;
	extern uint16 sc31_put_bisc[];
	extern uint16 sc31_bricks_fall[];
	extern uint16 sc31_plank_raise[];
	extern uint16 sc31_bisc_placed[];
	extern uint16 sc31_joey_fall[];
	extern uint16 sc31_plank_drop[];
	extern uint16 sc31_lift_open[];
	extern uint16 sc31_get_board[];
	extern uint16 sc31_rope_lower[];
	extern uint16 sc31_drop_rope[];
	extern uint16 sc31_guard_reach[];
	extern uint16 reset_32_31[];
	extern uint16 sc31_guard_blink[];
	extern uint16 sc31_use_card[];
	extern uint16 rs_guard_avail[];
	extern uint16 sc31_bricks_down[];
	extern uint16 sc31_rope_drop[];
	extern uint16 sc31_get_plank[];
	extern uint16 sc31_floor_table[];
	extern Compact sc31_floor;
	extern Compact sc31_end_of_rope;
	extern uint16 sc31_dog_fly[];
	extern Compact sc31_lift;
	extern uint16 sc31_chip_list[];
	extern uint16 sc31_guard_chat[];
	extern Compact sc31_biscuits;
	extern uint16 reset_30_31[];
	extern Compact sc31_bricks;
	extern uint16 sc31_lower_rope[];
	extern uint16 sc31_bisc_raise[];
	extern Compact sc31_at_watcher;
	extern uint16 sc31_dog_rise[];
	extern uint16 rs_guard_chat[];
	extern uint16 sc31_mouse_list[];
	extern Compact sc31_joey;
	extern Compact sc31_lift_slot;
	extern uint16 sc31_logic_list[];
	extern ExtCompact sc31_guard_ext;
	extern Compact sc31_guard;
	extern Compact sc31_exit_32;
	extern uint16 sc31_joey_list[];
	extern uint16 sc32_gardening1[];
	extern uint16 reset_spunky_32[];
	extern uint16 sc32_vinc_anim[];
	extern uint16 reset_38_32[];
	extern Compact sc32_plant_2;
	extern uint16 sc32_use_card[];
	extern ExtCompact sc32_vincent_ext;
	extern Compact sc32_vincent;
	extern uint16 sc32_gard_turn_d[];
	extern uint16 sc32_lift_open[];
	extern uint16 sc32_lift_close[];
	extern uint16 sc32_mouse_list[];
	extern Compact sc32_exit_31;
	extern uint16 sc32_use_com[];
	extern uint16 sc32_gardener_dn[];
	extern ExtCompact sc32_buzzer_ext;
	extern Compact sc32_buzzer;
	extern uint16 sc32_floor_table[];
	extern Compact sc32_floor;
	extern uint16 sc32_chip_list[];
	extern uint16 sc32_palette[];
	extern uint16 reset_33_32[];
	extern ExtCompact sc32_gardener_ext;
	extern Compact sc32_gardener;
	extern uint16 sc32_fast_list[];
	extern uint16 sc32_logic_list[];
	extern uint16 reset_dani_32[];
	extern Compact sc32_plant_3;
	extern Compact sc32_terminal;
	extern uint16 sc32_gardener_up[];
	extern Compact sc32_plant_1;
	extern uint16 sc32_gard_turn_u[];
	extern uint16 sc32_joey_list[];
	extern uint16 sc32_gardening2[];
	extern uint16 reset_31_32[];
	extern Compact sc32_lift;
	extern Compact sc32_exit_33;
	extern Compact sc33_lock;
	extern uint16 reset_32_33[];
	extern uint16 sc33_palette[];
	extern uint16 sc33_door_open[];
	extern uint16 reset_34_33[];
	extern Compact sc33_shed_door;
	extern uint16 sc33_push_door2[];
	extern Compact sc33_exit_32;
	extern uint16 sc33_logic_list[];
	extern uint16 sc33_floor_table[];
	extern Compact sc33_floor;
	extern Compact sc33_exit_30;
	extern uint16 sc33_joey_list[];
	extern uint16 sc33_push_door1[];
	extern uint16 sc33_chip_list[];
	extern uint16 sc33_fast_list[];
	extern uint16 sc33_mouse_list[];
	extern uint16 sc33_use_card[];
	extern uint16 reset_30_33[];
	extern uint16 sc34_fast_list[];
	extern uint16 sc34_mouse_list[];
	extern Compact sc34_secateurs;
	extern uint16 sc34_logic_list[];
	extern uint16 sc34_get_secs[];
	extern uint16 sc34_chip_list[];
	extern uint16 reset_33_34[];
	extern uint16 sc34_stairs2[];
	extern uint16 sc34_floor_table[];
	extern Compact sc34_floor;
	extern Compact sc34_bricks;
	extern uint16 sc34_stairs1[];
	extern Compact sc34_tkt_machine;
	extern Compact sc34_map;
	extern uint16 sc34_palette[];
	extern Compact sc34_door;
	extern uint16 sc36_get_glass[];
	extern uint16 sc36_mouse_list[];
	extern uint16 babs_d_to_u[];
	extern uint16 bar_drink[];
	extern uint16 babs_l_to_u[];
	extern uint16 bar_put_cloth[];
	extern uint16 babs_u_to_l[];
	extern uint16 sc36_col_down2[];
	extern uint16 babs_left[];
	extern uint16 babs_u_to_t[];
	extern uint16 sc36_col_up1[];
	extern uint16 sc36_fos_down2[];
	extern uint16 sc36_col_deal[];
	extern uint16 sc36_palette[];
	extern uint16 babs_up[];
	extern uint16 babs_down[];
	extern uint16 babs_right[];
	extern uint16 babs_st_up[];
	extern uint16 babs_st_down[];
	extern uint16 babs_st_left[];
	extern uint16 babs_st_right[];
	extern uint16 babs_st_talk[];
	extern uint16 babs_u_to_d[];
	extern uint16 babs_u_to_r[];
	extern uint16 babs_d_to_l[];
	extern uint16 babs_d_to_r[];
	extern uint16 babs_d_to_t[];
	extern uint16 babs_l_to_d[];
	extern uint16 babs_l_to_r[];
	extern uint16 babs_l_to_t[];
	extern uint16 babs_r_to_u[];
	extern uint16 babs_r_to_d[];
	extern uint16 babs_r_to_l[];
	extern uint16 babs_r_to_t[];
	extern uint16 babs_t_to_u[];
	extern uint16 babs_t_to_d[];
	extern uint16 babs_t_to_l[];
	extern uint16 babs_t_to_r[];
	extern ExtCompact sc36_babs_ext;
	extern Compact sc36_babs;
	extern uint16 sc36_col_down4[];
	extern uint16 sc36_logic_list[];
	extern uint16 reset_30_36[];
	extern uint16 sc36_doorshut[];
	extern uint16 sc36_fos_up2[];
	extern uint16 bar_get_cloth[];
	extern Compact sc36_juke_light;
	extern uint16 sc36_low_floor_table[];
	extern Compact sc36_low_floor;
	extern uint16 sc36_floor_table[];
	extern uint16 sc36_jukebox_on[];
	extern Compact sc36_door;
	extern uint16 sc36_col_down3[];
	extern ExtCompact sc36_jukebox_ext;
	extern Compact sc36_jukebox;
	extern uint16 sc36_juke_kicked[];
	extern uint16 sc36_fos_up1[];
	extern uint16 sc36_use_jukebox[];
	extern uint16 sc36_col_think[];
	extern uint16 bar_wipe2[];
	extern Compact sc36_gal_legs;
	extern uint16 sc36_col_up2[];
	extern Compact sc36_cards;
	extern uint16 sc36_reach_glass[];
	extern uint16 sc36_juke_break[];
	extern uint16 sc36_fos_down1[];
	extern uint16 reset_37_36[];
	extern Compact sc36_glass;
	extern Compact sc36_col_feet;
	extern uint16 sc36_col_blink2[];
	extern uint16 sc36_jukebox_off[];
	extern Compact sc36_band;
	extern Compact sc36_sensor;
	extern uint16 sc36_col_drink[];
	extern uint16 reset_juke_light[];
	extern uint16 sc36_gal_look1[];
	extern uint16 reset_colston[];
	extern uint16 sc36_chip_list[];
	extern uint16 sc36_juke_stuck[];
	extern uint16 sc36_col_blink1[];
	extern uint16 bar_wipe[];
	extern uint16 sc36_gal_look2[];
	extern uint16 sc36_juke_sing[];
	extern ExtCompact sc36_colston_ext;
	extern Compact sc36_colston;
	extern uint16 sc36_col_down1[];
	extern ExtCompact sc36_gallagher_ext;
	extern Compact sc36_gallagher;
	extern uint16 sc36_col_up3[];
	extern uint16 sc36_band_anim[];
	extern uint16 sc36_col_kick[];
	extern Compact sc36_floor;
	extern uint16 sc36_dooropen[];
	extern uint16 bar_get_drink[];
	extern uint16 sc36_gal_deal[];
	extern uint16 bar_blink[];
	extern uint16 sc36_press_plate[];
	extern uint16 reset_jukebox[];
	extern uint16 sc36_fast_list[];
	extern uint16 sc36_col_up4[];
	extern ExtCompact sc36_barman_ext;
	extern Compact sc36_barman;
	extern Compact sc36_exit_30;
	extern uint16 sc37_mouse_list[];
	extern uint16 sc37_chip_list[];
	extern uint16 sc37_grillopen[];
	extern uint16 sc37_floor_table[];
	extern uint16 sc37_stepdown[];
	extern Compact sc37_big_box;
	extern uint16 sc37_footdrop[];
	extern uint16 sc37_putlid[];
	extern Compact sc37_sensor;
	extern uint16 sc37_lidused[];
	extern uint16 sc37_getlid[];
	extern uint16 sc37_flimsy_box_table[];
	extern uint16 sc37_thumbsup[];
	extern Compact sc37_wine_rack;
	extern uint16 sc37_fast_list[];
	extern uint16 sc37_holding_lid_table[];
	extern Compact sc37_holding_lid;
	extern uint16 sc37_lidup[];
	extern uint16 sc37_usesec[];
	extern uint16 sc37_stepup[];
	extern Compact sc37_lid;
	extern uint16 sc37_palette[];
	extern Compact sc37_floor;
	extern uint16 sc37_climbout[];
	extern Compact sc37_grill;
	extern uint16 sc37_uselid[];
	extern uint16 reset_36_37[];
	extern uint16 sc37_doorshut[];
	extern Compact sc37_door;
	extern uint16 sc37_usebar[];
	extern Compact sc37_flimsy_box;
	extern uint16 sc37_dooropen[];
	extern uint16 sc37_liddown[];
	extern uint16 sc37_logic_list[];
	extern uint16 sc37_crbarbox[];
	extern uint16 spu_left[];
	extern uint16 sc38_mouse_list[];
	extern uint16 sniff_left[];
	extern uint16 sc38_palette[];
	extern uint16 spu_u_to_l[];
	extern uint16 dan_d_to_r[];
	extern uint16 sex_t_to_r[];
	extern uint16 spu_u_to_d[];
	extern Compact sc38_dog_tray;
	extern uint16 sex_up[];
	extern uint16 dan_u_to_r[];
	extern uint16 sex_l_to_r[];
	extern uint16 spu_t_to_l[];
	extern uint16 dan_u_to_t[];
	extern uint16 sc38_screen_2[];
	extern uint16 dan_l_to_u[];
	extern uint16 sc38_screen_3[];
	extern uint16 dan_r_to_t[];
	extern uint16 sex_u_to_t[];
	extern uint16 sc38_dani_get_up[];
	extern uint16 sex_r_to_d[];
	extern uint16 dan_r_to_l[];
	extern uint16 sc38_logic_list[];
	extern uint16 piss_left[];
	extern uint16 sex_d_to_u[];
	extern uint16 dan_l_to_d[];
	extern uint16 sex_u_to_r[];
	extern Compact sc38_hand_set;
	extern uint16 spu_u_to_r[];
	extern uint16 dan_st_left[];
	extern uint16 piss_right[];
	extern uint16 sex_r_to_u[];
	extern uint16 sex_left[];
	extern uint16 sex_l_to_u[];
	extern uint16 spu_l_to_t[];
	extern uint16 sex_d_to_r[];
	extern uint16 sc38_floor_table[];
	extern uint16 sc38_get_food[];
	extern uint16 sex_right[];
	extern uint16 dan_st_talk[];
	extern uint16 reset_32_38[];
	extern Compact sc38_floor;
	extern uint16 sex_d_to_l[];
	extern uint16 spu_r_to_u[];
	extern uint16 reset_dani_sit[];
	extern uint16 spu_u_to_t[];
	extern uint16 spu_l_to_u[];
	extern uint16 spu_d_to_u[];
	extern uint16 sex_u_to_d[];
	extern uint16 sc38_dani_anim_2[];
	extern uint16 dan_t_to_r[];
	extern uint16 dan_st_up[];
	extern uint16 bark[];
	extern uint16 dan_left[];
	extern uint16 spu_r_to_d[];
	extern uint16 spu_l_to_r[];
	extern uint16 sex_r_to_t[];
	extern uint16 sex_st_down[];
	extern uint16 sc38_scr_bark[];
	extern uint16 dan_st_right[];
	extern uint16 spu_st_left[];
	extern Compact sc38_sofa;
	extern uint16 dan_d_to_l[];
	extern uint16 spu_r_to_l[];
	extern uint16 sc38_chip_list[];
	extern uint16 sc38_fast_list[];
	extern Compact sc38_video;
	extern Compact dog_bark_thing;
	extern uint16 sc38_screen_4[];
	extern uint16 dan_l_to_r[];
	extern uint16 sex_st_talk[];
	extern uint16 sex_st_right[];
	extern uint16 sc38_use_video[];
	extern Compact sc38_monitor;
	extern uint16 spu_st_talk[];
	extern uint16 sex_t_to_u[];
	extern uint16 sex_r_to_l[];
	extern uint16 sc38_dani_anim_1[];
	extern uint16 sc38_get_phone[];
	extern Compact sc38_lift;
	extern Compact sc38_biscuits;
	extern uint16 dan_r_to_u[];
	extern uint16 spu_up[];
	extern uint16 sc38_dani_anim_3[];
	extern uint16 sc38_lift_up[];
	extern uint16 sniff_right[];
	extern uint16 dan_st_down[];
	extern uint16 sc38_ringer_anim[];
	extern uint16 spu_st_right[];
	extern uint16 spu_l_to_d[];
	extern uint16 sc38_reach_food[];
	extern Compact sc38_ringer;
	extern uint16 spu_t_to_u[];
	extern Compact sc38_statue;
	extern uint16 dan_d_to_u[];
	extern uint16 spu_d_to_l[];
	extern uint16 dan_u_to_l[];
	extern uint16 reset_spunky_38[];
	extern uint16 spu_right[];
	extern uint16 sex_l_to_d[];
	extern uint16 reset_dani_stand[];
	extern uint16 dan_r_to_d[];
	extern uint16 spu_st_down[];
	extern uint16 dan_up[];
	extern uint16 dan_u_to_d[];
	extern uint16 dan_down[];
	extern uint16 dan_right[];
	extern uint16 dan_t_to_u[];
	extern uint16 sex_down[];
	extern uint16 sex_st_up[];
	extern uint16 sex_st_left[];
	extern uint16 sex_u_to_l[];
	extern ExtCompact danielle_ext;
	extern Compact danielle;
	extern uint16 spu_d_to_r[];
	extern uint16 spu_down[];
	extern uint16 spu_st_up[];
	extern ExtCompact spunky_ext;
	extern Compact spunky;
	extern uint16 sc38_video_anim[];
	extern uint16 sc38_screen_1[];
	extern uint16 sc38_lift_down[];
	extern Compact sc39_exit_31;
	extern uint16 sc39_floor_table[];
	extern Compact sc39_floor;
	extern Compact sc39_walters;
	extern uint16 reset_41_39[];
	extern Compact sc39_exit_40;
	extern uint16 sc39_ascend[];
	extern uint16 sc39_logic_list[];
	extern uint16 sc39_chip_list[];
	extern uint16 reset_31_39[];
	extern uint16 sc39_mouse_list[];
	extern Compact sc39_exit_41;
	extern uint16 sc39_descend[];
	extern uint16 sc39_fast_list[];
	extern uint16 reset_40_39[];
	extern uint16 sc39_palette[];
	extern uint16 rs_low_lift2[];
	extern Compact low_lift_2;
	extern uint16 rs_low_lift3[];
	extern uint16 liftc3_down[];
	extern uint16 joey_list_s3[];
	extern uint16 liftc1_down[];
	extern uint16 shades_l_to_r[];
	extern uint16 shades_st_talk[];
	extern uint16 shades_st_right[];
	extern Compact eye_bolt;
	extern Compact lights1;
	extern uint16 rs_low_barrel[];
	extern Compact convey;
	extern uint16 search_seq[];
	extern ExtCompact eye_ball_ext;
	extern Compact eye_ball;
	extern uint16 liftc3_up[];
	extern uint16 shades_l_to_u[];
	extern uint16 shades_u_to_d[];
	extern uint16 s3_mouse[];
	extern uint16 shades_d_to_u[];
	extern ExtCompact smoulder_ext;
	extern Compact smoulder;
	extern Compact low_lift_3;
	extern uint16 shades_u_to_r[];
	extern Compact furnace;
	extern uint16 liftc1_up[];
	extern uint16 shades_r_to_d[];
	extern uint16 s3_logic[];
	extern uint16 shades_st_up[];
	extern uint16 smoulder_seq[];
	extern uint16 shades_up[];
	extern uint16 shades_down[];
	extern uint16 shades_left[];
	extern uint16 shades_right[];
	extern uint16 shades_st_down[];
	extern uint16 shades_st_left[];
	extern uint16 shades_u_to_l[];
	extern uint16 shades_d_to_l[];
	extern uint16 shades_d_to_r[];
	extern uint16 shades_l_to_d[];
	extern uint16 shades_r_to_u[];
	extern uint16 shades_r_to_l[];
	extern ExtCompact shades_ext;
	extern Compact shades;
	extern uint16 liftc2_down[];
	extern uint16 rs_start_joey_fly[];
	extern Compact steve_watch;
	extern uint16 liftc2_up[];
	extern Compact furnace_door;
	extern Compact slot;
	extern uint16 chip_list_sc3[];
	extern Compact low_lift;
	extern Compact joey_fly;
	extern uint16 rs_low_lift[];
	extern uint16 r3_floor_table[];
	extern Compact s3_floor;
	extern uint16 rs_joey_to_furnace[];
	extern Compact low_barrel;
	extern Compact sc40_body_2;
	extern uint16 sc40_locker_shut[];
	extern uint16 reset_39_40[];
	extern Compact sc40_body_3;
	extern Compact sc40_cabinet;
	extern uint16 sc40_palette[];
	extern uint16 sc40_descend[];
	extern Compact sc40_locker_1;
	extern uint16 sc40_floor_table[];
	extern Compact sc40_floor;
	extern uint16 sc40_chip_list[];
	extern Compact sc40_body_5;
	extern Compact sc40_locker_4;
	extern uint16 sc40_close_door[];
	extern uint16 sc40_locker_open[];
	extern Compact sc40_locker_2;
	extern Compact sc40_locker_3;
	extern uint16 sc40_fast_list[];
	extern Compact sc40_exit_39;
	extern Compact sc40_body_1;
	extern uint16 sc40_open_door[];
	extern Compact sc40_trolley;
	extern Compact sc40_locker_5;
	extern uint16 sc40_mouse_list[];
	extern uint16 sc40_logic_list[];
	extern Compact sc40_body_4;
	extern uint16 sc40_ascend[];
	extern uint16 sc41_mouse_list[];
	extern uint16 sc41_heat_2_anim[];
	extern Compact sc41_heat_1;
	extern uint16 reset_39_41[];
	extern uint16 sc41_heat_1_anim[];
	extern uint16 sc41_fast_list[];
	extern Compact sc41_heat_2;
	extern uint16 sc41_chip_list[];
	extern Compact sc41_heat_3;
	extern Compact sc41_exit_39;
	extern uint16 sc41_floor_table[];
	extern Compact sc41_floor;
	extern uint16 sc41_heat_3_anim[];
	extern uint16 sc41_logic_list[];
	extern uint16 sc41_palette[];
	extern uint16 sc42_jdg_hammer[];
	extern uint16 reset_30_42[];
	extern uint16 sc42_mouse_list[];
	extern Compact sc42_sign;
	extern uint16 sc42_fos_enter[];
	extern uint16 sc42_clerk_type[];
	extern ExtCompact sc42_judge_ext;
	extern Compact sc42_judge;
	extern uint16 sc42_logic_list[];
	extern uint16 sc42_jdg_turn[];
	extern uint16 sc42_fast_list[];
	extern ExtCompact sc42_prosecution_ext;
	extern Compact sc42_prosecution;
	extern uint16 sc42_fos_turn_lr[];
	extern uint16 sc42_chip_list[];
	extern ExtCompact sc42_clerk_ext;
	extern Compact sc42_clerk;
	extern uint16 reset_guard_42[];
	extern uint16 sc42_jdg_return[];
	extern uint16 sc42_fos_turn_rl[];
	extern ExtCompact sc42_jobsworth_ext;
	extern Compact sc42_jobsworth;
	extern uint16 reset_dani_42[];
	extern uint16 sc42_sign_anim[];
	extern uint16 sc42_blunt_enter[];
	extern uint16 sc42_blunt_leave[];
	extern uint16 sc42_jobs_enter[];
	extern uint16 sc42_palette[];
	extern uint16 sc42_fos_leave[];
	extern uint16 sc44_chip_list[];
	extern Compact sc44_rubble;
	extern uint16 reset_45_44[];
	extern Compact sc44_grill;
	extern uint16 sc44_floor_table[];
	extern uint16 sc44_drop_down[];
	extern Compact sc44_exit_45;
	extern uint16 sc44_fast_list[];
	extern uint16 sc44_palette[];
	extern uint16 sc44_logic_list[];
	extern Compact sc44_floor;
	extern uint16 sc44_mouse_list[];
	extern uint16 reset_37_44[];
	extern uint16 reset_44_45[];
	extern uint16 sc45_logic_list[];
	extern uint16 sc45_floor_table[];
	extern Compact sc45_floor;
	extern Compact sc45_exit_47;
	extern uint16 reset_46_45[];
	extern Compact sc45_exit_46;
	extern uint16 sc45_palette[];
	extern uint16 sc45_fast_list[];
	extern uint16 reset_47_45[];
	extern Compact sc45_exit_44;
	extern uint16 sc45_chip_list[];
	extern uint16 sc45_mouse_list[];
	extern uint16 sc46_floor_table[];
	extern uint16 sc46_palette[];
	extern uint16 sc46_chip_list[];
	extern Compact sc46_exit_45;
	extern uint16 sc46_logic_list[];
	extern uint16 sc46_mouse_list[];
	extern uint16 sc46_fast_list[];
	extern Compact sc46_rubble;
	extern uint16 reset_45_46[];
	extern Compact sc46_floor;
	extern uint16 reset_48_47[];
	extern uint16 sc47_palette[];
	extern uint16 reset_45_47[];
	extern uint16 sc47_mouse_list[];
	extern Compact sc47_exit_48;
	extern uint16 sc47_fast_list[];
	extern uint16 sc47_logic_list[];
	extern Compact sc47_exit_45;
	extern uint16 sc47_chip_list[];
	extern uint16 sc47_floor_table[];
	extern Compact sc47_floor;
	extern Compact sc48_eyes;
	extern uint16 sc48_mouse_list[];
	extern uint16 sc48_chip_list[];
	extern uint16 sc48_floor_table[];
	extern Compact sc48_socket;
	extern uint16 sc48_put_bulb[];
	extern uint16 sc48_palette[];
	extern uint16 sc48_fast_list[];
	extern Compact sc48_hole;
	extern uint16 reset_47_48[];
	extern uint16 sc48_logic_list[];
	extern uint16 reset_65_48[];
	extern uint16 sc48_eyes_anim[];
	extern Compact sc48_exit_47;
	extern Compact sc48_exit_65;
	extern Compact sc48_floor;
	extern uint16 sc48_light_pal[];
	extern uint16 jobs_u_to_l[];
	extern uint16 m_jobs_left[];
	extern uint16 jobs_l_to_u[];
	extern uint16 m_jobs_u_to_d[];
	extern Compact sarnie_s4;
	extern uint16 m_jobs_l_to_d[];
	extern uint16 s4_talk_table[];
	extern uint16 chip_list_sc4[];
	extern Compact r_talk_s4;
	extern Compact monitors_s4;
	extern uint16 m_jobs_down[];
	extern Compact jobsworth;
	extern uint16 jobs_st_down[];
	extern Compact notice4;
	extern uint16 m_jobs_st_down[];
	extern uint16 m_jobs_st_talk[];
	extern uint16 m_jobs_up[];
	extern uint16 m_jobs_right[];
	extern uint16 m_jobs_st_up[];
	extern uint16 m_jobs_st_left[];
	extern uint16 m_jobs_st_right[];
	extern uint16 m_jobs_u_to_l[];
	extern uint16 m_jobs_u_to_r[];
	extern uint16 m_jobs_d_to_u[];
	extern uint16 m_jobs_d_to_l[];
	extern uint16 m_jobs_d_to_r[];
	extern uint16 m_jobs_l_to_u[];
	extern uint16 m_jobs_l_to_r[];
	extern uint16 m_jobs_r_to_u[];
	extern uint16 m_jobs_r_to_d[];
	extern uint16 m_jobs_r_to_l[];
	extern uint16 jobs_up[];
	extern uint16 jobs_down[];
	extern uint16 jobs_left[];
	extern uint16 jobs_right[];
	extern uint16 jobs_st_up[];
	extern uint16 jobs_st_left[];
	extern uint16 jobs_st_right[];
	extern uint16 jobs_st_talk[];
	extern uint16 jobs_u_to_d[];
	extern uint16 jobs_u_to_r[];
	extern uint16 jobs_d_to_u[];
	extern uint16 jobs_d_to_l[];
	extern uint16 jobs_d_to_r[];
	extern uint16 jobs_l_to_d[];
	extern uint16 jobs_l_to_r[];
	extern uint16 jobs_r_to_u[];
	extern uint16 jobs_r_to_d[];
	extern uint16 jobs_r_to_l[];
	extern Compact buttons_s4;
	extern uint16 sc4_mouse_open[];
	extern Compact tv_screens_s4;
	extern uint16 sc4_logic[];
	extern Compact postcard;
	extern Compact knob_s4;
	extern Compact lazer_s4;
	extern uint16 fast_list_sc4[];
	extern Compact sc4_left_exit;
	extern Compact spanner_s4;
	extern uint16 joey_list_s4[];
	extern Compact chuck_s4;
	extern uint16 r4_floor_table[];
	extern uint16 sc4_mouse[];
	extern Compact sc4_floor;
	extern Compact cupboard_s4;
	extern Compact copter;
	extern uint16 rs_joey_29_7[];
	extern uint16 rs_joey_to_6[];
	extern Compact lift_notice;
	extern uint16 mid_up_get[];
	extern uint16 jostair1_seq[];
	extern uint16 grd_watch_seq[];
	extern uint16 s7_floor_table[];
	extern uint16 lamb_card_seq[];
	extern uint16 joey_list_s6[];
	extern uint16 s6_chip_list[];
	extern uint16 s6_pal[];
	extern uint16 rs_foster_8_7[];
	extern Compact joey_fly_6;
	extern uint16 s7_chip_list[];
	extern uint16 s8_logic[];
	extern uint16 s7_lift_open[];
	extern uint16 skorl_anim[];
	extern uint16 card_slot_anim[];
	extern uint16 dwn_stair1_seq[];
	extern Compact s7_floor;
	extern uint16 rs_foster_9_6[];
	extern uint16 s6_mouse[];
	extern uint16 rs_foster_to_5[];
	extern uint16 s8_chip_list[];
	extern uint16 weld_7_seq[];
	extern uint16 grd_blink_seq[];
	extern Compact down_exit_s8;
	extern uint16 jostair3_seq[];
	extern uint16 s5_chip_list[];
	extern Compact left_exit_s7;
	extern uint16 rs_foster_18_5[];
	extern uint16 upstairs1_seq[];
	extern uint16 rs_foster_6_7[];
	extern Compact s7_card_slot;
	extern uint16 rs_joey_fly[];
	extern uint16 s7_mouse[];
	extern uint16 s7_logic[];
	extern ExtCompact wreck_guard_ext;
	extern Compact wreck_guard;
	extern uint16 rs_foster_5_6[];
	extern uint16 rs_foster_7_8[];
	extern uint16 upstairs2_seq[];
	extern Compact security_exit;
	extern uint16 s6_logic[];
	extern Compact right_exit_s5;
	extern Compact cable_7;
	extern uint16 rs_foster_29_7[];
	extern uint16 s8_mouse[];
	extern uint16 s8_pal[];
	extern Compact security_exit_s6;
	extern uint16 jostair2_seq[];
	extern uint16 s6_floor_table[];
	extern Compact lift_s7;
	extern uint16 s5_mouse[];
	extern uint16 s5_logic[];
	extern uint16 dwn_stair2_seq[];
	extern uint16 s8_fast_list[];
	extern Compact right_exit_s7;
	extern uint16 s5_floor_table[];
	extern Compact s5_floor;
	extern uint16 s8_floor_table[];
	extern uint16 lamblook_seq[];
	extern uint16 s5_pal[];
	extern Compact left_exit_s5;
	extern Compact right_exit_s6;
	extern Compact s6_floor;
	extern uint16 rs_foster_to_6[];
	extern uint16 use_linc_anim[];
	extern Compact stairs6;
	extern uint16 rs_foster_6_3[];
	extern Compact left_exit_s6;
	extern uint16 s7_pal[];
	extern uint16 rs_foster_7_6[];
	extern ExtCompact skorl_guard_ext;
	extern Compact skorl_guard;
	extern Compact s8_floor;
	extern Compact factory_entry;
	extern uint16 s7_lift_close[];
	extern uint16 linc_table[];
	extern Compact linc_s7;
	extern Compact lift7_light;
	extern uint16 cable_cut_seq[];
	extern uint16 rs_foster_0_5[];
	extern uint16 lamb_talk_right[];
	extern void *data_2[];
	extern Compact sc65_exit_48;
	extern uint16 sc65_floor_table[];
	extern Compact sc65_floor;
	extern uint16 reset_48_65[];
	extern uint16 sc65_chip_list[];
	extern Compact sc65_exit_66;
	extern uint16 sc65_mouse_list[];
	extern uint16 sc65_fast_list[];
	extern Compact sc65_poster2;
	extern Compact sc65_poster1;
	extern Compact sc65_sign;
	extern uint16 sc65_logic_list[];
	extern uint16 sc65_palette[];
	extern uint16 sc66_hi_beam_an1[];
	extern uint16 sc66_door_close[];
	extern uint16 sc75_dead_tlk[];
	extern Compact sc66_rock3;
	extern Compact sc66_lo_beam;
	extern uint16 sc66_stones_anim[];
	extern uint16 walter_conv[];
	extern uint16 sc66_logic_list[];
	extern Compact sc66_stones;
	extern Compact sc66_rock1;
	extern uint16 sc81_ken_talk1[];
	extern Compact sc66_rock2;
	extern uint16 sc66_hi_beam_an2[];
	extern uint16 stuck_talk[];
	extern uint16 sc66_chip_list[];
	extern uint16 medi_talk_up[];
	extern uint16 sc82_ken_sat_tlk[];
	extern uint16 sc81_ken_talk2[];
	extern uint16 android_babble[];
	extern uint16 sc66_rock2_anim[];
	extern uint16 sc82_jobs_talk[];
	extern uint16 ken_talk_left[];
	extern uint16 sc75_freeze_tlk[];
	extern uint16 fost_pipe_talk[];
	extern uint16 ken_talk_up[];
	extern uint16 sc66_mouse_list[];
	extern Compact sc66_hi_beam;
	extern uint16 gall_talk_up[];
	extern uint16 walter_talk_up[];
	extern uint16 medi_talk_right[];
	extern uint16 sc66_rock3_anim[];
	extern uint16 gall_talk_left[];
	extern uint16 medi_talk_down[];
	extern uint16 sc66_lo_beam_anm[];
	extern uint16 sc81_dad_tlk[];
	extern uint16 reset_66[];
	extern uint16 sc66_fos_crushed[];
	extern uint16 fost_conv_left[];
	extern uint16 sc81_fos_sat_tlk[];
	extern uint16 walter_talk_dwn[];
	extern uint16 sc66_fos_walk_in[];
	extern uint16 medi_talk_left[];
	extern uint16 ken_talk_down[];
	extern uint16 sc81_dad_tlk2[];
	extern uint16 ken_talk_right[];
	extern uint16 walter_talk_lft[];
	extern uint16 sc81_ken_sat_tlk[];
	extern uint16 sc82_jobs_talk2[];
	extern Compact sc66_hole;
	extern uint16 sc66_rock1_anim[];
	extern uint16 sc66_fast_list[];
	extern uint16 sc66_palette[];
	extern Compact sc66_door;
	extern void *data_5[];
	extern uint16 sc67_logic_list[];
	extern Compact sc67_vein;
	extern uint16 sc67_mouse_list[];
	extern uint16 sc67_rub_head[];
	extern uint16 sc67_try_stick[];
	extern uint16 sc67_plast_hit[];
	extern Compact sc67_door;
	extern Compact sc67_mend;
	extern uint16 sc67_mending[];
	extern Compact sc67_plaster;
	extern uint16 sc67_door_open[];
	extern uint16 sc67_dustoff[];
	extern Compact sc67_rock;
	extern Compact sc67_crowbar;
	extern uint16 sc67_puss_leak[];
	extern uint16 sc67_pulse3_anim[];
	extern uint16 sc67_plast_fall[];
	extern Compact sc67_pulse4;
	extern uint16 sc67_brick_fall[];
	extern uint16 sc67_bar_fall[];
	extern uint16 sc67_brick_hit[];
	extern uint16 sc67_pick_plast[];
	extern uint16 sc67_crawl[];
	extern uint16 sc67_medifix[];
	extern uint16 sc67_pulse1_anim[];
	extern uint16 sc67_pulse2_anim[];
	extern uint16 sc67_stick_in[];
	extern Compact sc67_pulse1;
	extern uint16 sc67_rpocket[];
	extern Compact sc67_brickwork;
	extern uint16 sc67_getbrick[];
	extern uint16 sc67_lpocket[];
	extern uint16 sc67_pull_out[];
	extern uint16 sc67_palette[];
	extern uint16 sc67_fast_list[];
	extern uint16 sc67_door_close[];
	extern uint16 sc67_rock_anim[];
	extern Compact sc67_pulse2;
	extern Compact sc67_brick;
	extern uint16 sc67_floor_table[];
	extern uint16 sc67_pick_brick[];
	extern uint16 reset_66_67[];
	extern Compact sc67_pulse3;
	extern Compact sc67_floor;
	extern uint16 sc67_pulse4_anim[];
	extern uint16 sc67_chip_list[];
	extern uint16 reset_68_67[];
	extern Compact sc67_clot;
	extern Compact sc68_pulse5;
	extern uint16 sc68_chip_list[];
	extern uint16 reset_69_68[];
	extern Compact sc68_pulse1;
	extern Compact sc68_door;
	extern Compact sc68_exit;
	extern uint16 sc68_logic_list[];
	extern uint16 sc68_palette[];
	extern Compact sc68_pulse3;
	extern uint16 sc68_pulse5_anim[];
	extern uint16 sc68_ascend[];
	extern uint16 sc68_pulse3_anim[];
	extern uint16 sc68_pulse2_anim[];
	extern Compact sc68_pulse4;
	extern uint16 sc68_pulse6_anim[];
	extern Compact sc68_sensor;
	extern uint16 sc68_pulse1_anim[];
	extern uint16 sc68_pulse4_anim[];
	extern Compact sc68_pulse2;
	extern uint16 sc68_descend[];
	extern uint16 reset_70_68[];
	extern uint16 sc68_sensor_anim[];
	extern uint16 sc68_door_close[];
	extern uint16 sc68_floor_table[];
	extern Compact sc68_pulse6;
	extern Compact sc68_grill;
	extern Compact sc68_stairs;
	extern uint16 sc68_fast_list[];
	extern uint16 reset_67_68[];
	extern uint16 sc68_mouse_list[];
	extern Compact sc68_floor;
	extern uint16 sc68_joey_list[];
	extern uint16 sc69_logic_list[];
	extern uint16 sc69_pulse5_anim[];
	extern uint16 sc69_chip_list[];
	extern uint16 sc69_palette[];
	extern uint16 reset_71_69[];
	extern uint16 sc69_mouse_list[];
	extern Compact sc69_pulse2;
	extern uint16 sc69_floor_table[];
	extern Compact sc69_pulse6;
	extern uint16 sc69_joey_list[];
	extern Compact sc69_exit;
	extern uint16 sc69_fast_list[];
	extern Compact sc69_door;
	extern Compact sc69_pulse3;
	extern Compact sc69_pulse5;
	extern uint16 sc69_pulse6_anim[];
	extern Compact sc69_pulse4;
	extern Compact sc69_pulse1;
	extern uint16 sc69_pulse4_anim[];
	extern Compact sc69_grill;
	extern uint16 sc69_pulse1_anim[];
	extern uint16 sc69_pulse3_anim[];
	extern uint16 reset_68_69[];
	extern uint16 sc69_pulse2_anim[];
	extern Compact sc69_floor;
	extern Compact sc70_bar;
	extern uint16 sc70_pull_bar[];
	extern uint16 sc70_step_down[];
	extern uint16 sc70_palette[];
	extern uint16 sc70_floor_table[];
	extern uint16 sc70_enter_anim[];
	extern uint16 sc70_step_up[];
	extern Compact sc70_floor;
	extern uint16 reset_68_70[];
	extern uint16 sc70_exit_anim[];
	extern uint16 sc70_fast_list[];
	extern uint16 sc70_logic_list[];
	extern ExtCompact sc70_iris_ext;
	extern Compact sc70_iris;
	extern uint16 sc70_pit_table[];
	extern Compact sc70_door;
	extern Compact sc70_pit;
	extern uint16 sc70_chip_list[];
	extern uint16 sc70_bar_anim[];
	extern Compact sc70_control;
	extern uint16 sc70_pit_anim[];
	extern Compact sc70_grill;
	extern uint16 sc70_consol_anim[];
	extern uint16 sc70_mouse_list[];
	extern uint16 medi_d_to_u[];
	extern uint16 sc71_use_board[];
	extern Compact sc71_door72;
	extern uint16 sc71_medi_charge[];
	extern uint16 medi_up[];
	extern uint16 medi_down[];
	extern uint16 medi_left[];
	extern uint16 medi_right[];
	extern uint16 medi_st_up[];
	extern uint16 medi_st_down[];
	extern uint16 medi_st_left[];
	extern uint16 medi_st_right[];
	extern uint16 medi_u_to_d[];
	extern uint16 medi_u_to_l[];
	extern uint16 medi_u_to_r[];
	extern uint16 medi_d_to_l[];
	extern uint16 medi_d_to_r[];
	extern uint16 medi_l_to_u[];
	extern uint16 medi_l_to_d[];
	extern uint16 medi_l_to_r[];
	extern uint16 medi_r_to_u[];
	extern uint16 medi_r_to_d[];
	extern uint16 medi_r_to_l[];
	extern ExtCompact medi_ext;
	extern Compact medi;
	extern uint16 sc71_mouse_list[];
	extern uint16 sc71_light1_anim[];
	extern uint16 sc71_logic_list[];
	extern uint16 reset_69_71[];
	extern uint16 sc71_chip_list[];
	extern uint16 sc710_chip_list[];
	extern uint16 reset_72_71[];
	extern uint16 sc71_medi_get_up[];
	extern Compact sc71_chlite;
	extern Compact sc71_controls;
	extern uint16 sc71_panel_anim[];
	extern Compact sc71_panel2;
	extern uint16 sc71_panel2_anim[];
	extern uint16 sc71_joey_list[];
	extern Compact sc71_light1;
	extern uint16 sc71_palette[];
	extern uint16 sc71_fast_list[];
	extern uint16 sc71_mon_anim[];
	extern uint16 sc71_floor_table[];
	extern Compact sc71_floor;
	extern Compact sc71_door69;
	extern Compact sc71_fake_floor;
	extern Compact sc71_medi_slot;
	extern Compact sc71_monitor;
	extern uint16 sc71_chlite_anim[];
	extern Compact sc71_locked_door;
	extern Compact sc71_recharger;
	extern uint16 sc71_light2_anim[];
	extern uint16 wit_st_right[];
	extern uint16 sc72_comp_flash[];
	extern Compact sc72_rot_light;
	extern uint16 sc72_fast_list[];
	extern uint16 sc72_spill_anim[];
	extern uint16 wit_d_to_u[];
	extern Compact sc72_chamber2;
	extern uint16 wit_l_to_r[];
	extern uint16 sc72_joey_tap[];
	extern uint16 sc72_comp2_flash[];
	extern Compact sc72_tank;
	extern uint16 wit_r_to_d[];
	extern uint16 sc72_floor_table[];
	extern Compact sc72_floor;
	extern uint16 sc72_drip_anim[];
	extern uint16 wit_u_to_d[];
	extern Compact sc72_cham2_light;
	extern Compact sc72_computer2;
	extern uint16 sc72_walter_die[];
	extern uint16 wit_r_to_l[];
	extern uint16 wit_up[];
	extern uint16 sc72_rotating[];
	extern uint16 sc72_walter_kill[];
	extern Compact sc72_exit;
	extern uint16 wit_l_to_d[];
	extern uint16 sc72_cham3_anim[];
	extern uint16 sc72_chip_list[];
	extern uint16 sc72_foster_die[];
	extern uint16 sc72_cham1_anim[];
	extern uint16 sc72_cham2_anim[];
	extern uint16 reset_71_72[];
	extern uint16 wit_st_left[];
	extern Compact sc72_cham1_light;
	extern uint16 sc72_palette[];
	extern uint16 sc72_joey_list[];
	extern uint16 sc72_cham2_flash[];
	extern uint16 wit_st_down[];
	extern uint16 sc72_mouse_list[];
	extern Compact sc72_fake_floor;
	extern uint16 wit_st_up[];
	extern Compact sc72_tap;
	extern uint16 wit_l_to_t[];
	extern uint16 wit_st_talk[];
	extern uint16 wit_d_to_l[];
	extern Compact sc72_spill;
	extern Compact sc72_computer;
	extern uint16 wit_l_to_u[];
	extern Compact sc72_door;
	extern uint16 wit_u_to_l[];
	extern uint16 sc72_cham1_flash[];
	extern uint16 wit_d_to_r[];
	extern uint16 wit_left[];
	extern uint16 sc72_tank_anim[];
	extern uint16 wit_right[];
	extern uint16 wit_t_to_u[];
	extern uint16 wit_u_to_t[];
	extern Compact sc72_chamber3;
	extern uint16 wit_down[];
	extern uint16 wit_u_to_r[];
	extern uint16 wit_r_to_u[];
	extern uint16 wit_t_to_l[];
	extern ExtCompact witness_ext;
	extern Compact witness;
	extern uint16 sc72_logic_list[];
	extern uint16 reset_73_72[];
	extern uint16 sc720_chip_list[];
	extern Compact sc72_grill;
	extern Compact sc72_chamber1;
	extern uint16 gal_u_to_l[];
	extern Compact sc73_exit;
	extern uint16 sc73_cham5_flash[];
	extern uint16 sc73_cham5_anim[];
	extern uint16 gal_up[];
	extern uint16 gal_down[];
	extern uint16 gal_left[];
	extern uint16 gal_right[];
	extern uint16 gal_st_up[];
	extern uint16 gal_st_down[];
	extern uint16 gal_st_left[];
	extern uint16 gal_st_right[];
	extern uint16 gal_u_to_d[];
	extern uint16 gal_u_to_r[];
	extern uint16 gal_d_to_u[];
	extern uint16 gal_d_to_l[];
	extern uint16 gal_d_to_r[];
	extern uint16 gal_l_to_u[];
	extern uint16 gal_l_to_d[];
	extern uint16 gal_l_to_r[];
	extern uint16 gal_r_to_u[];
	extern uint16 gal_r_to_d[];
	extern uint16 gal_r_to_l[];
	extern ExtCompact gallagher_ext;
	extern Compact gallagher;
	extern uint16 sc73_joey_fight1[];
	extern uint16 sc73_gall_fight2[];
	extern uint16 reset_72_73[];
	extern uint16 sc73_joey_fight2[];
	extern uint16 sc73_floor_table[];
	extern Compact sc73_floor;
	extern uint16 sc73_bits_anim[];
	extern uint16 sc73_gall_fight1[];
	extern Compact sc73_door;
	extern uint16 sc73_cham4_anim[];
	extern Compact sc73_bits;
	extern Compact sc73_locked_door;
	extern uint16 sc73_mouse_list[];
	extern Compact sc73_sensor;
	extern Compact sc73_cham5_light;
	extern uint16 sc73_joey_lunge[];
	extern uint16 sc73_get_board[];
	extern uint16 sc73_chip_list[];
	extern Compact sc73_spray;
	extern uint16 reset_74_73[];
	extern Compact sc73_bits2;
	extern uint16 sc73_sensor_anim[];
	extern uint16 sc73_fast_list[];
	extern uint16 sc73_joey_list[];
	extern uint16 sc73_spray_anim[];
	extern Compact sc73_chamber4;
	extern Compact sc73_chamber3;
	extern uint16 sc73_palette[];
	extern Compact sc73_chamber5;
	extern uint16 sc73_cham4_flash[];
	extern uint16 sc73_bits2_anim[];
	extern uint16 sc73_logic_list[];
	extern uint16 reset_75_73[];
	extern uint16 sc73_cham3_anim[];
	extern uint16 sc73_search[];
	extern Compact sc73_big_door;
	extern Compact sc73_cham4_light;
	extern Compact sc74_monitor3;
	extern Compact sc74_pod;
	extern Compact sc74_terminal;
	extern uint16 sc74_int_table[];
	extern Compact sc74_interface;
	extern uint16 sc74_mon4_anim[];
	extern uint16 sc74_rtv_anim[];
	extern uint16 sc74_pod_down[];
	extern uint16 sc74_lights_anim[];
	extern uint16 sc74_pod_up[];
	extern Compact sc74_int_slot;
	extern uint16 sc74_mouse_list[];
	extern uint16 sc74_chip_list[];
	extern Compact sc74_monitor2;
	extern uint16 sc74_floor_table[];
	extern Compact sc74_floor;
	extern uint16 reset_73_74[];
	extern uint16 sc74_ltv_anim[];
	extern Compact sc74_left_tv;
	extern uint16 sc74_usecard[];
	extern uint16 sc74_fost_sit[];
	extern Compact sc74_door;
	extern Compact sc74_monitor4;
	extern uint16 sc74_mon3_anim[];
	extern uint16 sc74_get_up[];
	extern Compact sc74_monitor1;
	extern uint16 sc74_mon1_anim[];
	extern uint16 sc74_palette[];
	extern uint16 sc74_fast_list[];
	extern uint16 sc74_usecard2[];
	extern uint16 sc74_rpocket[];
	extern uint16 reset_linc_74[];
	extern Compact sc74_right_tv;
	extern uint16 sc74_logic_list[];
	extern uint16 sc74_mon2_anim[];
	extern Compact sc74_lights;
	extern uint16 sc74_slot_flash[];
	extern uint16 sc75_floor_table[];
	extern uint16 sc75_usecard[];
	extern Compact sc75_console;
	extern uint16 sc75_get_tongs[];
	extern uint16 sc75_joey_list[];
	extern uint16 sc75_freeze_ded2[];
	extern uint16 sc75_hand_tank[];
	extern Compact sc75_door;
	extern uint16 sc75_light2_anim[];
	extern Compact sc75_light1;
	extern uint16 rs_tongs_dead[];
	extern uint16 sc75_tank_anim[];
	extern uint16 reset_73_75[];
	extern uint16 sc75_light1_anim[];
	extern uint16 sc75_fast_list[];
	extern Compact sc75_floor;
	extern uint16 rs_tongs_empty[];
	extern Compact sc75_big_door;
	extern uint16 sc75_mouse_list[];
	extern Compact sc75_live_tank;
	extern uint16 sc75_freeze_it[];
	extern Compact sc75_tongs;
	extern uint16 sc75_chip_list[];
	extern uint16 sc75_nitro_anim[];
	extern uint16 rs_tongs_frozen[];
	extern uint16 sc75_crash_anim[];
	extern Compact sc75_light2;
	extern uint16 sc75_mon_anim[];
	extern uint16 sc75_freeze_it2[];
	extern Compact sc75_nitro_tank;
	extern uint16 sc75_palette[];
	extern uint16 rs_tongs_live[];
	extern uint16 reset_76_75[];
	extern uint16 sc75_logic_list[];
	extern uint16 rs_tongs_timer[];
	extern uint16 sc75_freeze_ded[];
	extern uint16 sc75_rpocket[];
	extern uint16 sc75_get_tiss[];
	extern uint16 ken_u_to_r[];
	extern uint16 sc76_logic_list[];
	extern uint16 sc76_hatch_2[];
	extern uint16 sc76_cab2_close[];
	extern uint16 reset_75_76[];
	extern uint16 sc76_chip_list[];
	extern uint16 ken_right[];
	extern uint16 ken_st_up[];
	extern uint16 ken_d_to_l[];
	extern uint16 ken_up[];
	extern uint16 ken_down[];
	extern uint16 ken_left[];
	extern uint16 ken_st_down[];
	extern uint16 ken_st_left[];
	extern uint16 ken_st_right[];
	extern uint16 ken_u_to_d[];
	extern uint16 ken_u_to_l[];
	extern uint16 ken_d_to_u[];
	extern uint16 ken_d_to_r[];
	extern uint16 ken_l_to_u[];
	extern uint16 ken_l_to_d[];
	extern uint16 ken_l_to_r[];
	extern uint16 ken_r_to_u[];
	extern uint16 ken_r_to_d[];
	extern uint16 ken_r_to_l[];
	extern ExtCompact ken_ext;
	extern Compact ken;
	extern uint16 sc76_floor_table[];
	extern Compact sc76_floor;
	extern Compact sc76_light3;
	extern Compact sc76_light9;
	extern uint16 sc76_light1_anim[];
	extern uint16 sc76_light2_anim[];
	extern Compact sc76_light6;
	extern Compact sc76_board_3;
	extern uint16 sc76_shut_cab[];
	extern uint16 sc76_light3_anim[];
	extern Compact sc76_light1;
	extern uint16 sc76_low_get[];
	extern uint16 sc76_fostfall[];
	extern Compact sc76_door77;
	extern Compact sc76_board_1;
	extern Compact sc76_light8;
	extern Compact sc76_android_1;
	extern uint16 sc76_cab1_open[];
	extern uint16 sc76_hatch_1[];
	extern Compact sc76_console_2;
	extern ExtCompact sc76_android_3_ext;
	extern Compact sc76_android_3;
	extern Compact sc76_console_1;
	extern uint16 sc76_fast_list[];
	extern ExtCompact sc76_android_2_ext;
	extern Compact sc76_android_2;
	extern uint16 sc76_cab1_close[];
	extern Compact sc76_light5;
	extern Compact sc76_board_2;
	extern uint16 sc76_light9_anim[];
	extern uint16 sc76_cab3_open[];
	extern Compact sc76_light7;
	extern Compact sc76_light4;
	extern uint16 sc76_mouse_list[];
	extern uint16 sc76_joey_list[];
	extern uint16 reset_77_76[];
	extern uint16 sc76_light5_anim[];
	extern uint16 sc76_light4_anim[];
	extern uint16 sc76_hatch_3[];
	extern Compact sc76_cabinet_1;
	extern uint16 sc76_punch[];
	extern uint16 sc76_cab2_open[];
	extern uint16 sc76_light7_anim[];
	extern Compact sc76_cabinet_3;
	extern Compact sc76_console_3;
	extern uint16 sc76_open_cab[];
	extern uint16 sc76_palette[];
	extern Compact sc76_light2;
	extern uint16 sc76_light8_anim[];
	extern uint16 sc76_cab3_close[];
	extern Compact sc76_cabinet_2;
	extern uint16 sc76_light6_anim[];
	extern Compact sc76_door75;
	extern uint16 sc77_fpushl_2[];
	extern uint16 sc77_palette[];
	extern Compact sc77_big_door;
	extern uint16 sc77_fpushl_1[];
	extern uint16 sc77_fast_list[];
	extern uint16 sc77_logic_list[];
	extern uint16 sc77_door_open[];
	extern uint16 sc77_chip_list[];
	extern uint16 reset_78_77[];
	extern uint16 sc77_stretch[];
	extern uint16 sc77_joey_list[];
	extern uint16 sc77_mouse_list[];
	extern uint16 reset_76_77[];
	extern uint16 sc77_fpushr_2[];
	extern uint16 sc77_floor_table[];
	extern uint16 sc77_kpushr_2[];
	extern Compact sc77_tank_1;
	extern uint16 sc77_fpushr_1[];
	extern Compact sc77_tank_2;
	extern Compact sc77_floor;
	extern Compact sc77_hand_2;
	extern Compact sc77_hand_1;
	extern uint16 sc77_kpushr_1[];
	extern Compact sc77_door76;
	extern uint16 sc78_ledge_table[];
	extern Compact sc78_ledge;
	extern Compact sc78_big_door;
	extern uint16 sc78_climb_up[];
	extern uint16 sc78_logic_list[];
	extern uint16 reset_79_78[];
	extern uint16 sc78_mouse_list[];
	extern Compact sc78_support;
	extern uint16 sc781_palette[];
	extern uint16 reset_77_78[];
	extern uint16 sc78_pipe_table[];
	extern uint16 sc78_chip_list[];
	extern Compact sc78_exit;
	extern uint16 sc78_jump_down[];
	extern Compact sc78_pipe;
	extern uint16 sc78_palette[];
	extern uint16 sc78_fast_list[];
	extern uint16 sc791_palette[];
	extern uint16 sc79_chip_list[];
	extern uint16 sc79_climb_up[];
	extern Compact sc79_exit;
	extern Compact sc79_rope;
	extern Compact sc79_support;
	extern uint16 sc79_palette[];
	extern uint16 sc79_climb_down[];
	extern uint16 sc79_crouch_down[];
	extern uint16 sc79_pipe_table[];
	extern uint16 reset_78_79[];
	extern uint16 sc79_crouch_up[];
	extern uint16 sc79_rope_anim[];
	extern Compact sc79_knot;
	extern uint16 sc79_fast_list[];
	extern uint16 reset_80_79[];
	extern Compact sc79_ladder;
	extern uint16 sc79_toss_rope[];
	extern uint16 sc79_logic_list[];
	extern uint16 sc79_mouse_list[];
	extern uint16 sc79_tie_rope[];
	extern Compact sc79_pipe;
	extern Compact sc80_bubble10;
	extern uint16 sc80_logic_list[];
	extern uint16 sc802_palette[];
	extern Compact sc80_bubble1;
	extern uint16 sc801_palette[];
	extern uint16 sc803_palette[];
	extern uint16 sc80_chip_list[];
	extern Compact sc80_bubble2;
	extern uint16 sc80_pipe_shrug[];
	extern uint16 sc80_climb_down[];
	extern uint16 sc80_exit_open[];
	extern uint16 sc80_fast_list[];
	extern uint16 sc80_palette[];
	extern Compact sc80_bubble11;
	extern uint16 sc80_clamber[];
	extern uint16 sc80_mouse_list[];
	extern uint16 sc80_climb_up[];
	extern Compact sc80_exit;
	extern Compact sc80_orifice;
	extern Compact sc80_sample;
	extern uint16 sc80_get_rope[];
	extern uint16 sc80_bub1_anim[];
	extern uint16 sc80_swing[];
	extern Compact sc80_spout;
	extern Compact sc80_bubble4;
	extern uint16 sc80_goo_anim[];
	extern Compact sc80_bubble7;
	extern Compact sc80_bubble9;
	extern uint16 sc80_sample_fall[];
	extern Compact sc80_rope;
	extern Compact sc80_bubble3;
	extern Compact sc80_bubble8;
	extern uint16 sc80_drop[];
	extern uint16 reset_79_80[];
	extern Compact sc80_ladder;
	extern uint16 sc804_palette[];
	extern Compact sc80_bubble12;
	extern Compact sc80_bubble6;
	extern Compact sc80_bubble5;
	extern Compact sc80_goo;
	extern Compact sc81_big_tent3;
	extern uint16 sc81_fos_squirm[];
	extern uint16 sc81_tentwig1[];
	extern uint16 sc81_ken_helm_dn[];
	extern uint16 sc81_tentwig2[];
	extern uint16 sc81_fast_list[];
	extern Compact sc81_tent5;
	extern Compact sc81_helmet;
	extern uint16 sc81_ken_sit[];
	extern uint16 sc81_palette[];
	extern uint16 sc81_dad_helm_up[];
	extern Compact sc81_tent2;
	extern uint16 sc83_draw_list[];
	extern uint16 sc81_tentwig5[];
	extern Compact sc81_chair;
	extern uint16 sc81_chip_list[];
	extern uint16 sc81_tentwig6[];
	extern Compact sc81_ken_sat;
	extern uint16 sc81_tentdrop2[];
	extern uint16 sc81_ken_walk2[];
	extern Compact sc81_foster_sat;
	extern uint16 sc81_tentdrop1[];
	extern Compact sc81_father_sat;
	extern uint16 sc81_tentwig4[];
	extern uint16 sc81_ken_walk1[];
	extern uint16 reset_dad_spec[];
	extern uint16 sc81_mouse_list[];
	extern uint16 sc81_dad_breath1[];
	extern uint16 sc81_fos_helm_dn[];
	extern uint16 sc81_dad_fall2[];
	extern Compact sc81_door;
	extern Compact sc81_big_tent1;
	extern Compact sc81_tent1;
	extern Compact sc81_tent4;
	extern ExtCompact sc81_father_ext;
	extern Compact sc81_father;
	extern uint16 sc81_door_close[];
	extern uint16 sc81_dad_breath2[];
	extern uint16 sc81_tentwig3[];
	extern uint16 sc81_father_die[];
	extern uint16 reset_ken_81[];
	extern uint16 reset_80_81[];
	extern uint16 sc81_dad_fall1[];
	extern uint16 sc81_ken_jump_in[];
	extern uint16 sc81_logic_list[];
	extern Compact sc81_big_tent2;
	extern Compact sc81_tent3;
	extern uint16 sc81_tentdrop3[];
	extern Compact sc81_tent6;
	extern uint16 sc83_palette[];
	extern uint16 reset_foster_spec[];
	extern uint16 sc81_foster_sit[];
	extern uint16 sc82_push_button[];
	extern ExtCompact sc82_jobsworth_ext;
	extern Compact sc82_jobsworth;
	extern uint16 reset_foster_82[];
	extern uint16 sc82_jobs_turn[];
	extern uint16 sc82_jobs_take[];
	extern uint16 sc82_logic_list[];
	extern uint16 sc82_fast_list[];
	extern uint16 sc82_mouse_list[];
	extern uint16 reset_ken_82[];
	extern uint16 sc82_chip_list[];
	extern uint16 sc82_palette[];
	extern uint16 sc82_foster_give[];
	extern uint16 sc82_jobs_return[];
	extern uint16 sc85_palette[];
	extern uint16 sc85_mouse_list[];
	extern uint16 sc85_chip_list[];
	extern uint16 sc85_fast_list[];
	extern uint16 sc85_logic_list[];
	extern Compact door_r90f;
	extern Compact door_r90;
	extern uint16 sc90_floor_table[];
	extern Compact sc90_floor;
	extern uint16 sc90_smfloor_table[];
	extern uint16 eye90_zap_anim[];
	extern uint16 door_l90_anim[];
	extern Compact door_l90;
	extern uint16 get_join[];
	extern uint16 sc90_mouse[];
	extern uint16 door_l90f_anim[];
	extern uint16 sc90_logic[];
	extern uint16 eye_90_table[];
	extern Compact eyeball_90;
	extern Compact sc90_smfloor;
	extern Compact join_object;
	extern Compact door_l90f;
	extern Compact oscillator;
	extern uint16 rs_foster_90_91[];
	extern uint16 rs_foster_90_94[];
	extern uint16 door_r90_anim[];
	extern uint16 door_r90f_anim[];
	extern uint16 get_oscill[];
	extern uint16 blind_eye[];
	extern uint16 see_eye[];
	extern uint16 pal90[];
	extern uint16 pal90a[];
	extern uint16 pal90b[];
	extern uint16 chip_list_sc90[];
	extern uint16 get_eye[];
	extern uint16 fost_die90[];
	extern void *data_6[];
	extern Compact decomp_obj;
	extern Compact door_r91;
	extern uint16 sc91_mouse[];
	extern uint16 get_decomp[];
	extern uint16 eye_91_table[];
	extern Compact door_l91f;
	extern uint16 door_r91f_anim[];
	extern Compact report_book;
	extern uint16 get_report[];
	extern uint16 chip_list_sc91[];
	extern uint16 sc91_floor_table[];
	extern Compact sc91_floor;
	extern Compact bag_91;
	extern uint16 door_r91_anim[];
	extern uint16 rs_foster_91_95[];
	extern uint16 door_l91_anim[];
	extern uint16 pal91[];
	extern uint16 get_decrypt[];
	extern Compact door_t91;
	extern Compact door_l91;
	extern uint16 rs_foster_91_92[];
	extern uint16 fost_die91[];
	extern uint16 rs_foster_91_90[];
	extern uint16 sc91_logic[];
	extern Compact eyeball_91;
	extern uint16 fast_list_sc91[];
	extern Compact door_t91r;
	extern uint16 door_l91f_anim[];
	extern Compact decrypt_obj;
	extern uint16 door_t91_anim[];
	extern uint16 door_t91r_anim[];
	extern uint16 eye91_zap_anim[];
	extern Compact door_r91f;
	extern Compact bridge_e;
	extern Compact door_l92;
	extern uint16 slab8_table[];
	extern Compact slab8;
	extern uint16 slab3_table[];
	extern uint16 slab2_table[];
	extern uint16 slab4_table[];
	extern Compact slab4;
	extern uint16 door_l92_anim[];
	extern uint16 door_r92_anim[];
	extern uint16 slab6_table[];
	extern Compact slab6;
	extern Compact door_r92;
	extern Compact bridge_h;
	extern Compact bridge_f;
	extern uint16 slab7_table[];
	extern Compact bridge_a;
	extern uint16 door_r92r_anim[];
	extern Compact bridge_g;
	extern Compact door_l92f;
	extern Compact bridge_b;
	extern uint16 slab9_table[];
	extern uint16 slab1_table[];
	extern Compact slab1;
	extern Compact red_circle;
	extern Compact slab2;
	extern uint16 sc92_logic[];
	extern uint16 chip_list_sc92[];
	extern uint16 pal92[];
	extern uint16 fast_list_sc92[];
	extern uint16 door_l92f_anim[];
	extern Compact slab9;
	extern Compact door_r92r;
	extern uint16 slab5_table[];
	extern Compact slab5;
	extern Compact slab7;
	extern uint16 sc92_mouse[];
	extern uint16 rs_foster_92_93[];
	extern Compact green_circle;
	extern uint16 rs_foster_92_91[];
	extern Compact bridge_c;
	extern Compact bridge_d;
	extern Compact slab3;
	extern uint16 get_adjust[];
	extern Compact door_l93;
	extern uint16 sc93_mouse[];
	extern Compact adjust_book;
	extern uint16 sc93_floor_table[];
	extern uint16 sc93_logic[];
	extern Compact door_l93f;
	extern uint16 rs_foster_93_92[];
	extern Compact sc93_floor;
	extern uint16 chip_list_sc93[];
	extern uint16 door_l93f_anim[];
	extern uint16 get_persona[];
	extern uint16 fast_list_sc93[];
	extern uint16 door_l93_anim[];
	extern Compact persona;
	extern uint16 pal93[];
	extern uint16 door_l94_anim[];
	extern uint16 holo1_a_anim[];
	extern uint16 sc94_floor_table[];
	extern Compact sc94_floor;
	extern uint16 fast_list_sc94[];
	extern uint16 holo3_anim[];
	extern Compact door_r94;
	extern uint16 sc94_logic[];
	extern uint16 door_r94r_anim[];
	extern Compact door_r94r;
	extern uint16 rs_foster_94_90[];
	extern Compact door_l94r;
	extern uint16 rs_foster_94_95[];
	extern uint16 door_r94_anim[];
	extern uint16 chip_list_sc94[];
	extern ExtCompact hologram_b_ext;
	extern Compact hologram_b;
	extern uint16 holo1_b_anim[];
	extern Compact door_l94;
	extern uint16 door_l94r_anim[];
	extern uint16 sc94_mouse[];
	extern uint16 anita_holo_talk[];
	extern Compact hologram_pad;
	extern uint16 pal94[];
	extern Compact hologram_a;
	extern uint16 fast_list_sc95[];
	extern uint16 weight_anim[];
	extern uint16 sc95_floor_table[];
	extern uint16 door_r95_anim[];
	extern uint16 rs_foster_95_96[];
	extern Compact door_r95f;
	extern uint16 pal95[];
	extern uint16 chip_list_sc95[];
	extern uint16 door_l95f_anim[];
	extern uint16 sc95_logic[];
	extern Compact weight;
	extern Compact guardian;
	extern uint16 rs_foster_95_91[];
	extern uint16 sc95_mouse[];
	extern Compact door_r95;
	extern uint16 rs_foster_95_94[];
	extern Compact door_t95;
	extern uint16 door_r95f_anim[];
	extern Compact door_l95;
	extern Compact door_l95f;
	extern uint16 door_t95_anim[];
	extern uint16 door_t95r_anim[];
	extern uint16 guardian_down[];
	extern Compact sc95_floor;
	extern uint16 guardian_up[];
	extern Compact door_t95r;
	extern uint16 door_l95_anim[];
	extern uint16 sc96_mouse[];
	extern uint16 door_l96f_anim[];
	extern uint16 sc96_floor_table[];
	extern Compact sc96_floor;
	extern uint16 sc96_logic[];
	extern Compact crystal;
	extern uint16 rs_foster_96_95[];
	extern uint16 crystal_break[];
	extern uint16 pal96[];
	extern Compact door_l96f;
	extern Compact virus;
	extern uint16 crystal_spin[];
	extern uint16 virus_spin[];
	extern Compact door_l96;
	extern uint16 chip_list_sc96[];
	extern uint16 get_virus[];
	extern uint16 door_l96_anim[];
	extern uint16 fast_list_sc96[];
	extern uint16 s9_floor_table[];
	extern Compact fake_floor_9;
	extern uint16 son_work_seq[];
	extern ExtCompact son_ext;
	extern Compact son;
	extern uint16 scandie_seq[];
	extern uint16 lobby_down_seq[];
	extern uint16 s9_mouse[];
	extern uint16 scan_seq[];
	extern uint16 dad_work_seq[];
	extern Compact linc_s9;
	extern uint16 dad_work3_seq[];
	extern ExtCompact dad_ext;
	extern Compact dad;
	extern uint16 dad_work2_seq[];
	extern Compact s9_floor;
	extern Compact left_exit_s9;
	extern uint16 fans_seq[];
	extern Compact fans;
	extern Compact lobby_slot;
	extern Compact scanner;
	extern uint16 card_in_seq[];
	extern uint16 lobby_up_seq[];
	extern Compact lobby_door;
	extern uint16 rs_foster_to_9[];
	extern uint16 rs_foster_10_9[];
	extern uint16 s9_logic[];
	extern uint16 s9_chip_list[];
	extern uint16 s9_pal[];
	extern uint16 window_mouse[];
	extern uint16 logon[];
	extern uint16 note_module[];
	extern uint16 window_logic[];
	extern uint16 crouch_right_b[];
	extern uint16 crouch_down[];
	extern uint16 auth_module[];
	extern Compact window_3;
	extern Compact info_button;
	extern uint16 size_module[];
	extern Compact window_2;
	extern uint16 logoff[];
	extern uint16 enter_top[];
	extern uint16 crouch_right[];
	extern Compact window_1;
	extern uint16 exit_top[];
	extern uint16 shrug[];
	extern uint16 head_module[];
	extern uint16 crouch_right_a[];
	extern uint16 file_module[];
	extern uint16 crouch_left[];
	extern Compact window_4;
	extern uint16 rs_foster_s90[];
	extern Compact playbak_menu;
	extern Compact persona_menu;
	extern Compact info_menu;
	extern Compact decrypt_menu;
	extern uint16 linc_menu_mouse[];
	extern Compact kill_menu;
	extern Compact read_menu;
	extern Compact orders_menu;
	extern Compact report_menu;
	extern Compact virus_menu;
	extern Compact adjust_menu;
	extern Compact charon_menu;
	extern Compact orders2_menu;
	extern Compact report2_menu;
	extern Compact oscill_menu;
	extern Compact join_menu;
	extern Compact green_menu;
	extern uint16 linc_menu_logic[];
	extern Compact adjust2_menu;
	extern Compact red_menu;
	extern Compact open_menu;
	extern Compact decomp_menu;
	extern Compact blind_menu;
	extern Compact blank5;
	extern Compact tape_menu;
	extern Compact right_arrow;
	extern uint16 move_2[];
	extern Compact glass_menu;
	extern Compact lightbulb_menu;
	extern Compact blank3;
	extern Compact wd40_menu;
	extern Compact plaster_menu;
	extern Compact new_cable_menu;
	extern Compact blank8;
	extern Compact joeyb_menu;
	extern uint16 move_menu[];
	extern uint16 *move_list[];
	extern Compact blank6;
	extern Compact shades_menu;
	extern Compact citycard_menu;
	extern Compact blank9;
	extern Compact rope_menu;
	extern Compact left_arrow;
	extern Compact magazine_menu;
	extern Compact gallcard_menu;
	extern Compact dog_food_menu;
	extern Compact blank7;
	extern Compact blank2;
	extern Compact blank11;
	extern Compact anchor_menu;
	extern Compact anita_card_menu;
	extern Compact tongs_menu;
	extern Compact blank4;
	extern Compact crow_bar_menu;
	extern Compact secateurs_menu;
	extern Compact sarnie_menu;
	extern Compact spanner_menu;
	extern Compact blank10;
	extern Compact skey_menu;
	extern Compact blank1;
	extern Compact ticket_menu;
	extern Compact brick_menu;
	extern Compact putty_menu;
	extern Compact menu_bar;
	extern uint16 fradman_up[];
	extern uint16 high_floor_table[];
	extern Compact floor;
	extern uint16 wjoey_d_to_u[];
	extern uint16 wjoey_st_left[];
	extern uint16 ljoey_r_to_d[];
	extern uint16 s2_talk_table[];
	extern Compact r_talk_s2;
	extern uint16 fradman_u_to_d[];
	extern uint16 door_table[];
	extern uint16 mfoster_st_right[];
	extern uint16 bfoster_st_right[];
	extern uint16 seq3_pal[];
	extern uint16 bfoster_u_to_r[];
	extern uint16 foster_l_to_t[];
	extern uint16 s9_fast_list[];
	extern uint16 wjoey_st_up[];
	extern uint16 bfoster_r_to_u[];
	extern uint16 monitor_left[];
	extern uint16 rs_lamb_to_three[];
	extern uint16 std_menu_logic[];
	extern uint16 but_7[];
	extern uint16 ljoey_up[];
	extern uint16 wjoey_r_to_d[];
	extern Compact small_door;
	extern uint16 shrug_seq[];
	extern uint16 foster_up[];
	extern uint16 mfoster_d_to_l[];
	extern uint16 ljoey_down[];
	extern uint16 rs_blanks_linc[];
	extern uint16 mini_shrug_seq[];
	extern uint16 talk_table[];
	extern uint16 fradman_l_to_d[];
	extern uint16 low_floor_table[];
	extern Compact low_floor;
	extern uint16 bfoster_d_to_u[];
	extern uint16 but_0[];
	extern uint16 but_4[];
	extern uint16 fradman_right[];
	extern uint16 bfoster_st_left[];
	extern uint16 sjoey_up[];
	extern uint16 s10_fast_list[];
	extern uint16 fradman_u_to_l[];
	extern uint16 ljoey_r_to_u[];
	extern uint16 foster_u_to_l[];
	extern uint16 lamb_up[];
	extern uint16 lamb_down[];
	extern uint16 lamb_left[];
	extern uint16 lamb_right[];
	extern uint16 lamb_st_up[];
	extern uint16 lamb_st_down[];
	extern uint16 lamb_st_left[];
	extern uint16 lamb_st_right[];
	extern uint16 lamb_st_talk[];
	extern uint16 lamb_u_to_d[];
	extern uint16 lamb_u_to_l[];
	extern uint16 lamb_u_to_r[];
	extern uint16 lamb_d_to_u[];
	extern uint16 lamb_d_to_l[];
	extern uint16 lamb_d_to_r[];
	extern uint16 lamb_l_to_u[];
	extern uint16 lamb_l_to_d[];
	extern uint16 lamb_l_to_r[];
	extern uint16 lamb_r_to_u[];
	extern uint16 lamb_r_to_d[];
	extern uint16 lamb_r_to_l[];
	extern ExtCompact lamb_ext;
	extern Compact lamb;
	extern uint16 bfoster_left[];
	extern uint16 fast_intro[];
	extern uint16 foster_st_right[];
	extern uint16 monitor_st_up[];
	extern uint16 sjoey_d_to_r[];
	extern uint16 foster_st_down[];
	extern uint16 mfoster_u_to_r[];
	extern uint16 sml_up_mid_get_seq[];
	extern uint16 mfoster_u_to_d[];
	extern uint16 wjoey_u_to_d[];
	extern uint16 chip_intro[];
	extern uint16 fast_list_0[];
	extern uint16 rs_right_arrow[];
	extern uint16 ljoey_st_left[];
	extern uint16 s28_fast_list[];
	extern uint16 monitor_right[];
	extern uint16 wjoey_st_down[];
	extern uint16 r2_floor_table[];
	extern Compact s2_floor;
	extern uint16 fradman_down[];
	extern uint16 foster_u_to_d[];
	extern uint16 ljoey_d_to_r[];
	extern uint16 mfoster_r_to_u[];
	extern uint16 fast_list_sc3[];
	extern uint16 rs_left_arrow[];
	extern uint16 rs_l_arr_linc[];
	extern Compact text_8;
	extern uint16 wjoey_l_to_d[];
	extern uint16 stair_table[];
	extern Compact stairs;
	extern uint16 text_mouse[];
	extern uint16 monitor_d_to_r[];
	extern uint16 ljoey_l_to_d[];
	extern uint16 sjoey_st_right[];
	extern uint16 sjoey_st_down[];
	extern uint16 sjoey_st_left[];
	extern uint16 upstair_table[];
	extern uint16 sjoey_right[];
	extern uint16 ljoey_u_to_r[];
	extern uint16 mfoster_st_up[];
	extern uint16 mfoster_st_down[];
	extern uint16 foster_st_talk[];
	extern uint16 mfoster_l_to_r[];
	extern uint16 bar_table[];
	extern uint16 foster_d_to_l[];
	extern Compact text_1;
	extern uint16 fradman_left[];
	extern uint16 s29_fast_list[];
	extern uint16 r1door_table[];
	extern Compact r1_door;
	extern Compact upstairs;
	extern uint16 ljoey_u_to_d[];
	extern uint16 monitor_u_to_l[];
	extern uint16 fradman_st_right[];
	extern uint16 sml_door_table[];
	extern uint16 bfoster_r_to_l[];
	extern uint16 mfoster_left[];
	extern uint16 wjoey_up[];
	extern uint16 foster_r_to_u[];
	extern uint16 mfoster_d_to_u[];
	extern uint16 but_8[];
	extern uint16 but_5[];
	extern uint16 monitor_l_to_u[];
	extern uint16 mfoster_l_to_u[];
	extern uint16 bfoster_d_to_r[];
	extern uint16 wjoey_down[];
	extern Compact text_10;
	extern uint16 monitor_u_to_d[];
	extern Compact text_5;
	extern uint16 forklift1_cdt[];
	extern uint16 bfoster_up[];
	extern uint16 s11_fast_list[];
	extern uint16 fradman_d_to_u[];
	extern uint16 monitor_r_to_u[];
	extern uint16 bfoster_down[];
	extern uint16 ledge_table[];
	extern uint16 ljoey_d_to_u[];
	extern uint16 foster_left[];
	extern uint16 sjoey_st_up[];
	extern uint16 fradman_l_to_r[];
	extern Compact outside_ledge;
	extern uint16 fradman_st_up[];
	extern uint16 foster_l_to_u[];
	extern uint16 foster_u_to_t[];
	extern uint16 ljoey_d_to_l[];
	extern uint16 ljoey_left[];
	extern uint16 ljoey_right[];
	extern uint16 ljoey_st_up[];
	extern uint16 ljoey_st_down[];
	extern uint16 ljoey_st_right[];
	extern uint16 ljoey_u_to_l[];
	extern uint16 ljoey_l_to_u[];
	extern uint16 ljoey_l_to_r[];
	extern uint16 ljoey_r_to_l[];
	extern uint16 wjoey_left[];
	extern uint16 wjoey_right[];
	extern uint16 wjoey_st_right[];
	extern uint16 wjoey_u_to_l[];
	extern uint16 wjoey_u_to_r[];
	extern uint16 wjoey_d_to_l[];
	extern uint16 wjoey_d_to_r[];
	extern uint16 wjoey_l_to_u[];
	extern uint16 wjoey_l_to_r[];
	extern uint16 wjoey_r_to_u[];
	extern uint16 wjoey_r_to_l[];
	extern uint16 sjoey_down[];
	extern uint16 sjoey_left[];
	extern uint16 sjoey_u_to_d[];
	extern uint16 sjoey_u_to_l[];
	extern uint16 sjoey_u_to_r[];
	extern uint16 sjoey_d_to_u[];
	extern uint16 sjoey_d_to_l[];
	extern uint16 sjoey_l_to_u[];
	extern uint16 sjoey_l_to_d[];
	extern uint16 sjoey_l_to_r[];
	extern uint16 sjoey_r_to_u[];
	extern uint16 sjoey_r_to_d[];
	extern uint16 sjoey_r_to_l[];
	extern ExtCompact joey_ext;
	extern Compact joey;
	extern uint16 baby_logic_list[];
	extern uint16 save_restore_mouse[];
	extern uint16 fradman_r_to_l[];
	extern uint16 foster_right[];
	extern uint16 seq2_pal[];
	extern uint16 seq1_pal[];
	extern uint16 bfoster_r_to_d[];
	extern uint16 low_get_seq[];
	extern uint16 fradman_u_to_r[];
	extern uint16 rs_mega_alive[];
	extern Compact whole_screen;
	extern uint16 bfoster_u_to_l[];
	extern Compact bar;
	extern uint16 foster_st_left[];
	extern uint16 monitor_l_to_r[];
	extern uint16 rs_lamb_start_3[];
	extern uint16 forklift2_cdt[];
	extern Compact talk2;
	extern Compact text_4;
	extern uint16 mfoster_d_to_r[];
	extern Compact door;
	extern uint16 foster_d_to_u[];
	extern uint16 park_table[];
	extern uint16 mfoster_up[];
	extern uint16 mfoster_down[];
	extern uint16 mfoster_right[];
	extern uint16 mfoster_st_left[];
	extern uint16 mfoster_u_to_l[];
	extern uint16 mfoster_l_to_d[];
	extern uint16 mfoster_r_to_d[];
	extern uint16 mfoster_r_to_l[];
	extern uint16 foster_down[];
	extern uint16 foster_st_up[];
	extern uint16 foster_u_to_r[];
	extern uint16 foster_d_to_r[];
	extern uint16 foster_l_to_d[];
	extern uint16 foster_l_to_r[];
	extern uint16 foster_r_to_d[];
	extern uint16 foster_r_to_l[];
	extern uint16 foster_t_to_u[];
	extern uint16 foster_t_to_l[];
	extern uint16 fradman_st_down[];
	extern uint16 fradman_st_left[];
	extern uint16 fradman_st_talk[];
	extern uint16 fradman_d_to_l[];
	extern uint16 fradman_d_to_r[];
	extern uint16 fradman_l_to_u[];
	extern uint16 fradman_r_to_u[];
	extern uint16 fradman_r_to_d[];
	extern uint16 bfoster_right[];
	extern uint16 bfoster_st_up[];
	extern uint16 bfoster_st_down[];
	extern uint16 bfoster_u_to_d[];
	extern uint16 bfoster_d_to_l[];
	extern uint16 bfoster_l_to_u[];
	extern uint16 bfoster_l_to_d[];
	extern uint16 bfoster_l_to_r[];
	extern ExtCompact foster_ext;
	extern Compact foster;
	extern uint16 monitor_up[];
	extern uint16 s0_fast_list[];
	extern uint16 s7_fast_list[];
	extern uint16 monitor_st_talk[];
	extern uint16 fast_list_sc90[];
	extern uint16 but_2[];
	extern uint16 but_3[];
	extern uint16 monitor_st_down[];
	extern uint16 but_9[];
	extern Compact text_11;
	extern Compact joey_park;
	extern Compact coordinate_test;
	extern Compact text_2;
	extern Compact text_3;
	extern Compact text_6;
	extern Compact text_7;
	extern Compact text_9;
	extern uint16 rad_shrug_seq[];
	extern uint16 rs_lamb_start_2[];
	extern uint16 s6_fast_list[];
	extern uint16 swing_list[];
	extern Compact right_exit0;
	extern uint16 rs_blank[];
	extern uint16 monitor_down[];
	extern uint16 monitor_st_left[];
	extern uint16 monitor_st_right[];
	extern uint16 monitor_u_to_r[];
	extern uint16 monitor_d_to_u[];
	extern uint16 monitor_d_to_l[];
	extern uint16 monitor_l_to_d[];
	extern uint16 monitor_r_to_d[];
	extern uint16 monitor_r_to_l[];
	extern ExtCompact monitor_ext;
	extern Compact monitor;
	extern ExtCompact anita_ext;
	extern Compact anita;
	extern uint16 rs_r_arr_linc[];
	extern uint16 s5_fast_list[];
	extern uint16 but_e[];
	extern uint16 but_1[];
	extern uint16 but_6[];
	extern uint16 fast_intro_2[];
	extern uint16 fast_intro_3[];
	extern uint16 retina_scan_cdt[];
	extern Compact forklift_cpt;
	extern void *data_0[];
	extern uint16 babs_auto[];
	extern uint16 burke_auto[];
	extern uint16 dan_auto[];
	extern uint16 foreman_auto[];
	extern uint16 full_ss_auto[];
	extern uint16 gal_auto[];
	extern uint16 jobs_auto[];
	extern uint16 joey_auto[];
	extern uint16 ken_auto[];
	extern uint16 lamb_auto[];
	extern uint16 loader_auto[];
	extern uint16 medi_auto[];
	extern uint16 monitor_auto[];
	extern uint16 radman_auto[];
	extern uint16 shades_auto[];
	extern uint16 spu_auto[];
	extern uint16 ss_auto[];
	extern uint16 wit_auto[];
	extern uint16 minif_auto[];
}

} // End of namespace Sky

#endif
