/* Public domain. */

#include "avlnode.h"
#include "avltree.h"

unsigned int avltree_search (register avltree const *t, register unsigned int k)
{
  register unsigned int r = avltree_root(t) ;
  register avlnode const *s = t->x.x.s ;
  while (r)
  {
    register int h = (*t->cmp)(k, s[r].data) ;
    if (!h) return r ;
    r = (h < 0) ? s[r].left : s[r].right ;
  }
  return 0 ;
}
