/* Public domain. */

#include <stdlib.h>
#include "sysdeps.h"

#undef USE_DJBALLOC
#include "alloc.h"
#include "alloc_0.h"

#ifdef DEBUG_ALLOC
# include "fmtscan.h"
# include "strerr2.h"
#endif

aligned_char_ref alloc (unsigned int n)
{
#ifdef DEBUG_ALLOC
  {
    char fmt[ULONG_FMT] ;
    fmt[uint_fmt(fmt, n)] = 0 ;
    strerr_warnw3x("alloc(", fmt, ")") ;
  }
#endif
#ifdef HASMALLOC0
  return (aligned_char_ref)malloc(n) ;
#else
  return n ? (aligned_char_ref)malloc(n) : (aligned_char_ref)alloc_0 ;
#endif
}

void alloc_free (void *p)
{
#ifdef DEBUG_ALLOC
  strerr_warnw1x("alloc_free()") ;
#endif
#ifndef HASMALLOC0
  if ((unsigned char *)p == alloc_0) return ;
#endif
  free(p) ;
}

int alloc_realloc (unsigned char **x, unsigned int n)
{
#ifdef DEBUG_ALLOC
  {
    char fmt[ULONG_FMT] ;
    fmt[uint_fmt(fmt, n)] = 0 ;
    strerr_warnw3x("alloc_realloc(", fmt, ")") ;
  }
#endif
#ifdef HASMALLOC0
  aligned_char_ref y = n ? (aligned_char_ref)realloc(*x, n) : (free(*x), (aligned_char_ref)malloc(0)) ;
#else
  aligned_char_ref y = (*x == alloc_0) ? alloc(n) : n ? (aligned_char_ref)realloc(*x, n) : (free(*x), alloc_0) ;
#endif
  if (!y) return 0 ;
  *x = y ;
  return 1 ;
}

int alloc_re (unsigned char **x, unsigned int dummy, unsigned int n)
{
  (void)dummy ;
  return alloc_realloc(x, n) ;
}
