/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class StringDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    DatatypeValidator fBaseValidator = null;
    private int fLength = 0;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMinLength = 0;
    private String fPattern = null;
    private Vector fEnumeration = null;
    private int fFacetsDefined = 0;
    private short fWhiteSpace = 0;
    private RegularExpression fRegex = null;

    public StringDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public StringDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (string2.equals("length")) {
                    ++this.fFacetsDefined;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (string2.equals("minLength")) {
                    this.fFacetsDefined += 2;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMinLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("minLength value '" + string + "' is invalid.");
                    }
                    if (this.fMinLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("minLength value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (string2.equals("maxLength")) {
                    this.fFacetsDefined += 4;
                    string = (String)hashtable.get(string2);
                    try {
                        this.fMaxLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                    if (this.fMaxLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("maxLength value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (string2.equals("pattern")) {
                    this.fFacetsDefined += 8;
                    this.fPattern = (String)hashtable.get(string2);
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                if (string2.equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    this.fEnumeration = (Vector)hashtable.get(string2);
                    continue;
                }
                if (string2.equals("whiteSpace")) {
                    this.fFacetsDefined += 16384;
                    string = (String)hashtable.get(string2);
                    if (string.equals("replace")) {
                        this.fWhiteSpace = 1;
                        continue;
                    }
                    if (string.equals("collapse")) {
                        this.fWhiteSpace = (short)2;
                        continue;
                    }
                    this.fWhiteSpace = 0;
                    continue;
                }
                throw new InvalidDatatypeFacetException("invalid facet tag : " + string2);
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be less than the value of maxLength = '" + this.fMaxLength + "'.");
            }
        }
    }

    public short getWSFacet() {
        return this.fWhiteSpace;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        this.checkContent(string, object);
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    private void checkContent(String string, Object object) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            this.fBaseValidator.validate(string, object);
        }
        if ((this.fFacetsDefined & 4) != 0 && string.length() > this.fMaxLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + string.length() + "' exceeds maximum length facet of '" + this.fMaxLength + "'.");
        }
        if ((this.fFacetsDefined & 2) != 0 && string.length() < this.fMinLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + string.length() + "' is less than minimum length facet of '" + this.fMinLength + "'.");
        }
        if ((this.fFacetsDefined & 1) != 0 && string.length() != this.fLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + string.length() + "' is not equal to length facet '" + this.fLength + "'.");
        }
        if ((this.fFacetsDefined & 0x10) != 0 && !this.fEnumeration.contains(string)) {
            throw new InvalidDatatypeValueException("Value '" + string + "' must be one of " + this.fEnumeration);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value '" + string + "' does not match regular expression facet '" + this.fPattern + "'.");
        }
    }

    public int compare(String string, String string2) {
        Locale locale = Locale.getDefault();
        Collator collator = Collator.getInstance(locale);
        return collator.compare(string, string2);
    }

    public Object clone() throws CloneNotSupportedException {
        StringDatatypeValidator stringDatatypeValidator = null;
        try {
            stringDatatypeValidator = new StringDatatypeValidator();
            stringDatatypeValidator.fLocale = this.fLocale;
            stringDatatypeValidator.fBaseValidator = this.fBaseValidator;
            stringDatatypeValidator.fLength = this.fLength;
            stringDatatypeValidator.fMaxLength = this.fMaxLength;
            stringDatatypeValidator.fMinLength = this.fMinLength;
            stringDatatypeValidator.fPattern = this.fPattern;
            stringDatatypeValidator.fWhiteSpace = this.fWhiteSpace;
            stringDatatypeValidator.fEnumeration = this.fEnumeration;
            stringDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
        return stringDatatypeValidator;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }
}

