/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.GraphLayoutCache;

public class GraphUndoManager
extends UndoManager {
    public synchronized boolean canUndo(Object object) {
        if (this.isInProgress()) {
            UndoableEdit undoableEdit = this.editToBeUndone(object);
            return undoableEdit != null && undoableEdit.canUndo();
        }
        return super.canUndo();
    }

    public synchronized boolean canRedo(Object object) {
        if (this.isInProgress()) {
            UndoableEdit undoableEdit = this.editToBeRedone(object);
            return undoableEdit != null && undoableEdit.canRedo();
        }
        return super.canRedo();
    }

    public void undo(Object object) {
        if (object == null || !this.isInProgress()) {
            super.undo();
        } else {
            UndoableEdit undoableEdit = this.editToBeUndone(object);
            if (undoableEdit == null) {
                throw new CannotUndoException();
            }
            this.undoTo(undoableEdit);
        }
    }

    protected UndoableEdit editToBeUndone(Object object) {
        UndoableEdit undoableEdit = null;
        Object object2 = null;
        do {
            if ((undoableEdit = this.nextEditToBeUndone(undoableEdit)) instanceof GraphModelEvent.GraphViewChange) {
                object2 = ((GraphModelEvent.GraphViewChange)((Object)undoableEdit)).getSource();
            }
            if (object2 instanceof GraphLayoutCache) continue;
            object2 = null;
        } while (undoableEdit != null && object2 != null && object2 != object);
        return undoableEdit;
    }

    protected UndoableEdit nextEditToBeUndone(UndoableEdit undoableEdit) {
        if (undoableEdit == null) {
            return this.editToBeUndone();
        }
        int n = this.edits.indexOf(undoableEdit) - 1;
        if (n >= 0) {
            return this.edits.get(n);
        }
        return null;
    }

    public void redo(Object object) {
        if (object == null || !this.isInProgress()) {
            super.redo();
        } else {
            UndoableEdit undoableEdit = this.editToBeRedone(object);
            if (undoableEdit == null) {
                throw new CannotRedoException();
            }
            this.redoTo(undoableEdit);
        }
    }

    protected UndoableEdit editToBeRedone(Object object) {
        UndoableEdit undoableEdit = this.nextEditToBeRedone(null);
        UndoableEdit undoableEdit2 = null;
        Object object2 = null;
        do {
            undoableEdit2 = undoableEdit;
            if ((undoableEdit = this.nextEditToBeRedone(undoableEdit)) instanceof GraphModelEvent.GraphViewChange) {
                object2 = ((GraphModelEvent.GraphViewChange)((Object)undoableEdit)).getSource();
            }
            if (object2 instanceof GraphLayoutCache) continue;
            object2 = null;
        } while (undoableEdit != null && object2 != null && object2 != object);
        return undoableEdit2;
    }

    protected UndoableEdit nextEditToBeRedone(UndoableEdit undoableEdit) {
        if (undoableEdit == null) {
            return this.editToBeRedone();
        }
        int n = this.edits.indexOf(undoableEdit) + 1;
        if (n < this.edits.size()) {
            return this.edits.get(n);
        }
        return null;
    }
}

