/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.ThreadDataWindowPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ThreadDataWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private PPThread ppThread;
    private ParaProfTrial trial = null;
    private DataSorter dataSorter = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private JMenu optionsMenu = null;
    private JMenu windowsMenu = null;
    private JMenu unitsSubMenu = null;
    private JCheckBoxMenuItem sortByName = null;
    private JCheckBoxMenuItem descendingOrder = null;
    private JCheckBoxMenuItem showValuesAsPercent = null;
    private JCheckBoxMenuItem showPathTitleInReverse = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JLabel sliderMultipleLabel = new JLabel("Slider Multiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Multiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane sp = null;
    private ThreadDataWindowPanel panel = null;
    private Vector list = null;
    private boolean name = false;
    private int order = 0;
    private boolean percent = true;
    private int valueType = 2;
    private int units = 0;
    private boolean exclusivePercentOver100 = false;

    public ThreadDataWindow(ParaProfTrial paraProfTrial, int n, int n2, int n3, DataSorter dataSorter) {
        Object object;
        this.trial = paraProfTrial;
        this.dataSorter = dataSorter;
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        if (paraProfTrial.isDerivedMetric()) {
            this.percent = false;
        }
        if (n == -1) {
            object = paraProfTrial.getDataSource().getMeanData();
            this.ppThread = new PPThread((Thread)object, paraProfTrial);
        } else {
            object = paraProfTrial.getDataSource().getThread(n, n2, n3);
            this.ppThread = new PPThread((Thread)object, paraProfTrial);
        }
        ((Component)this).setLocation(new Point(300, 200));
        ((Component)this).setSize(new Dimension(700, 450));
        if (n == -1) {
            this.setTitle("Mean Data Window: " + paraProfTrial.getTrialIdentifier(true));
        } else {
            this.setTitle("n,c,t, " + n + "," + n2 + "," + n3 + " - " + paraProfTrial.getTrialIdentifier(true));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThreadDataWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.sortLocalData();
        object = new JMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu2 = new JMenu("File");
        jMenu = new JMenu("Save ...");
        jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenu);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addMenuListener(this);
        this.optionsMenu = new JMenu("Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.sortByName = new JCheckBoxMenuItem("Sort By Name", false);
        this.sortByName.addActionListener(this);
        this.optionsMenu.add(this.sortByName);
        this.descendingOrder = new JCheckBoxMenuItem("Descending Order", true);
        this.descendingOrder.addActionListener(this);
        this.optionsMenu.add(this.descendingOrder);
        this.showValuesAsPercent = new JCheckBoxMenuItem("Show Values as Percent", this.percent);
        this.showValuesAsPercent.addActionListener(this);
        this.optionsMenu.add(this.showValuesAsPercent);
        this.unitsSubMenu = new JMenu("Select Units");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("hr:min:sec", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Seconds", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Milliseconds", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Microseconds", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        this.unitsSubMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(this.unitsSubMenu);
        jMenu = new JMenu("Select Value Type");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Subroutines", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Per Call Value", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Display Sliders", false);
        jCheckBoxMenuItem.addActionListener(this);
        this.optionsMenu.add(jCheckBoxMenuItem);
        this.showPathTitleInReverse = new JCheckBoxMenuItem("Show Path Title in Reverse", true);
        this.showPathTitleInReverse.addActionListener(this);
        this.optionsMenu.add(this.showPathTitleInReverse);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.addMenuListener(this);
        this.windowsMenu = new JMenu("Windows");
        jMenuItem = new JMenuItem("Show ParaProf Manager");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Function Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Group Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show User Event Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Call Path Relations");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        this.windowsMenu.addMenuListener(this);
        JMenu jMenu3 = new JMenu("Help");
        jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenu3.addMenuListener(this);
        ((JMenuBar)object).add(jMenu2);
        ((JMenuBar)object).add(this.optionsMenu);
        ((JMenuBar)object).add(this.windowsMenu);
        ((JMenuBar)object).add(jMenu3);
        this.setJMenuBar((JMenuBar)object);
        this.contentPane = this.getContentPane();
        this.gbl = new GridBagLayout();
        this.contentPane.setLayout(this.gbl);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.panel = new ThreadDataWindowPanel(paraProfTrial, n, n2, n3, this);
        this.sp = new JScrollPane(this.panel);
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.setHeader();
        String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
        this.sliderMultiple = new JComboBox<String>(stringArray);
        this.sliderMultiple.addActionListener(this);
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(5);
        this.barLengthSlider.setMinorTickSpacing(1);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(true);
        this.barLengthSlider.addChangeListener(this);
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 0.95;
        this.gbc.weighty = 0.98;
        this.addCompItem(this.sp, this.gbc, 0, 0, 1, 1);
        ParaProf.incrementNumWindows();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    ParaProfUtils.print(this.panel);
                } else if (string.equals("Show ParaProf Manager")) {
                    ParaProfManagerWindow paraProfManagerWindow = new ParaProfManagerWindow();
                    paraProfManagerWindow.show();
                } else if (string.equals("Preferences...")) {
                    this.trial.getPreferences().showPreferencesWindow();
                } else if (string.equals("Save Image")) {
                    ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                    paraProfImageOutput.saveImage(this.panel);
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit ParaProf!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Sort By Name")) {
                    this.name = this.sortByName.isSelected();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Descending Order")) {
                    this.order = this.descendingOrder.isSelected() ? 0 : 1;
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Show Values as Percent")) {
                    this.percent = this.showValuesAsPercent.isSelected();
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Exclusive")) {
                    if (this.exclusivePercentOver100) {
                        this.percent = false;
                        this.showValuesAsPercent.setEnabled(false);
                        this.showValuesAsPercent.setSelected(false);
                    }
                    this.valueType = 2;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Inclusive")) {
                    this.valueType = 4;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Calls")) {
                    this.valueType = 6;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Subroutines")) {
                    this.valueType = 8;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Per Call Value")) {
                    this.valueType = 10;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Microseconds")) {
                    this.units = 0;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Milliseconds")) {
                    this.units = 1;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Seconds")) {
                    this.units = 2;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("hr:min:sec")) {
                    this.units = 3;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Display Sliders")) {
                    if (((JCheckBoxMenuItem)this.optionsMenu.getItem(5)).isSelected()) {
                        this.displaySiders(true);
                    } else {
                        this.displaySiders(false);
                    }
                } else if (string.equals("Show Path Title in Reverse")) {
                    if (this.nodeID == -1) {
                        this.setTitle("Mean Data Window: " + this.trial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                    } else {
                        this.setTitle("n,c,t, " + this.nodeID + "," + this.contextID + "," + this.threadID + " - " + this.trial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                    }
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                } else if (string.equals("Show Function Ledger")) {
                    new LedgerWindow(this.trial, 0).show();
                } else if (string.equals("Show Group Ledger")) {
                    new LedgerWindow(this.trial, 1).show();
                } else if (string.equals("Show User Event Ledger")) {
                    new LedgerWindow(this.trial, 2).show();
                } else if (string.equals("Show Call Path Relations")) {
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, -1, -1, -1, this.getDataSorter(), 2);
                    this.trial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    this.help(true);
                }
            } else if (object == this.sliderMultiple) {
                this.panel.changeInMultiples();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.changeInMultiples();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.valueType > 4) {
                this.showValuesAsPercent.setEnabled(false);
                this.unitsSubMenu.setEnabled(false);
            } else if (this.percent) {
                this.showValuesAsPercent.setEnabled(true);
                this.unitsSubMenu.setEnabled(false);
            } else if (this.trial.isTimeMetric()) {
                this.showValuesAsPercent.setEnabled(true);
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.showValuesAsPercent.setEnabled(true);
                this.unitsSubMenu.setEnabled(false);
            }
            if (this.valueType == 2 && this.exclusivePercentOver100) {
                this.percent = false;
                this.showValuesAsPercent.setEnabled(false);
            }
            if (this.trial.groupNamesPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.windowsMenu.getItem(3).setEnabled(true);
            } else {
                this.windowsMenu.getItem(3).setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            if (!this.trial.isTimeMetric()) {
                this.units = 0;
            }
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the thread data window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you the values for all functions on this thread.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right click on any function within this window to bring up a popup");
        ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
        ParaProf.helpWindow.writeText("for the function, or to show more details about the function.");
        ParaProf.helpWindow.writeText("You can also left click any function to highlight it in the system.");
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    private void sortLocalData() {
        this.list = this.name ? this.ppThread.getSortedFunctionProfiles(this.order, false) : this.ppThread.getSortedFunctionProfiles(this.valueType + this.order, false);
        if (this.ppThread.getMaxExclusivePercent() > 100.0) {
            this.exclusivePercentOver100 = true;
            this.percent = false;
        }
    }

    public Vector getData() {
        return this.list;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public int getValueType() {
        return this.valueType;
    }

    public int units() {
        if (this.valueType == 2 || this.valueType == 4) {
            return this.units;
        }
        return 0;
    }

    public Dimension getViewportSize() {
        return this.sp.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            Preferences preferences = this.trial.getPreferences();
            jTextArea.setFont(new Font(preferences.getParaProfFont(), preferences.getFontStyle(), preferences.getFontSize()));
            jTextArea.append(this.getHeaderString());
            this.sp.setColumnHeaderView(jTextArea);
        } else {
            this.sp.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.valueType > 5 || this.percent) {
            return "Metric Name: " + this.trial.getMetricName(this.trial.getSelectedMetricID()) + "\n" + "Value Type: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n";
        }
        return "Metric Name: " + this.trial.getMetricName(this.trial.getSelectedMetricID()) + "\n" + "Value Type: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.trial.isTimeMetric(), (boolean)this.trial.isDerivedMetric()) + "\n";
    }

    public int getSliderValue() {
        int n = -1;
        n = this.barLengthSlider.getValue();
        return n;
    }

    public double getSliderMultiple() {
        String string = null;
        string = (String)this.sliderMultiple.getSelectedItem();
        return Double.parseDouble(string);
    }

    private void displaySiders(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.sp);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultipleLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultiple, this.gbc, 1, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 2, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 3, 0, 1, 1);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.sp, this.gbc, 0, 1, 4, 1);
        } else {
            this.contentPane.remove(this.sliderMultipleLabel);
            this.contentPane.remove(this.sliderMultiple);
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.sp);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.sp, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public PPThread getPPThread() {
        return this.ppThread;
    }
}

