#   include <appUtilConfig.h>

#   include <utilJenkinsHash.h>

#   include "docRtf.h"

#   define ub4 UtilUint32
#   define ub2 UtilUint16
#   define ub1 unsigned char

#   define CHECKSTATE 8

/* smax= 1024, blen= 256 */

/* small adjustments to _a_ to make values distinct */
static const ub2 tab[] = {
674,746,654,821,515,0,674,165,311,821,0,515,331,447,192,50,
311,0,331,741,118,58,170,735,447,487,0,0,381,118,340,903,
0,50,0,381,0,331,331,0,340,98,77,253,674,311,801,192,
855,0,670,504,161,253,366,14,14,381,738,903,98,358,380,24,
516,50,192,0,769,114,658,193,369,192,0,571,578,165,210,447,
47,311,331,750,527,642,140,117,840,381,626,331,237,742,658,477,
117,670,89,515,183,98,796,258,311,0,340,834,58,340,674,515,
841,485,997,165,496,321,331,742,0,670,24,311,670,14,618,674,
8,382,25,0,635,581,351,674,434,340,769,821,358,571,552,348,
739,258,238,165,0,358,128,670,282,258,635,807,188,98,439,258,
258,273,169,674,879,123,386,0,999,488,674,475,487,529,331,740,
477,165,677,635,159,598,63,274,616,549,204,677,393,855,370,0,
670,997,626,706,769,98,674,340,954,496,373,549,529,409,516,515,
0,160,0,288,0,954,496,0,456,520,914,927,674,677,165,926,
24,647,258,736,18,0,693,626,328,0,813,641,1006,0,0,275,
618,579,71,449,640,821,38,715,901,347,192,311,277,711,981,709,
};

/* map back array */

static int mapBack[]=
    {
     786L,	/*     0: "dplinew" */
     327L,	/*     1: "trspdl" */
     566L,	/*     2: "deflang" */
      84L,	/*     3: "uldb" */
     168L,	/*     4: "tphmrg" */
     597L,	/*     5: "sprstsp" */
     368L,	/*     6: "tbllklastrow" */
     348L,	/*     7: "trbgcross" */
      36L,	/*     8: "pndbnuml" */
     171L,	/*     9: "tposx" */
     233L,	/*    10: "pnrxst" */
     371L,	/*    11: "irow" */
     148L,	/*    12: "bgfdiag" */
     712L,	/*    13: "piccropb" */
     444L,	/*    14: "ds" */
     326L,	/*    15: "trftsWidth" */
     360L,	/*    16: "trcbpat" */
     653L,	/*    17: "listoverridecount" */
      40L,	/*    18: "pndecd" */
     339L,	/*    19: "trpaddfl" */
     659L,	/*    20: "tqdec" */
     477L,	/*    21: "vertalt" */
     459L,	/*    22: "cols" */
     550L,	/*    23: "mac" */
     411L,	/*    24: "truncex" */
     719L,	/*    25: "picbmp" */
     258L,	/*    26: "ltrrow" */
     644L,	/*    27: "levelprevspace" */
     277L,	/*    28: "clbgvert" */
     489L,	/*    29: "ltrsect" */
     342L,	/*    30: "trpaddfb" */
     543L,	/*    31: "sbasedon" */
     113L,	/*    32: "favar" */
     787L,	/*    33: "dppolycount" */
     421L,	/*    34: "lnbrkrule" */
     800L,	/*    35: "dpptx" */
     679L,	/*    36: "jpegblip" */
     394L,	/*    37: "dgvorigin" */
     219L,	/*    38: "posyt" */
     204L,	/*    39: "posxl" */
      82L,	/*    40: "fcs" */
     802L,	/*    41: "shpleft" */
     611L,	/*    42: "level" */
      60L,	/*    43: "pnsp" */
     601L,	/*    44: "ight" */
     299L,	/*    45: "clftsWidth" */
     613L,	/*    46: "noline" */
     760L,	/*    47: "dobxmargin" */
      37L,	/*    48: "pndbnumt" */
     337L,	/*    49: "trpaddt" */
     545L,	/*    50: "sautoupd" */
     412L,	/*    51: "nolead" */
     429L,	/*    52: "nospaceforul" */
     538L,	/*    53: "aftnnrlc" */
     124L,	/*    54: "qc" */
     484L,	/*    55: "linemod" */
     234L,	/*    56: "tx" */
     804L,	/*    57: "shpbottom" */
     748L,	/*    58: "chftnsep" */
     407L,	/*    59: "pgbrdrl" */
     580L,	/*    60: "ltrdoc" */
     541L,	/*    61: "ftnalt" */
     681L,	/*    62: "dibitmap" */
     587L,	/*    63: "prcolbl" */
     568L,	/*    64: "fldalt" */
     253L,	/*    65: "aulw" */
     617L,	/*    66: "hr" */
     249L,	/*    67: "aul" */
     553L,	/*    68: "ansicpg" */
     731L,	/*    69: "ldblquote" */
      59L,	/*    70: "pnindent" */
     808L,	/*    71: "shpfhdr" */
     481L,	/*    72: "binsxn" */
     384L,	/*    73: "facingp" */
      87L,	/*    74: "webhidden" */
     774L,	/*    75: "dplinedash" */
     469L,	/*    76: "pgnx" */
     138L,	/*    77: "shading" */
     424L,	/*    78: "sprstsm" */
     221L,	/*    79: "dfrmtxtx" */
     521L,	/*    80: "aftnbj" */
      52L,	/*    81: "pnaiueo" */
     119L,	/*    82: "fi" */
     641L,	/*    83: "leveltemplateid" */
     501L,	/*    84: "sftnnar" */
     626L,	/*    85: "charrsid" */
     127L,	/*    86: "widctlpar" */
     649L,	/*    87: "listsimple" */
       5L,	/*    88: "b" */
     197L,	/*    89: "overlay" */
     344L,	/*    90: "trwWidthA" */
     270L,	/*    91: "clbgdkcross" */
     702L,	/*    92: "objscaley" */
     795L,	/*    93: "dpfillfggray" */
     765L,	/*    94: "dpcallout" */
     608L,	/*    95: "rtlgutter" */
     585L,	/*    96: "notabind" */
     537L,	/*    97: "aftnnauc" */
     470L,	/*    98: "pgny" */
     155L,	/*    99: "brdrl" */
     317L,	/*   100: "trqr" */
     467L,	/*   101: "pgnhnsm" */
     536L,	/*   102: "aftnnalc" */
      63L,	/*   103: "noproof" */
     528L,	/*   104: "aftnrestart" */
     792L,	/*   105: "dpfillfgcr" */
     518L,	/*   106: "aendnotes" */
     631L,	/*   107: "levelstartat" */
     268L,	/*   108: "clbgdcross" */
     504L,	/*   109: "sftnnrlc" */
     514L,	/*   110: "endnotes" */
     526L,	/*   111: "ftnrstcont" */
     236L,	/*   112: "ab" */
     744L,	/*   113: "line" */
      93L,	/*   114: "chbghoriz" */
      38L,	/*   115: "pndbnumk" */
     672L,	/*   116: "ftech" */
     728L,	/*   117: "emspace" */
     183L,	/*   118: "tposyb" */
     162L,	/*   119: "sbauto" */
     341L,	/*   120: "trpaddft" */
     382L,	/*   121: "paperw" */
     517L,	/*   122: "ftnbj" */
     770L,	/*   123: "dprect" */
     761L,	/*   124: "dobypage" */
     207L,	/*   125: "posxi" */
     607L,	/*   126: "ogutter" */
      70L,	/*   127: "dn" */
     753L,	/*   128: "chftn" */
     531L,	/*   129: "ftnnauc" */
     118L,	/*   130: "li" */
     413L,	/*   131: "msmcap" */
     180L,	/*   132: "tpvpg" */
     279L,	/*   133: "clcbpat" */
     475L,	/*   134: "vertalc" */
     241L,	/*   135: "af" */
     757L,	/*   136: "dolock" */
     772L,	/*   137: "dplinesolid" */
     486L,	/*   138: "linerestart" */
      89L,	/*   139: "expnd" */
     751L,	/*   140: "chpgn" */
     579L,	/*   141: "linkstyles" */
     356L,	/*   142: "trbgfdiag" */
     185L,	/*   143: "tposyil" */
     581L,	/*   144: "makebackup" */
     602L,	/*   145: "wraptrsp" */
     669L,	/*   146: "fmodern" */
     166L,	/*   147: "aspnum" */
     634L,	/*   148: "leveljcn" */
     769L,	/*   149: "dppolyline" */
      46L,	/*   150: "pngbnuml" */
     332L,	/*   151: "trspdfr" */
     190L,	/*   152: "tdfrmtxtRight" */
     797L,	/*   153: "dpfillbgcg" */
     201L,	/*   154: "phcol" */
     727L,	/*   155: "emdash" */
     593L,	/*   156: "revprot" */
     785L,	/*   157: "dpysize" */
     111L,	/*   158: "facenter" */
     694L,	/*   159: "objicemb" */
     287L,	/*   160: "cltxlrtb" */
     666L,	/*   161: "fnil" */
     818L,	/*   162: "shpwrk" */
       3L,	/*   163: "cf" */
      24L,	/*   164: "pndec" */
     773L,	/*   165: "dplinehollow" */
     718L,	/*   166: "wbmwidthbytes" */
     425L,	/*   167: "noxlattoyen" */
     445L,	/*   168: "titlepg" */
     388L,	/*   169: "jcompress" */
     551L,	/*   170: "pc" */
     173L,	/*   171: "tposxl" */
     227L,	/*   172: "pnrnot" */
     622L,	/*   173: "yr" */
     315L,	/*   174: "trautofit" */
     151L,	/*   175: "cfpat" */
     625L,	/*   176: "delrsid" */
     322L,	/*   177: "trbrdrr" */
     335L,	/*   178: "trpaddl" */
     558L,	/*   179: "langfe" */
     410L,	/*   180: "pgbrdrfoot" */
     548L,	/*   181: "spersonal" */
     359L,	/*   182: "trcfpat" */
     340L,	/*   183: "trpaddfr" */
     149L,	/*   184: "bghoriz" */
     642L,	/*   185: "levelold" */
      11L,	/*   186: "caps" */
      48L,	/*   187: "pnzodiac" */
     632L,	/*   188: "levelnfcn" */
     794L,	/*   189: "dpfillfgcb" */
     509L,	/*   190: "saftnnauc" */
     796L,	/*   191: "dpfillbgcr" */
     762L,	/*   192: "dobypara" */
     534L,	/*   193: "ftnnchi" */
     605L,	/*   194: "viewscale" */
     598L,	/*   195: "subfontbysize" */
     353L,	/*   196: "trbgdkfdiag" */
     709L,	/*   197: "objcropl" */
     680L,	/*   198: "emfblip" */
     455L,	/*   199: "pgnlcltr" */
     174L,	/*   200: "tposxr" */
     142L,	/*   201: "bgdkbdiag" */
     136L,	/*   202: "hyphpar" */
     158L,	/*   203: "brdrbtw" */
     146L,	/*   204: "bgdkhoriz" */
     683L,	/*   205: "pmmetafile" */
      31L,	/*   206: "pnordt" */
     498L,	/*   207: "sftnrstcont" */
     758L,	/*   208: "dobxpage" */
     456L,	/*   209: "pgncont" */
     176L,	/*   210: "tposxi" */
     139L,	/*   211: "bgbdiag" */
     101L,	/*   212: "chbgdkfdiag" */
     210L,	/*   213: "pvpara" */
     260L,	/*   214: "cellx" */
     685L,	/*   215: "rslttxt" */
     237L,	/*   216: "acaps" */
     559L,	/*   217: "langfenp" */
     141L,	/*   218: "bgdcross" */
     399L,	/*   219: "deftab" */
     552L,	/*   220: "pca" */
     402L,	/*   221: "stshfloch" */
     724L,	/*   222: "rsltmerge" */
     433L,	/*   223: "pnulnone" */
     211L,	/*   224: "pvpg" */
     462L,	/*   225: "sectdefaultcl" */
     508L,	/*   226: "saftnnalc" */
     474L,	/*   227: "vertalb" */
     267L,	/*   228: "clbgcross" */
      16L,	/*   229: "pncf" */
     434L,	/*   230: "sectd" */
     809L,	/*   231: "shpbxpage" */
     494L,	/*   232: "sftnstart" */
     756L,	/*   233: "chdpl" */
     766L,	/*   234: "dpellipse" */
      95L,	/*   235: "chbgfdiag" */
     788L,	/*   236: "dplinecor" */
      51L,	/*   237: "pnchosung" */
     670L,	/*   238: "fscript" */
     365L,	/*   239: "tbllkcolor" */
     674L,	/*   240: "cpg" */
     729L,	/*   241: "endash" */
      43L,	/*   242: "pnganada" */
      15L,	/*   243: "pnfs" */
     318L,	/*   244: "trqc" */
     571L,	/*   245: "formshade" */
     660L,	/*   246: "tldot" */
      45L,	/*   247: "pngbnumd" */
     259L,	/*   248: "rtlrow" */
     400L,	/*   249: "deff" */
     443L,	/*   250: "guttersxn" */
      53L,	/*   251: "pnaiueod" */
     431L,	/*   252: "pnuld" */
     230L,	/*   253: "pnrrgb" */
     324L,	/*   254: "trbrdrv" */
     554L,	/*   255: "itap" */
     372L,	/*   256: "irowband" */
     733L,	/*   257: "ltrmark" */
      39L,	/*   258: "pncnum" */
     278L,	/*   259: "clcfpat" */
     202L,	/*   260: "posx" */
     750L,	/*   261: "chdate" */
     686L,	/*   262: "rsltpict" */
     775L,	/*   263: "dplinedot" */
     437L,	/*   264: "pgwsxn" */
     665L,	/*   265: "jclisttab" */
     248L,	/*   266: "astrike" */
      57L,	/*   267: "pnqc" */
     449L,	/*   268: "sbkeven" */
     578L,	/*   269: "linestart" */
     397L,	/*   270: "dgmargin" */
     703L,	/*   271: "picscalex" */
     779L,	/*   272: "dparcflipx" */
     556L,	/*   273: "rin" */
     576L,	/*   274: "hyphhotz" */
     740L,	/*   275: "softpage" */
     507L,	/*   276: "saftnnar" */
     212L,	/*   277: "posy" */
     560L,	/*   278: "nolnhtadjtbl" */
     312L,	/*   279: "trhdr" */
     464L,	/*   280: "pgnhnsh" */
      81L,	/*   281: "shad" */
     231L,	/*   282: "pnrstart" */
     767L,	/*   283: "dpline" */
     117L,	/*   284: "ls" */
     229L,	/*   285: "pnrpnbr" */
      19L,	/*   286: "pnul" */
     722L,	/*   287: "blipupi" */
     747L,	/*   288: "column" */
     478L,	/*   289: "sectlinegrid" */
     783L,	/*   290: "dodhgt" */
     358L,	/*   291: "trbgvert" */
     569L,	/*   292: "formdisp" */
     451L,	/*   293: "pgndec" */
     592L,	/*   294: "revprop" */
     492L,	/*   295: "sftntj" */
     635L,	/*   296: "leveljc" */
     583L,	/*   297: "nocolbal" */
     723L,	/*   298: "objsetsize" */
     782L,	/*   299: "dpy" */
      27L,	/*   300: "pnucltr" */
     746L,	/*   301: "page" */
      80L,	/*   302: "ltrch" */
     564L,	/*   303: "cvmme" */
     423L,	/*   304: "oldas" */
     483L,	/*   305: "linecont" */
     735L,	/*   306: "rquote" */
     701L,	/*   307: "objscalex" */
     700L,	/*   308: "pichgoal" */
     316L,	/*   309: "trql" */
      58L,	/*   310: "pnqr" */
     448L,	/*   311: "sbkpage" */
     741L,	/*   312: "zwj" */
     161L,	/*   313: "adjustleft" */
     652L,	/*   314: "liststyleid" */
     416L,	/*   315: "htmautsp" */
     588L,	/*   316: "printdata" */
      29L,	/*   317: "pnord" */
     373L,	/*   318: "ts" */
     519L,	/*   319: "aenddoc" */
     361L,	/*   320: "trshdng" */
     807L,	/*   321: "shpz" */
     304L,	/*   322: "clpadft" */
     780L,	/*   323: "dparcflipy" */
     262L,	/*   324: "clbrdrt" */
     755L,	/*   325: "chdpa" */
      92L,	/*   326: "highlight" */
     314L,	/*   327: "trkeepfollow" */
     226L,	/*   328: "pnrdate" */
      33L,	/*   329: "pndbnumd" */
     664L,	/*   330: "tleq" */
     169L,	/*   331: "tphpg" */
     214L,	/*   332: "posyb" */
     329L,	/*   333: "trspdt" */
     781L,	/*   334: "dpx" */
     557L,	/*   335: "langnp" */
     689L,	/*   336: "objemb" */
     362L,	/*   337: "tbllkborder" */
     497L,	/*   338: "sftnrestart" */
     637L,	/*   339: "levellegal" */
     255L,	/*   340: "loch" */
     364L,	/*   341: "tbllkfont" */
     812L,	/*   342: "shpbxignore" */
     147L,	/*   343: "bgdkvert" */
     333L,	/*   344: "trspdft" */
     479L,	/*   345: "endnhere" */
     684L,	/*   346: "rsltrtf" */
      79L,	/*   347: "rtlch" */
     487L,	/*   348: "linestarts" */
      62L,	/*   349: "lang" */
     732L,	/*   350: "lquote" */
     814L,	/*   351: "shpbymargin" */
     194L,	/*   352: "absh" */
     673L,	/*   353: "fcharset" */
     510L,	/*   354: "saftnnrlc" */
     288L,	/*   355: "cltxtbrl" */
     292L,	/*   356: "clmgf" */
     816L,	/*   357: "shpbyignore" */
     208L,	/*   358: "posxo" */
     116L,	/*   359: "s" */
     346L,	/*   360: "trftsWidthA" */
      41L,	/*   361: "pnaiud" */
     379L,	/*   362: "margt" */
     393L,	/*   363: "dghorigin" */
     453L,	/*   364: "pgnlcrm" */
     120L,	/*   365: "ri" */
     570L,	/*   366: "formprot" */
      83L,	/*   367: "uld" */
     627L,	/*   368: "sectrsid" */
     403L,	/*   369: "stshfhich" */
     386L,	/*   370: "twoonone" */
     584L,	/*   371: "noextrasprl" */
     282L,	/*   372: "clcbpatraw" */
     387L,	/*   373: "psz" */
     678L,	/*   374: "pngblip" */
     805L,	/*   375: "shpright" */
     777L,	/*   376: "dplinedadodo" */
       6L,	/*   377: "i" */
     417L,	/*   378: "useltbaln" */
     102L,	/*   379: "chbgdkbdiag" */
     205L,	/*   380: "posxr" */
      65L,	/*   381: "up" */
      30L,	/*   382: "pncard" */
     491L,	/*   383: "sectunlocked" */
     264L,	/*   384: "clbrdrl" */
     108L,	/*   385: "chshdng" */
     699L,	/*   386: "picwgoal" */
     776L,	/*   387: "dplinedado" */
      71L,	/*   388: "outl" */
     654L,	/*   389: "listoverridestartat" */
     129L,	/*   390: "keepn" */
     671L,	/*   391: "fdecor" */
     472L,	/*   392: "colno" */
     370L,	/*   393: "tbllklastcol" */
     126L,	/*   394: "nowidctlpar" */
     347L,	/*   395: "trbgbdiag" */
      12L,	/*   396: "scaps" */
     297L,	/*   397: "clshdrawnil" */
     458L,	/*   398: "pgnstarts" */
     790L,	/*   399: "dplinecob" */
     471L,	/*   400: "linex" */
       0L,	/*   401: "plain" */
     246L,	/*   402: "ascaps" */
     499L,	/*   403: "saftnrstcont" */
     351L,	/*   404: "trbgdkcross" */
     272L,	/*   405: "clbgdkfdiag" */
     572L,	/*   406: "fracwidth" */
     217L,	/*   407: "posyin" */
     734L,	/*   408: "rdblquote" */
     181L,	/*   409: "tposy" */
     710L,	/*   410: "objcropr" */
     132L,	/*   411: "sl" */
     691L,	/*   412: "objautlink" */
     128L,	/*   413: "keep" */
     238L,	/*   414: "acf" */
     130L,	/*   415: "sb" */
     159L,	/*   416: "brdrbar" */
     137L,	/*   417: "intbl" */
     206L,	/*   418: "posxc" */
     657L,	/*   419: "tqr" */
     122L,	/*   420: "qr" */
     623L,	/*   421: "insrsid" */
     294L,	/*   422: "clvmgf" */
      26L,	/*   423: "pnlcrm" */
     415L,	/*   424: "ftnlytwnine" */
     133L,	/*   425: "slmult" */
     495L,	/*   426: "saftnstart" */
      32L,	/*   427: "pndbnum" */
     643L,	/*   428: "levelprev" */
     505L,	/*   429: "sftnnruc" */
     742L,	/*   430: "zwnj" */
      10L,	/*   431: "nosupersub" */
     291L,	/*   432: "cltxtbrlv" */
     473L,	/*   433: "colsr" */
     242L,	/*   434: "afs" */
      23L,	/*   435: "pnstart" */
     529L,	/*   436: "ftnnar" */
     563L,	/*   437: "brkfrm" */
     547L,	/*   438: "ssemihidden" */
     175L,	/*   439: "tposxc" */
     104L,	/*   440: "chbgdkdcross" */
     215L,	/*   441: "posyc" */
     391L,	/*   442: "dghspace" */
     325L,	/*   443: "trwWidth" */
     366L,	/*   444: "tbllkbestfit" */
     266L,	/*   445: "clbgbdiag" */
      22L,	/*   446: "pnstrike" */
     565L,	/*   447: "defformat" */
     633L,	/*   448: "levelnfc" */
     184L,	/*   449: "tposyc" */
     806L,	/*   450: "shplid" */
     698L,	/*   451: "objh" */
     363L,	/*   452: "tbllkshading" */
     300L,	/*   453: "clpadt" */
     114L,	/*   454: "fafixed" */
     789L,	/*   455: "dplinecog" */
     450L,	/*   456: "sbkodd" */
     182L,	/*   457: "tposnegy" */
     343L,	/*   458: "trwWidthB" */
     515L,	/*   459: "enddoc" */
     640L,	/*   460: "fbias" */
     311L,	/*   461: "trrh" */
     200L,	/*   462: "phpg" */
     738L,	/*   463: "softlheight" */
     243L,	/*   464: "ai" */
     621L,	/*   465: "mo" */
     269L,	/*   466: "clbgdkbdiag" */
     720L,	/*   467: "picbpp" */
     524L,	/*   468: "ftnrstpg" */
      35L,	/*   469: "pniroha" */
     435L,	/*   470: "headery" */
     338L,	/*   471: "trpaddb" */
     715L,	/*   472: "bliptag" */
     463L,	/*   473: "pgnhn" */
     418L,	/*   474: "alntblind" */
     170L,	/*   475: "tphcol" */
     330L,	/*   476: "trspdb" */
     582L,	/*   477: "margmirror" */
     599L,	/*   478: "swpbdr" */
      75L,	/*   479: "revauthdel" */
     323L,	/*   480: "trbrdrh" */
     596L,	/*   481: "sprsspbf" */
     577L,	/*   482: "landscape" */
     310L,	/*   483: "trleft" */
     493L,	/*   484: "sftnbj" */
     717L,	/*   485: "wbmplanes" */
     609L,	/*   486: "deflangfe" */
     389L,	/*   487: "jexpand" */
     817L,	/*   488: "shpwr" */
     349L,	/*   489: "trbgdcross" */
     778L,	/*   490: "dpfillpat" */
     544L,	/*   491: "snext" */
     432L,	/*   492: "pnuldb" */
     801L,	/*   493: "dppty" */
     367L,	/*   494: "tbllkhdrrows" */
     813L,	/*   495: "shpbypage" */
      76L,	/*   496: "revdttm" */
     319L,	/*   497: "trbrdrt" */
     134L,	/*   498: "outlinelevel" */
     422L,	/*   499: "bdrrlswsix" */
     725L,	/*   500: "bullet" */
     721L,	/*   501: "pictscaled" */
     595L,	/*   502: "sprslnsp" */
     650L,	/*   503: "listhybrid" */
     303L,	/*   504: "clpadr" */
      77L,	/*   505: "revdttmdel" */
     244L,	/*   506: "alang" */
     513L,	/*   507: "fet" */
     661L,	/*   508: "tlul" */
     276L,	/*   509: "clbghoriz" */
     375L,	/*   510: "pgbrdropt" */
     465L,	/*   511: "pgnhnsp" */
     110L,	/*   512: "fahang" */
     143L,	/*   513: "bgdkcross" */
     726L,	/*   514: "chatn" */
      78L,	/*   515: "revised" */
     567L,	/*   516: "doctemp" */
     663L,	/*   517: "tlth" */
     265L,	/*   518: "clbrdrr" */
     199L,	/*   519: "phmrg" */
      17L,	/*   520: "pnb" */
     321L,	/*   521: "trbrdrl" */
     115L,	/*   522: "pard" */
     752L,	/*   523: "chtime" */
     313L,	/*   524: "trkeep" */
     490L,	/*   525: "rtlsect" */
      56L,	/*   526: "pnql" */
      99L,	/*   527: "chbgdkhoriz" */
     561L,	/*   528: "allprot" */
     549L,	/*   529: "ansi" */
     376L,	/*   530: "pgbrdrsnap" */
     307L,	/*   531: "clpadfr" */
     135L,	/*   532: "ilvl" */
      72L,	/*   533: "revauth" */
     730L,	/*   534: "enspace" */
     167L,	/*   535: "tabsnoovrlp" */
     532L,	/*   536: "ftnnrlc" */
     638L,	/*   537: "levelnorestart" */
     745L,	/*   538: "lbr" */
      54L,	/*   539: "pnbidia" */
     606L,	/*   540: "lytprtmet" */
     819L,	/*   541: "shpfblwtxt" */
     355L,	/*   542: "trbgdkvert" */
     535L,	/*   543: "aftnnar" */
       2L,	/*   544: "fs" */
     749L,	/*   545: "chftnsepc" */
     131L,	/*   546: "sa" */
     251L,	/*   547: "auldb" */
      44L,	/*   548: "pngbnum" */
     385L,	/*   549: "widowctrl" */
     799L,	/*   550: "dpfillbggray" */
     708L,	/*   551: "objcropb" */
     542L,	/*   552: "additive" */
      74L,	/*   553: "crdate" */
      61L,	/*   554: "pnprev" */
      13L,	/*   555: "strike" */
     290L,	/*   556: "cltxlrtbv" */
     736L,	/*   557: "rtlmark" */
     574L,	/*   558: "hyphcaps" */
     616L,	/*   559: "subdocument" */
     405L,	/*   560: "pgbrdrt" */
     263L,	/*   561: "clbrdrb" */
     713L,	/*   562: "piccropl" */
     187L,	/*   563: "tposyout" */
     289L,	/*   564: "cltxbtlr" */
     306L,	/*   565: "clpadfl" */
     220L,	/*   566: "dxfrtext" */
     677L,	/*   567: "wmetafile" */
     692L,	/*   568: "objsub" */
     254L,	/*   569: "aup" */
     305L,	/*   570: "clpadfb" */
     620L,	/*   571: "dy" */
     381L,	/*   572: "paperh" */
     485L,	/*   573: "lineppage" */
     743L,	/*   574: "tab" */
     466L,	/*   575: "pgnhnsc" */
     791L,	/*   576: "dplinegray" */
     771L,	/*   577: "dptxbx" */
     646L,	/*   578: "levelspace" */
     369L,	/*   579: "tbllkhdrcols" */
     704L,	/*   580: "picscaley" */
      94L,	/*   581: "chbgvert" */
     245L,	/*   582: "aoutl" */
     480L,	/*   583: "binfsxn" */
     296L,	/*   584: "clNoWrap" */
     502L,	/*   585: "sftnnalc" */
     612L,	/*   586: "ltrpar" */
     488L,	/*   587: "lndscpsxn" */
       9L,	/*   588: "super" */
     144L,	/*   589: "bgdkdcross" */
     409L,	/*   590: "pgbrdrhead" */
     152L,	/*   591: "cbpat" */
     121L,	/*   592: "ql" */
     157L,	/*   593: "box" */
     614L,	/*   594: "rtlpar" */
     546L,	/*   595: "shidden" */
     589L,	/*   596: "psover" */
     512L,	/*   597: "saftnnchi" */
      50L,	/*   598: "pnzodiacl" */
     427L,	/*   599: "noultrlspc" */
     398L,	/*   600: "pgnstart" */
     533L,	/*   601: "ftnnruc" */
     401L,	/*   602: "stshfdbch" */
     815L,	/*   603: "shpbypara" */
     496L,	/*   604: "sftnrstpg" */
     383L,	/*   605: "gutter" */
     100L,	/*   606: "chbgdkvert" */
     430L,	/*   607: "pnhang" */
      55L,	/*   608: "pnbidib" */
     555L,	/*   609: "lin" */
     618L,	/*   610: "min" */
     392L,	/*   611: "dgvspace" */
       4L,	/*   612: "cs" */
      97L,	/*   613: "chbgcross" */
     629L,	/*   614: "tblrsid" */
     503L,	/*   615: "sftnnauc" */
     527L,	/*   616: "aftnrstcont" */
     624L,	/*   617: "rsidroot" */
     222L,	/*   618: "dfrmtxty" */
      69L,	/*   619: "deleted" */
     716L,	/*   620: "wbmbitspixel" */
     395L,	/*   621: "dghshow" */
      47L,	/*   622: "pngbnumk" */
     693L,	/*   623: "objpub" */
     768L,	/*   624: "dppolygon" */
     196L,	/*   625: "nowrap" */
     442L,	/*   626: "margbsxn" */
     648L,	/*   627: "listtemplateid" */
     667L,	/*   628: "froman" */
     820L,	/*   629: "shplockanchor" */
     630L,	/*   630: "styrsid" */
     232L,	/*   631: "pnrstop" */
      73L,	/*   632: "crauth" */
     404L,	/*   633: "stshfbi" */
     737L,	/*   634: "softcol" */
     476L,	/*   635: "vertalj" */
     662L,	/*   636: "tlhyph" */
     378L,	/*   637: "margr" */
     240L,	/*   638: "aexpnd" */
     352L,	/*   639: "trbgdkdcross" */
     193L,	/*   640: "absw" */
     426L,	/*   641: "expshrtn" */
     803L,	/*   642: "shptop" */
      34L,	/*   643: "pnaiu" */
     636L,	/*   644: "levelfollow" */
      18L,	/*   645: "pni" */
     530L,	/*   646: "ftnnalc" */
      68L,	/*   647: "cchs" */
     688L,	/*   648: "rslthtml" */
     658L,	/*   649: "tqc" */
      66L,	/*   650: "cgrid" */
     651L,	/*   651: "listrestarthdn" */
     705L,	/*   652: "picw" */
       7L,	/*   653: "ul" */
     328L,	/*   654: "trspdr" */
     357L,	/*   655: "trbghoriz" */
     252L,	/*   656: "aulnone" */
     216L,	/*   657: "posyil" */
     706L,	/*   658: "pich" */
      25L,	/*   659: "pnucrm" */
     198L,	/*   660: "absnoovrlp" */
     575L,	/*   661: "hyphconsec" */
      14L,	/*   662: "pnf" */
     810L,	/*   663: "shpbxmargin" */
     281L,	/*   664: "clcfpatraw" */
      28L,	/*   665: "pnlcltr" */
     295L,	/*   666: "clvmrg" */
     696L,	/*   667: "objocx" */
     345L,	/*   668: "trftsWidthB" */
     610L,	/*   669: "uc" */
      96L,	/*   670: "chbgbdiag" */
      20L,	/*   671: "pncaps" */
     103L,	/*   672: "chbgdkcross" */
     714L,	/*   673: "piccropr" */
      64L,	/*   674: "ulnone" */
     301L,	/*   675: "clpadb" */
     628L,	/*   676: "pararsid" */
     406L,	/*   677: "pgbrdrb" */
     188L,	/*   678: "tposyt" */
     308L,	/*   679: "trowd" */
     218L,	/*   680: "posyout" */
     239L,	/*   681: "adn" */
     690L,	/*   682: "objlink" */
     500L,	/*   683: "saftnrestart" */
     562L,	/*   684: "annotprot" */
     525L,	/*   685: "ftnrestart" */
     273L,	/*   686: "clbgdkhor" */
     285L,	/*   687: "clvertalc" */
     186L,	/*   688: "tposyin" */
     178L,	/*   689: "tpvmrg" */
     112L,	/*   690: "faroman" */
     377L,	/*   691: "margl" */
     350L,	/*   692: "trbgdkbdiag" */
     225L,	/*   693: "pnrauth" */
     177L,	/*   694: "tposxo" */
     156L,	/*   695: "brdrr" */
     604L,	/*   696: "viewkind" */
     414L,	/*   697: "splytwnine" */
     172L,	/*   698: "tposnegx" */
     482L,	/*   699: "linebetcol" */
     163L,	/*   700: "saauto" */
     615L,	/*   701: "sbys" */
     436L,	/*   702: "footery" */
     189L,	/*   703: "tdfrmtxtLeft" */
     105L,	/*   704: "chbrdr" */
     191L,	/*   705: "tdfrmtxtTop" */
     811L,	/*   706: "shpbxcolumn" */
      98L,	/*   707: "chbgdcross" */
     506L,	/*   708: "sftnnchi" */
     165L,	/*   709: "aspalpha" */
      42L,	/*   710: "pnirohad" */
     257L,	/*   711: "dbch" */
      86L,	/*   712: "v" */
     763L,	/*   713: "dobymargin" */
     452L,	/*   714: "pgnucrm" */
     390L,	/*   715: "horzdoc" */
     439L,	/*   716: "marglsxn" */
     336L,	/*   717: "trpaddr" */
     711L,	/*   718: "piccropt" */
     516L,	/*   719: "ftntj" */
     354L,	/*   720: "trbgdkhor" */
     687L,	/*   721: "rsltbmp" */
     203L,	/*   722: "posnegx" */
     798L,	/*   723: "dpfillbgcb" */
     676L,	/*   724: "macpict" */
     247L,	/*   725: "ashad" */
     594L,	/*   726: "rtldoc" */
     195L,	/*   727: "abslock" */
     668L,	/*   728: "fswiss" */
     293L,	/*   729: "clmrg" */
     428L,	/*   730: "dntblnsbdb" */
     441L,	/*   731: "margrsxn" */
     160L,	/*   732: "adjustright" */
     261L,	/*   733: "celld" */
     695L,	/*   734: "objhtml" */
      49L,	/*   735: "pnzodiacd" */
     280L,	/*   736: "clshdng" */
     603L,	/*   737: "viewzk" */
     573L,	/*   738: "hyphauto" */
     275L,	/*   739: "clbgfdiag" */
     739L,	/*   740: "softline" */
     309L,	/*   741: "trgaph" */
     154L,	/*   742: "brdrb" */
     520L,	/*   743: "aftntj" */
     764L,	/*   744: "dparc" */
     213L,	/*   745: "posnegy" */
     334L,	/*   746: "trspdfb" */
     150L,	/*   747: "bgvert" */
     682L,	/*   748: "wbitmap" */
     440L,	/*   749: "margtsxn" */
     107L,	/*   750: "chcfpat" */
      21L,	/*   751: "pnscaps" */
     145L,	/*   752: "bgdkfdiag" */
     446L,	/*   753: "sbknone" */
     396L,	/*   754: "dgvshow" */
      67L,	/*   755: "cb" */
     408L,	/*   756: "pgbrdrr" */
      85L,	/*   757: "ulw" */
     109L,	/*   758: "faauto" */
     511L,	/*   759: "saftnnruc" */
     274L,	/*   760: "clbgdkvert" */
     647L,	/*   761: "listid" */
     438L,	/*   762: "pghsxn" */
     223L,	/*   763: "dropcapli" */
     461L,	/*   764: "colw" */
     454L,	/*   765: "pgnucltr" */
     209L,	/*   766: "pvmrg" */
      90L,	/*   767: "expndtw" */
     590L,	/*   768: "revbar" */
     468L,	/*   769: "pgnhnsn" */
     675L,	/*   770: "fprq" */
     447L,	/*   771: "sbkcol" */
     619L,	/*   772: "sec" */
     457L,	/*   773: "pgnrestart" */
     460L,	/*   774: "colsx" */
     759L,	/*   775: "dobxcolumn" */
     645L,	/*   776: "levelindent" */
      91L,	/*   777: "charscalex" */
     140L,	/*   778: "bgcross" */
     271L,	/*   779: "clbgdkdcross" */
     284L,	/*   780: "clvertalt" */
     656L,	/*   781: "tql" */
     639L,	/*   782: "levelpicture" */
     228L,	/*   783: "pnrnfc" */
       1L,	/*   784: "f" */
     153L,	/*   785: "brdrt" */
     522L,	/*   786: "ftnstart" */
     754L,	/*   787: "sectnum" */
     591L,	/*   788: "revisions" */
     235L,	/*   789: "tb" */
     540L,	/*   790: "aftnnchi" */
     420L,	/*   791: "lyttblrtgr" */
     586L,	/*   792: "otblrul" */
     697L,	/*   793: "objw" */
     320L,	/*   794: "trbrdrb" */
       8L,	/*   795: "sub" */
     125L,	/*   796: "pagebb" */
     302L,	/*   797: "clpadl" */
      88L,	/*   798: "kerning" */
     298L,	/*   799: "clwWidth" */
     192L,	/*   800: "tdfrmtxtBottom" */
     655L,	/*   801: "listoverrideformat" */
     380L,	/*   802: "margb" */
     374L,	/*   803: "lastrow" */
     106L,	/*   804: "chcbpat" */
     707L,	/*   805: "objcropt" */
     224L,	/*   806: "dropcapt" */
     523L,	/*   807: "aftnstart" */
     123L,	/*   808: "qj" */
     600L,	/*   809: "transmf" */
     250L,	/*   810: "auld" */
     179L,	/*   811: "tpvpara" */
     331L,	/*   812: "trspdfl" */
     164L,	/*   813: "nooverflow" */
     793L,	/*   814: "dpfillfgcg" */
     784L,	/*   815: "dpxsize" */
     419L,	/*   816: "lytcalctblwd" */
     539L,	/*   817: "aftnnruc" */
     283L,	/*   818: "clshdngraw" */
     286L,	/*   819: "clvertalb" */
     256L,	/*   820: "hich" */
    };

/* The hash function */

unsigned long docRtfTagHash(const unsigned char * key, int len )
{
    const ub4 initlev= 0x8bc994ff;
    ub4 rsl= 0;
    ub4 val = utilJenkinsHash( key, len, initlev );
    rsl = ((val>>24)^tab[val&0xff]);
    return rsl;
}

int docRtfTagIndex( const unsigned char * key, int len )
{
    ub4 rsl= docRtfTagHash( key, len );

    if  ( rsl >= sizeof(mapBack)/sizeof(int) )
	{ return -1;	}

    return mapBack[rsl];
}

