require 'tempura/template'

# Parse command line arguments for the lang variable.
lang = ARGV.shift
if not %w(ja en).include? lang then
  $stderr.puts "usage ruby [-I../../lib] #{File.basename(__FILE__)} (ja|en)"
  exit 0
end

# Define a model class (simple container) for this sample script.
require 'model'

# Instantiate a model object for this sample script. Add some items
# into the model object which is a container.
data = Model.new
data.add_item( 'TEMPURA', 12 )
data.add_item( 'SUKIYAKI', 24 )
data.add_item( 'SUSHI', 30 )
data.add_item( 'UNAJU (JOU)', 18 )
data.add_item( 'TEMPURA SOBA', 5 )

# Instantiate a template object.
tmpl = Tempura::Template.new
tmpl.set "view.en.html"                             # default template
tmpl.set "view.ja.html", "ja", Tempura::CharConvEUC # optional template for a Japanese speaker

# (optional) specify an url for an event dispatcher program or etc.
tmpl.default_action = "myapp.cgi"

# Expand a template into a real view. 1st parameter is a model
# data. 2nd parameter decides on which template is selected.
real_view = tmpl.expand( data, lang )

puts real_view
